/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringCompressor;

public class EntityRequest
extends RequestWithConfirmation<Integer> {
    public static final int OPCODE_QUERY_ENTITIES_BY_NAMES = 1;
    public static final int ERROR_NO_PROVIDER = -1;
    public static final int ERROR_ILLEGAL_OPCODE = -2;
    private int opcode;
    private BiConsumer<String, Entity> entityHandler;
    private String namespace;
    private String[] names;

    private EntityRequest(SignalProtocol<?> protocol, int opcode) {
        super(protocol, (short)-6);
        this.opcode = opcode;
    }

    public EntityRequest(SignalProtocol<?> protocol, BiConsumer<String, Entity> entityHandler, String namespace, String ... names) {
        this(protocol, 1);
        this.entityHandler = entityHandler;
        this.namespace = namespace;
        this.names = names;
    }

    @Override
    protected void requesting(ExtendedDataOutputStream out) throws Exception {
        out.writeVarInt(this.opcode);
        switch (this.opcode) {
            case 1: {
                this.writeCompressedString(out, this.namespace);
                EntityRequest.writeStrings(out, this.names);
                break;
            }
        }
    }

    @Override
    protected Integer confirming(ExtendedDataInputStream in) throws Exception {
        boolean providerExists = in.readBoolean();
        if (!providerExists) {
            return -1;
        }
        switch (this.opcode) {
            case 1: {
                StringCompressor compressor = this.getStringCompressor();
                int i = 0;
                int size = this.names.length;
                while (i < size) {
                    Entity entity = in.readBoolean() ? Entity.read((ExtendedDataInput)in, (StringCompressor)compressor) : null;
                    this.entityHandler.accept(this.names[i], entity);
                    ++i;
                }
                return in.readVarInt();
            }
        }
        return -2;
    }

    protected StringCompressor getStringCompressor() {
        return this.getProtocol().getStringCompressor();
    }

    private void writeCompressedString(ExtendedDataOutputStream out, String string) throws IOException {
        StringCompressor compressor = this.getStringCompressor();
        if (compressor != null) {
            compressor.write((ExtendedDataOutput)out, string);
        } else {
            out.writeString(string);
        }
    }

    @Override
    protected String getAdditionalInfo() {
        return MessageFormat.format("opcode={0}, namespace={1}, names={2}", this.opcode, this.namespace, Arrays.asList(this.names));
    }

    private static void writeStrings(ExtendedDataOutputStream out, String ... strings) throws IOException {
        out.writeVarInt(strings.length);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            out.writeString(string);
            ++n2;
        }
    }
}

