/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.server.IUnit;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalUnitManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.options.IOptionsContainer;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public class View
extends Lifecycle
implements InternalView,
CDOCommonView.Options {
    private InternalSession session;
    private final int viewID;
    private final int sessionID;
    private CDOBranchPoint branchPoint;
    private CDOBranchPoint normalizedBranchPoint;
    private String durableLockingID;
    private CDOLockOwner lockOwner;
    private final InternalRepository repository;
    private final Set<CDOID> changeSubscriptionIDs = new HashSet<CDOID>();
    private final Set<CDOID> openUnitRoots = new HashSet<CDOID>();
    private boolean lockNotificationsEnabled;
    private boolean inverseClosing;
    private boolean closed;
    private final IRegistry<String, Object> properties = new HashMapRegistry.AutoCommit();

    public View(InternalSession session, int viewID, CDOBranchPoint branchPoint) {
        this(session, viewID, branchPoint, null);
    }

    public View(InternalSession session, int viewID, CDOBranchPoint branchPoint, String durableLockingID) {
        this.session = session;
        this.viewID = viewID;
        this.durableLockingID = durableLockingID;
        this.sessionID = session.getSessionID();
        this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
        this.repository = session.getRepository();
        this.setBranchPoint(branchPoint);
    }

    public ExecutorService getExecutorService() {
        return this.session.getExecutorService();
    }

    @Override
    public InternalSession getSession() {
        return this.session;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public int getViewID() {
        return this.viewID;
    }

    public CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    public long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isHistorical() {
        return this.branchPoint.getTimeStamp() != 0L;
    }

    public boolean isDurableView() {
        return this.durableLockingID != null;
    }

    public String getDurableLockingID() {
        return this.durableLockingID;
    }

    @Override
    public void setDurableLockingID(String durableLockingID) {
        this.durableLockingID = durableLockingID;
        this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
    }

    public CDOLockOwner getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    public void loadLob(CDOLobInfo info, Object outputStreamOrWriter) throws IOException {
        this.getSession().loadLob(info, outputStreamOrWriter);
    }

    public InternalCDORevision getRevision(CDOID id) {
        InternalCDORevisionManager revisionManager = this.repository.getRevisionManager();
        return (InternalCDORevision)revisionManager.getRevision(id, this.normalizedBranchPoint, -1, 0, true);
    }

    private List<CDORevision> getRevisions(List<CDOID> ids) {
        InternalCDORevisionManager revisionManager = this.repository.getRevisionManager();
        return revisionManager.getRevisions(ids, this.normalizedBranchPoint, -1, 0, true);
    }

    @Override
    public void changeTarget(CDOBranchPoint branchPoint, List<CDOID> invalidObjects, List<CDORevisionDelta> allChangedObjects, List<CDOID> allDetachedObjects) {
        List<CDORevision> oldRevisions = this.getRevisions(invalidObjects);
        this.setBranchPoint(branchPoint);
        List<CDORevision> newRevisions = this.getRevisions(invalidObjects);
        Iterator<CDORevision> it = newRevisions.iterator();
        for (CDORevision oldRevision : oldRevisions) {
            CDORevision newRevision = it.next();
            if (newRevision == null) {
                allDetachedObjects.add(oldRevision.getID());
                continue;
            }
            if (newRevision == oldRevision) continue;
            this.repository.ensureChunks((InternalCDORevision)newRevision, -1);
            this.repository.ensureChunks((InternalCDORevision)oldRevision, -1);
            CDORevisionDelta delta = newRevision.compare(oldRevision);
            allChangedObjects.add(delta);
        }
    }

    @Override
    public void setBranchPoint(CDOBranchPoint branchPoint) {
        this.checkOpen();
        this.validateTimeStamp(branchPoint.getTimeStamp());
        InternalCDOBranchManager branchManager = this.getSession().getRepository().getBranchManager();
        this.branchPoint = CDOBranchUtil.adjustBranchPoint((CDOBranchPoint)branchPoint, (CDOBranchManager)branchManager);
        this.normalizedBranchPoint = CDOBranchUtil.normalizeBranchPoint((CDOBranchPoint)this.branchPoint);
    }

    protected void validateTimeStamp(long timeStamp) throws IllegalArgumentException {
        if (timeStamp != 0L) {
            this.repository.validateTimeStamp(timeStamp);
        }
    }

    @Override
    public boolean openUnit(CDOID rootID, CDOProtocolConstants.UnitOpcode opcode, CDORevisionHandler revisionHandler, OMMonitor monitor) {
        InternalUnitManager unitManager = this.repository.getUnitManager();
        IUnit unit = unitManager.getUnit(rootID);
        switch (opcode) {
            case CREATE: 
            case CREATE_AND_OPEN: {
                if (unit != null) {
                    return false;
                }
                unit = unitManager.createUnit(rootID, this, revisionHandler, monitor);
                break;
            }
            case OPEN: 
            case OPEN_DEMAND_CREATE: {
                if (unit == null) {
                    if (opcode.isCreate()) {
                        unit = unitManager.createUnit(rootID, this, revisionHandler, monitor);
                        break;
                    }
                    return false;
                }
                unit.open(this, revisionHandler, monitor);
            }
        }
        if (opcode.isOpen()) {
            this.openUnitRoots.add(rootID);
        }
        return true;
    }

    @Override
    public void closeUnit(CDOID rootID) {
        this.openUnitRoots.remove(rootID);
    }

    @Override
    public boolean isInOpenUnit(CDOID id) {
        if (this.openUnitRoots.isEmpty()) {
            return false;
        }
        if (this.openUnitRoots.contains(id)) {
            return true;
        }
        InternalCDORevision revision = this.getRevision(id);
        if (revision != null) {
            CDOID parentID = revision.getResourceID();
            if (parentID == id) {
                return false;
            }
            if (CDOIDUtil.isNull((CDOID)parentID)) {
                parentID = (CDOID)revision.getContainerID();
            }
            return this.isInOpenUnit(parentID);
        }
        return false;
    }

    @Override
    public synchronized void subscribe(CDOID id) {
        this.checkOpen();
        this.changeSubscriptionIDs.add(id);
    }

    @Override
    public synchronized void unsubscribe(CDOID id) {
        this.checkOpen();
        this.changeSubscriptionIDs.remove(id);
    }

    @Override
    public synchronized boolean hasSubscription(CDOID id) {
        if (this.isClosed()) {
            return false;
        }
        return this.changeSubscriptionIDs.contains(id);
    }

    @Override
    public synchronized void clearChangeSubscription() {
        this.checkOpen();
        this.changeSubscriptionIDs.clear();
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public int hashCode() {
        return ObjectUtil.hashCode((int[])new int[]{this.sessionID, this.viewID});
    }

    public String toString() {
        int sessionID = this.session == null ? 0 : this.session.getSessionID();
        return MessageFormat.format("{0}[{1}:{2}]", this.getClassName(), sessionID, this.viewID);
    }

    protected String getClassName() {
        return "View";
    }

    public void close() {
        this.deactivate();
    }

    protected void doDeactivate() throws Exception {
        if (!this.isClosed()) {
            this.session.viewClosed(this, this.inverseClosing);
        }
        super.doDeactivate();
    }

    @Override
    public void doClose() {
        this.clearChangeSubscription();
        this.openUnitRoots.clear();
        this.closed = true;
    }

    @Override
    public void inverseClose() {
        this.inverseClosing = true;
        try {
            this.close();
        }
        finally {
            this.inverseClosing = false;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void checkOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("View closed");
        }
    }

    public IOptionsContainer getContainer() {
        return this;
    }

    public CDOCommonView.Options options() {
        return this;
    }

    public final IRegistry<String, Object> properties() {
        return this.properties;
    }

    public boolean isLockNotificationEnabled() {
        return this.lockNotificationsEnabled;
    }

    public void setLockNotificationEnabled(boolean enable) {
        this.lockNotificationsEnabled = enable;
    }
}

