/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class HashBag<T>
implements Set<T> {
    private Map<T, Counter> map;

    public HashBag() {
        this.map = new HashMap<T, Counter>();
    }

    public HashBag(int initialCapacity, float loadFactor) {
        this.map = new HashMap<T, Counter>(initialCapacity, loadFactor);
    }

    public HashBag(int initialCapacity) {
        this.map = new HashMap<T, Counter>(initialCapacity);
    }

    public HashBag(Map<? extends T, ? extends Counter> m) {
        this.map = new HashMap<T, Counter>(m);
    }

    public HashBag(HashBag<? extends T> hb) {
        this(hb.map);
    }

    public int getCounterFor(T o) {
        Counter counter = this.map.get(o);
        if (counter == null) {
            return 0;
        }
        return counter.getValue();
    }

    public int removeCounterFor(T o) {
        Counter counter = this.map.remove(o);
        if (counter == null) {
            return 0;
        }
        return counter.getValue();
    }

    @Override
    public boolean add(T o) {
        return this.add(o, 1);
    }

    public boolean add(T o, int count) {
        Counter counter = this.map.get(o);
        if (counter == null) {
            counter = new Counter(count);
            this.map.put(o, counter);
            return true;
        }
        counter.incValue(count);
        return false;
    }

    public int addAndGet(T o, int count) {
        Counter counter = this.map.get(o);
        if (counter == null) {
            counter = new Counter(count);
            this.map.put(o, counter);
            return count;
        }
        return counter.incValue(count);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(o, 1);
    }

    public boolean remove(Object o, int count) {
        Counter counter = this.map.get(o);
        if (counter == null) {
            return false;
        }
        if (counter.decValue(count) <= 0) {
            this.map.remove(o);
        }
        return true;
    }

    public int removeAndGet(Object o, int count) {
        Counter counter = this.map.get(o);
        if (counter == null) {
            return 0;
        }
        int newValue = counter.decValue(count);
        if (newValue <= 0) {
            this.map.remove(o);
            return 0;
        }
        return newValue;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    public String toString() {
        return this.map.toString();
    }

    private static final class Counter {
        private int value;

        public Counter(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public int incValue(int count) {
            return this.value += count;
        }

        public int decValue(int count) {
            return this.value -= count;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

