/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.util.Arrays;
import java.util.function.BiConsumer;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.EntityRequest;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.data.TinyData;
import org.eclipse.net4j.tests.signal.ArrayRequest;
import org.eclipse.net4j.tests.signal.AsyncRequest;
import org.eclipse.net4j.tests.signal.IntRequest;
import org.eclipse.net4j.tests.signal.StringRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.om.OMPlatform;

public class SignalTest
extends AbstractConfigTest {
    public void testInteger() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            protocol = new TestSignalProtocol(this.getConnector());
            int data = 10;
            int result = (Integer)new IntRequest(protocol, data).send();
            SignalTest.assertEquals((int)data, (int)result);
        }
    }

    public void testArray() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            protocol = new TestSignalProtocol(this.getConnector());
            byte[] data = TinyData.getBytes();
            byte[] result = (byte[])new ArrayRequest(protocol, data).send();
            SignalTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
        }
    }

    public void testAsync() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            OMPlatform.INSTANCE.setDebugging(false);
            protocol = new TestSignalProtocol(this.getConnector());
            String data = TinyData.getText();
            int i = 0;
            while (i < 1000) {
                SignalTest.msg("Loop " + i);
                new AsyncRequest(protocol, data).sendAsync();
                String result = (String)new StringRequest(protocol, data).send();
                SignalTest.assertEquals((String)data, (String)result);
                ++i;
            }
        }
    }

    public void testCloseUnderlyingConnection() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            TestSignalProtocol lifecycle = protocol = new TestSignalProtocol(this.getConnector());
            this.config.closeUnderlyingConnection((IConnector)this.getServerConnector());
            SignalTest.assertNoTimeout(() -> SignalTest.lambda$0((ILifecycle)lifecycle));
        }
    }

    public void testEntities() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            protocol = new TestSignalProtocol(this.getConnector());
            BiConsumer<String, Entity> entityHandler = (name, entity) -> System.out.println(name + " --> " + String.valueOf(entity));
            int result = (Integer)new EntityRequest((SignalProtocol)protocol, entityHandler, "users", new String[]{"eike", "rene", "ed"}).send();
            SignalTest.assertEquals((int)2, (int)result);
        }
    }

    private static /* synthetic */ boolean lambda$0(ILifecycle iLifecycle) {
        return !iLifecycle.isActive();
    }
}

