/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms.protocol;

import java.util.List;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.protocol.JMSClientProtocol;
import org.eclipse.net4j.internal.jms.util.MessageUtil;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class JMSCommitRequest
extends RequestWithConfirmation<String[]> {
    private int sessionID;
    private List<MessageImpl> messages;

    public JMSCommitRequest(JMSClientProtocol protocol, int sessionID, List<MessageImpl> messages) {
        super((SignalProtocol)protocol, (short)12);
        this.sessionID = sessionID;
        this.messages = messages;
    }

    protected void requesting(ExtendedDataOutputStream out) throws Exception {
        out.writeInt(this.sessionID);
        out.writeInt(this.messages.size());
        for (MessageImpl message : this.messages) {
            MessageUtil.write(out, message);
        }
    }

    protected String[] confirming(ExtendedDataInputStream in) throws Exception {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        String[] messageIDs = new String[size];
        int i = 0;
        while (i < size) {
            messageIDs[i] = in.readString();
            ++i;
        }
        return messageIDs;
    }
}

