/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.lpg.AbstractFormattingHelper;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingHelperImpl
extends AbstractFormattingHelper {
    public static final FormattingHelperImpl INSTANCE = new FormattingHelperImpl();
    private boolean fIncludeParameterName;

    public String formatOperationSignature(EOperation operation, UMLReflection<?, EClassifier, EOperation, ?, ?, EParameter, ?, ?, ?, ?> uml) {
        StringBuilder result = new StringBuilder();
        EClassifier owner = (EClassifier)uml.getOwningClassifier((Object)operation);
        if (owner != null && !(owner instanceof Module)) {
            result.append(this.formatQualifiedName(owner));
            result.append(this.getSeparator());
        }
        result.append(this.formatName(operation));
        result.append('(');
        Iterator iter = uml.getParameters((Object)operation).iterator();
        while (iter.hasNext()) {
            EParameter next = (EParameter)iter.next();
            if (uml.getOCLType((Object)next) != null) {
                result.append(this.getTypedElementSignature((ETypedElement)next, uml));
            }
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        EClassifier returnType = (EClassifier)uml.getOCLType((Object)operation);
        if (returnType == null) {
            result.append(')');
        } else {
            result.append(") : ");
            if (FormattingHelperImpl.isStdLibType(returnType)) {
                result.append(uml.getName((Object)returnType));
            } else {
                result.append(uml.getQualifiedName((Object)returnType));
            }
        }
        Module moduleOwner = QvtOperationalParserUtil.getOwningModule(operation);
        if (moduleOwner != null) {
            result.append(" - ");
            result.append(uml.getQualifiedName((Object)moduleOwner));
        }
        return result.toString();
    }

    String getTypedElementSignature(ETypedElement typedElement, UMLReflection<?, EClassifier, EOperation, ?, ?, EParameter, ?, ?, ?, ?> uml) {
        EClassifier eType;
        StringBuilder result = new StringBuilder();
        if (this.fIncludeParameterName) {
            result.append(uml.getName((Object)typedElement));
            result.append(" : ");
        }
        if ((eType = (EClassifier)uml.getOCLType((Object)typedElement)) != null) {
            if (FormattingHelperImpl.isStdLibType(eType)) {
                result.append(uml.getName((Object)eType));
            } else {
                result.append(uml.getQualifiedName((Object)eType));
            }
        }
        return result.toString();
    }

    static boolean isStdLibType(EClassifier type) {
        return type instanceof PredefinedType;
    }
}

