/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.StandaloneModuleHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneBlackboxProvider
extends JavaBlackboxProvider {
    private Map<String, JavaBlackboxProvider.JavaUnitDescriptor> fDescriptorMap = new LinkedHashMap<String, JavaBlackboxProvider.JavaUnitDescriptor>();

    @Override
    public BlackboxUnitDescriptor getUnitDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        try {
            JavaBlackboxProvider.JavaUnitDescriptor d = this.fDescriptorMap.get(qualifiedName);
            if (d == null) {
                d = new StandaloneDescriptor(qualifiedName);
                this.fDescriptorMap.put(qualifiedName, d);
            }
            return d;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public void registerDescriptor(final Class<?> cls, String unitQualifiedName, String moduleName, final String[] packageURIs) {
        JavaBlackboxProvider.JavaUnitDescriptor d = this.fDescriptorMap.get(unitQualifiedName);
        if (d == null) {
            d = new JavaBlackboxProvider.JavaUnitDescriptor(this, unitQualifiedName){};
            this.fDescriptorMap.put(unitQualifiedName, d);
        }
        try {
            d.addModuleHandle(new StandaloneModuleHandle(cls.getName(), moduleName){

                @Override
                public Class<?> getModuleJavaClass() {
                    return cls;
                }

                @Override
                public List<String> getUsedPackages() {
                    return Arrays.asList(packageURIs);
                }
            });
        }
        catch (ClassNotFoundException e) {
            QvtPlugin.error(e);
        }
    }

    public Collection<JavaBlackboxProvider.JavaUnitDescriptor> getUnitDescriptors(ResolutionContext resolutionContext) {
        return this.fDescriptorMap.values();
    }

    @Override
    public void cleanup() {
        this.fDescriptorMap = new LinkedHashMap<String, JavaBlackboxProvider.JavaUnitDescriptor>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StandaloneDescriptor
    extends JavaBlackboxProvider.JavaUnitDescriptor {
        StandaloneDescriptor(String unitQualifiedName) throws ClassNotFoundException {
            this(unitQualifiedName, Collections.singletonList(StandaloneBlackboxProvider.getSimpleNameFromJavaClass(unitQualifiedName)));
        }

        StandaloneDescriptor(String unitQualifiedName, List<String> moduleNames) throws ClassNotFoundException {
            super(StandaloneBlackboxProvider.this, unitQualifiedName);
            for (String moduleName : moduleNames) {
                this.addModuleHandle(new StandaloneModuleHandle(unitQualifiedName, moduleName));
            }
        }
    }
}

