/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.ChooserNode;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.EPackageNode;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPackageNodeUtil {
    private EPackageNodeUtil() {
    }

    public static ChooserNode[] collectEqualNodes(ChooserNode[] roots, final String packUri) {
        final ArrayList nodes = new ArrayList();
        IProcessor processor = new IProcessor(){

            public boolean process(ChooserNode node) {
                if (!(node instanceof EPackageNode)) {
                    return false;
                }
                EPackageNode packNode = (EPackageNode)node;
                if (packNode.getEPackage().getNsURI().equals(packUri)) {
                    nodes.add(packNode);
                }
                return false;
            }
        };
        EPackageNodeUtil.walkNodes(roots, processor);
        return nodes.toArray(new ChooserNode[nodes.size()]);
    }

    public static boolean walkNodes(ChooserNode[] roots, IProcessor processor) {
        ChooserNode[] chooserNodeArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            ChooserNode root = chooserNodeArray[n2];
            boolean shouldStop = processor.process(root);
            if (shouldStop) {
                return true;
            }
            ChooserNode[] children = root.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    boolean shouldStop2 = EPackageNodeUtil.walkNodes(new ChooserNode[]{children[i]}, processor);
                    if (shouldStop2) {
                        return true;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return false;
    }

    public static void checkOrUncheckEqualNodes(ContainerCheckedTreeViewer viewer, ChooserNode[] roots, ChooserNode element, boolean checked) {
        ChooserNode[] children;
        if (element instanceof EPackageNode) {
            EPackageNode packNode = (EPackageNode)element;
            ChooserNode[] nodes = EPackageNodeUtil.collectEqualNodes(roots, packNode.getEPackage().getNsURI());
            int i = 0;
            while (i < nodes.length) {
                ChooserNode equal = nodes[i];
                if (viewer.getChecked((Object)equal) != checked) {
                    viewer.setChecked((Object)equal, checked);
                }
                ++i;
            }
        }
        if ((children = element.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                EPackageNodeUtil.checkOrUncheckEqualNodes(viewer, roots, children[i], checked);
                ++i;
            }
        }
    }

    public static Set<String> getMetamodelIds(Object[] checked) {
        LinkedHashSet<String> metamodelIds = new LinkedHashSet<String>();
        int i = 0;
        while (i < checked.length) {
            EPackage ePackage = null;
            if (!(checked[i] instanceof EPackage) && checked[i] instanceof EPackageNode) {
                EPackageNode node = (EPackageNode)checked[i];
                ePackage = node.getEPackage();
            }
            if (ePackage != null && ePackage.getNsURI() != null) {
                metamodelIds.add(ePackage.getNsURI().toString());
            }
            ++i;
        }
        return metamodelIds;
    }

    public static interface IProcessor {
        public boolean process(ChooserNode var1);
    }
}

