/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.GenModelGenerateCompilerStep;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfigurations;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractQVTb2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTr2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationDirectedScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationMultipleScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.QVTs2QVTs;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class QVTrCompilerChain
extends AbstractCompilerChain {
    protected final @NonNull Xtext2QVTrCompilerStep xtext2qvtrCompilerStep = this.createXtext2QVTrCompilerStep();
    protected final @NonNull QVTr2QVTsCompilerStep qvtr2qvtsCompilerStep = this.createQVTr2QVTsCompilerStep();
    protected final @NonNull CreateGenModelCompilerStep createGenModelCompilerStep = this.createCreateGenModelCompilerStepStep();
    protected final @NonNull GenModelGenerateCompilerStep genmodelGenerateCompilerStep = this.createGenModelGenerateCompilerStep();

    public QVTrCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
        super(environmentFactory, txURI, intermediateFileNamePrefixURI, options);
    }

    @Override
    public @NonNull ImperativeTransformation compile(@NonNull TypedModelsConfigurations typedModelsConfigurations) throws IOException {
        Resource qvtrResource = this.xtext2qvtrCompilerStep.execute(this.txURI);
        return this.qvtr2qvti(qvtrResource, typedModelsConfigurations);
    }

    public @NonNull ImperativeTransformation qvtr2qvti(@NonNull Resource qvtrResource, @NonNull TypedModelsConfigurations typedModelsConfigurations) throws IOException {
        URI ecoreTraceURI = this.getURI("Trace", URI_KEY);
        URI traceURI = PivotUtilInternal.getASURI((URI)ecoreTraceURI);
        Resource traceResource = this.createResource(traceURI, "org.eclipse.ocl.oclas");
        ScheduleManager scheduleManager = this.qvtr2qvtsCompilerStep.execute(qvtrResource, traceResource, typedModelsConfigurations);
        this.createGenModelCompilerStep.execute(traceResource);
        return this.qvts2qvtiCompilerStep.execute(scheduleManager);
    }

    protected @NonNull CreateGenModelCompilerStep createCreateGenModelCompilerStepStep() {
        return new CreateGenModelCompilerStep(this);
    }

    protected @NonNull GenModelGenerateCompilerStep createGenModelGenerateCompilerStep() {
        return new GenModelGenerateCompilerStep(this);
    }

    protected @NonNull QVTr2QVTsCompilerStep createQVTr2QVTsCompilerStep() {
        return new QVTr2QVTsCompilerStep(this);
    }

    protected @NonNull Xtext2QVTrCompilerStep createXtext2QVTrCompilerStep() {
        return new Xtext2QVTrCompilerStep(this);
    }

    @Override
    public @NonNull java.lang.Class<? extends Transformer> generate(@NonNull ImperativeTransformation asTransformation, String ... genModelFiles) throws Exception {
        this.genmodelGenerateCompilerStep.execute();
        return super.generate(asTransformation, genModelFiles);
    }

    protected static class CreateGenModelCompilerStep
    extends AbstractCompilerStep {
        public CreateGenModelCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "Trace");
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void execute(@NonNull Resource traceResource) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTrEnvironmentFactory.CREATE_STRATEGY);
            try {
                URI ecoreURI = this.compilerChain.getURI("Trace", URI_KEY);
                AS2Ecore as2ecore = new AS2Ecore((EnvironmentFactoryInternal)this.environmentFactory, ecoreURI, null);
                XMLResource ecoreResource = as2ecore.convertResource(traceResource, ecoreURI);
                Map saveOptions = (Map)this.compilerChain.basicGetOption("Trace", SAVE_OPTIONS_KEY);
                if (saveOptions == null) {
                    saveOptions = XMIUtil.createSaveOptions();
                }
                ecoreResource.save(saveOptions);
                this.throwCompilerChainExceptionForErrors();
                QVTrCompilerChain.assertNoResourceSetErrors("Trace save", traceResource);
                this.compiled(traceResource);
                String genModelDirectory = (String)this.compilerChain.basicGetOption("GenModel", GENMODEL_MODEL_DIRECTORY_KEY);
                URI genModelURI = this.compilerChain.getURI("GenModel", URI_KEY);
                saveOptions = (Map)this.compilerChain.basicGetOption("GenModel", SAVE_OPTIONS_KEY);
                if (saveOptions == null) {
                    saveOptions = XMIUtil.createSaveOptions();
                }
                saveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                ResourceSet resourceSet = this.environmentFactory.getResourceSet();
                this.environmentFactory.getProjectManager().configureLoadFirst(resourceSet, "http://www.eclipse.org/ocl/2015/Library");
                this.environmentFactory.getProjectManager().configureLoadFirst(resourceSet, "http://www.eclipse.org/qvt/2019/QVTruntimeLibrary");
                HashSet<@NonNull GenPackage> usedGenPackages = new HashSet<GenPackage>();
                usedGenPackages.add(CompilerUtil.getGenPackage(resourceSet, "org.eclipse.qvtd.runtime/model/QVTtrace.genmodel", "//qvttrace"));
                usedGenPackages.add(CompilerUtil.getGenPackage(resourceSet, "org.eclipse.qvtd.runtime/model/QVTruntimeLibrary.genmodel", "//qvtruntimelibrary"));
                usedGenPackages.add(CompilerUtil.getGenPackage(resourceSet, "org.eclipse.ocl.pivot/model/oclstdlib.genmodel", "//oclstdlib"));
                @NonNull Collection moreUsedGenPackages = (Collection)this.compilerChain.basicGetOption("GenModel", GENMODEL_USED_GENPACKAGES_KEY);
                if (moreUsedGenPackages != null) {
                    usedGenPackages.addAll(moreUsedGenPackages);
                }
                this.saveGenModel(this, traceResource, genModelURI, (Map)this.compilerChain.basicGetOption("GenModel", GENMODEL_OPTIONS_KEY), genModelDirectory, saveOptions, usedGenPackages);
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }

        private void getUsedGenPackageClosure(@NonNull ProblemHandler problemHandler, @NonNull Map<@NonNull String, @NonNull GenPackage> uri2genPackage, @NonNull Iterable<@NonNull ? extends GenPackage> genPackages) {
            for (GenPackage genPackage : genPackages) {
                String nsURI = genPackage.getNSURI();
                if (nsURI == null) {
                    problemHandler.addProblem(new CompilerChainException("Null nsURI for " + genPackage, genPackage));
                    continue;
                }
                GenPackage oldGenPackage = uri2genPackage.put(nsURI, genPackage);
                if (oldGenPackage == genPackage) continue;
                if (oldGenPackage != null) {
                    problemHandler.addProblem(new CompilerChainException("Conflicting " + oldGenPackage + " ignored", oldGenPackage));
                    continue;
                }
                GenModel newGenModel = genPackage.getGenModel();
                EList newUsedGenPackages = newGenModel.getUsedGenPackages();
                assert (newUsedGenPackages != null);
                this.getUsedGenPackageClosure(problemHandler, uri2genPackage, (Iterable<? extends GenPackage>)newUsedGenPackages);
            }
        }

        public static @NonNull String getProjectName(@NonNull URI traceURI) {
            URI trimFileExtension = traceURI.trimFileExtension();
            if (trimFileExtension.isPlatform()) {
                return trimFileExtension.segment(1);
            }
            return trimFileExtension.segment(0);
        }

        public @NonNull GenModel saveGenModel(@NonNull ProblemHandler problemHandler, @NonNull Resource asResource, @NonNull URI genModelURI, @Nullable Map<@NonNull String, @Nullable String> genModelOptions, @Nullable String genModelDirectory, @NonNull Map<Object, Object> saveOptions2, @Nullable Collection<@NonNull ? extends GenPackage> usedGenPackages) throws IOException {
            String copyrightText;
            URI traceURI = asResource.getURI();
            assert (traceURI != null);
            @NonNull URI ecoreURI = PivotUtilInternal.getNonASURI((URI)traceURI);
            URI trimFileExtension = traceURI.trimFileExtension();
            String projectName = CreateGenModelCompilerStep.getProjectName(traceURI);
            Resource genmodelResource = this.environmentFactory.getResourceSet().createResource(genModelURI);
            @NonNull GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
            genModel.getForeignModel().add((Object)ecoreURI.lastSegment());
            String string = copyrightText = genModelOptions != null ? genModelOptions.get("genModelCopyrightText") : null;
            if (copyrightText != null) {
                genModel.setCopyrightText(copyrightText);
            }
            HashMap<@NonNull String, @NonNull GenPackage> uri2genPackage = new HashMap<String, GenPackage>();
            ArrayList<@NonNull V> allUsedGenPackages = new ArrayList();
            if (usedGenPackages != null) {
                ProjectManager projectManager = this.environmentFactory.getProjectManager();
                for (GenPackage genPackage : usedGenPackages) {
                    EPackage ePackage = genPackage.getEcorePackage();
                    String nsURI = ePackage.getNsURI();
                    projectManager.configureLoadFirst(this.environmentFactory.getResourceSet(), nsURI);
                    projectManager.configureLoadFirst(this.environmentFactory.getMetamodelManager().getASResourceSet(), nsURI);
                }
                this.getUsedGenPackageClosure(problemHandler, uri2genPackage, usedGenPackages);
                allUsedGenPackages.addAll(uri2genPackage.values());
                Collections.sort(allUsedGenPackages, QVTr2QVTc.GenPackageComparator.INSTANCE);
                genModel.getUsedGenPackages().addAll(allUsedGenPackages);
            }
            if (genModelDirectory != null) {
                genModel.setModelDirectory(genModelDirectory);
            } else {
                genModel.setModelDirectory("/" + projectName + "/" + "test-src");
            }
            genModel.setModelPluginID(projectName);
            genModel.setModelName(trimFileExtension.lastSegment());
            genModel.setBundleManifest(false);
            genModel.setUpdateClasspath(false);
            genModel.setImporterID(new EcoreImporter().getID());
            genModel.setComplianceLevel(GenJDKLevel.JDK80_LITERAL);
            genModel.setCopyrightFields(false);
            genModel.setOperationReflection(true);
            genModel.setImportOrganizing(true);
            genModel.setRootExtendsClass(MinimalEObjectImpl.Container.class.getName());
            genModel.setPluginKey("");
            genModel.setTemplateDirectory("/org.eclipse.ocl.examples.codegen/templates");
            genmodelResource.getContents().add((Object)genModel);
            String basePrefix = genModelOptions != null ? genModelOptions.get("genModelBasePrefix") : null;
            EList eList = genModel.getGenPackages();
            for (EObject eObject : asResource.getContents()) {
                if (!(eObject instanceof Model)) continue;
                Model asModel = (Model)eObject;
                for (Package asPackage : QVTrelationUtil.getOwnedPackages((Model)asModel)) {
                    GenPackage genPackage = genModel.createGenPackage();
                    EPackage ePackage = (EPackage)asPackage.getESObject();
                    genPackage.setEcorePackage(ePackage);
                    genPackage.setPrefix(ePackage.getName());
                    if (basePrefix != null) {
                        genPackage.setBasePackage(basePrefix);
                    }
                    eList.add(genPackage);
                }
                HashSet<@NonNull Package> asPackages = new HashSet<Package>();
                for (EObject element : new TreeIterable((EObject)asModel, false)) {
                    Package asPackage;
                    if (!(element instanceof Property)) continue;
                    Property property = (Property)element;
                    Type type = property.getType();
                    while (type instanceof CollectionType) {
                        type = ((CollectionType)type).getElementType();
                    }
                    if (!(type instanceof Class) || (asPackage = ((Class)type).getOwningPackage()) == null) continue;
                    asPackages.add(asPackage);
                }
                for (Import asImport : QVTrelationUtil.getOwnedImports((Model)asModel)) {
                    Namespace asNamespace = asImport.getImportedNamespace();
                    if (!(asNamespace instanceof Package)) continue;
                    @NonNull Package asPackage = (Package)asNamespace;
                    asPackages.add(asPackage);
                }
                ArrayList<@NonNull E> asPackageList = new ArrayList(asPackages);
                Collections.sort(asPackageList, NameUtil.NAMEABLE_COMPARATOR);
                for (Package asPackage : asPackageList) {
                    EPackage ePackage = (EPackage)asPackage.getESObject();
                    if (ePackage == null) continue;
                    GenPackage genPackage = null;
                    if (allUsedGenPackages != null) {
                        for (GenPackage usedGenPackage : allUsedGenPackages) {
                            EPackage ecorePackage = usedGenPackage.getEcorePackage();
                            if (ecorePackage == null || !ClassUtil.safeEquals((Object)ecorePackage.getNsURI(), (Object)ePackage.getNsURI())) continue;
                            genPackage = usedGenPackage;
                            break;
                        }
                    }
                    if (genPackage != null) continue;
                    for (GenPackage aGenPackage : eList) {
                        if (aGenPackage.getEcorePackage() != ePackage) continue;
                        genPackage = aGenPackage;
                        break;
                    }
                    if (genPackage != null) continue;
                    genPackage = genModel.createGenPackage();
                    genPackage.setEcorePackage(ePackage);
                    genPackage.setPrefix(ePackage.getName());
                    if (basePrefix != null) {
                        genPackage.setBasePackage(basePrefix);
                    }
                    eList.add(genPackage);
                }
            }
            genModel.reconcile();
            HashMap<Object, Object> saveOptions = new HashMap<Object, Object>(saveOptions2);
            saveOptions.put("ENCODING", "UTF-8");
            saveOptions.put("LINE_DELIMITER", "\n");
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            saveOptions.put("LINE_DELIMITER", "");
            genmodelResource.save(saveOptions);
            return genModel;
        }
    }

    protected static class QVTr2QVTsCompilerStep
    extends AbstractCompilerStep {
        public QVTr2QVTsCompilerStep(@NonNull QVTrCompilerChain compilerChain) {
            super(compilerChain, "QVTs");
            AbstractQVTb2QVTs.DEBUG_GRAPHS.setState(this.basicGetOption(CompilerChain.DEBUG_KEY) == Boolean.TRUE);
        }

        public @NonNull ScheduleManager execute(@NonNull Resource qvtrResource, @NonNull Resource traceResource, @NonNull TypedModelsConfigurations typedModelsConfigurations) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTrEnvironmentFactory.CREATE_STRATEGY);
            RelationalTransformation asTransformation = (RelationalTransformation)QVTbaseUtil.getTransformation((Resource)qvtrResource);
            String s = typedModelsConfigurations.reconcile((Transformation)asTransformation);
            if (s != null) {
                CompilerUtil.addTransformationError(this, (Transformation)asTransformation, "Inconsistent configuration\n" + s, new Object[0]);
            }
            if (Iterables.isEmpty((Iterable)typedModelsConfigurations)) {
                CompilerUtil.addTransformationError(this, (Transformation)asTransformation, "No TypedModels configurations", new Object[0]);
            }
            this.throwCompilerChainExceptionForErrors();
            Resource qvtsResource = this.createResource("org.eclipse.qvtd.qvtschedule");
            ScheduleModel scheduleModel = QVTscheduleFactory.eINSTANCE.createScheduleModel();
            qvtsResource.getContents().add((Object)scheduleModel);
            CompilerOptions.StepOptions schedulerOptions = this.compilerChain.basicGetOptions("QVTs");
            QVTrelationMultipleScheduleManager multipleScheduleManager = new QVTrelationMultipleScheduleManager((EnvironmentFactory)this.environmentFactory, (Transformation)asTransformation, this, scheduleModel, schedulerOptions);
            try {
                multipleScheduleManager.getDomainUsageAnalysis().analyzeTransformation();
                this.throwCompilerChainExceptionForErrors();
                try {
                    Map traceOptions;
                    boolean missingTraceArtefacts;
                    List missingOperationCallSources = QVTbaseUtil.rewriteMissingOperationCallSources((EnvironmentFactory)this.environmentFactory, (Resource)qvtsResource);
                    if (missingOperationCallSources != null) {
                        QVTruntimeUtil.errPrintln((String)("Missing OperationCallExp sources were fixed up for '" + qvtsResource.getURI() + "'"));
                    }
                    if (missingTraceArtefacts = QVTrelationUtil.rewriteMissingTraceArtefacts((EnvironmentFactory)this.environmentFactory, (Resource)qvtrResource)) {
                        QVTruntimeUtil.errPrintln((String)("Missing trace TypedModel.Class artefacts were fixed up for '" + qvtsResource.getURI() + "'"));
                    }
                    String traceNsURI = (traceOptions = (Map)this.compilerChain.basicGetOption("Trace", TRACE_OPTIONS_KEY)) != null ? (String)traceOptions.get("traceNsURI") : null;
                    for (TypedModelsConfiguration typedModelsConfiguration : typedModelsConfigurations) {
                        QVTrelationDirectedScheduleManager directedScheduleManager = multipleScheduleManager.createDirectedScheduleManager(typedModelsConfiguration);
                        QVTr2QVTs qvtr2qvts = new QVTr2QVTs(directedScheduleManager, (ProblemHandler)this);
                        Iterable<@NonNull RuleRegion> activeRegions = qvtr2qvts.transform(qvtrResource, qvtsResource, traceNsURI, traceResource);
                        String directedName = directedScheduleManager.getDirectedName((Transformation)asTransformation);
                        QVTs2QVTs qvts2qvts = new QVTs2QVTs(this, directedScheduleManager, directedName);
                        qvts2qvts.transform(activeRegions);
                    }
                    this.throwCompilerChainExceptionForErrors();
                    this.saveResource(qvtsResource);
                }
                catch (AssertionError | CompilerChainException e) {
                    URI ecoreURI = traceResource.getURI().trimFileExtension();
                    AS2Ecore as2ecore = new AS2Ecore((EnvironmentFactoryInternal)this.environmentFactory, ecoreURI, null);
                    XMLResource ecoreResource = as2ecore.convertResource(traceResource, ecoreURI);
                    ecoreResource.save(null);
                    throw e;
                }
                QVTrelationMultipleScheduleManager qVTrelationMultipleScheduleManager = multipleScheduleManager;
                return qVTrelationMultipleScheduleManager;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }

    protected static class Xtext2QVTrCompilerStep
    extends AbstractCompilerStep {
        public Xtext2QVTrCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTr");
        }

        public @NonNull Resource execute(@NonNull URI txURI) throws IOException {
            boolean missingTraceArtefacts;
            ASResource qvtrResource = QVTrelationUtil.loadTransformations((QVTbaseEnvironmentFactory)this.environmentFactory, (URI)txURI, (boolean)false);
            qvtrResource.setURI(this.getURI());
            List missingOperationCallSources = QVTbaseUtil.rewriteMissingOperationCallSources((EnvironmentFactory)this.environmentFactory, (Resource)qvtrResource);
            if (missingOperationCallSources != null) {
                QVTruntimeUtil.errPrintln((String)("Missing OperationCallExp sources were fixed up for '" + txURI + "'"));
            }
            if (missingTraceArtefacts = QVTrelationUtil.rewriteMissingTraceArtefacts((EnvironmentFactory)this.environmentFactory, (Resource)qvtrResource)) {
                QVTruntimeUtil.errPrintln((String)("Missing trace TypedModel.Class artefacts were fixed up for '" + txURI + "'"));
            }
            QVTrCompilerChain.checkForProxyURIs((Resource)qvtrResource);
            qvtrResource.setSaveable(true);
            this.saveResource((Resource)qvtrResource);
            return qvtrResource;
        }
    }
}

