/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.launching;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.messages.VMMessages;
import org.eclipse.ocl.examples.debug.vm.utils.StreamsProxy;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConfigurationDelegate;

public abstract class QVTimperativeJob
extends WorkspaceJob
implements IProcess {
    protected final @NonNull ILaunch launch;
    protected final @NonNull StreamsProxy streamsProxy;
    protected final @NonNull QVTiLaunchConfigurationDelegate launchConfigurationDelegate;
    protected final boolean traceEvaluation;
    protected final Map<String, String> inMap;
    protected final Map<String, String> outMap;
    protected final @NonNull URI txURI;

    protected QVTimperativeJob(@NonNull String jobName, @NonNull QVTiLaunchConfigurationDelegate launchConfigurationDelegate, @NonNull ILaunch launch, @NonNull ILaunchConfiguration configuration) throws CoreException {
        super(jobName);
        this.launch = launch;
        this.streamsProxy = new StreamsProxy();
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (DebugPlugin.getDefault() != null) {
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)QVTimperativeJob.this, 8)});
                }
            }
        });
        this.launchConfigurationDelegate = launchConfigurationDelegate;
        this.traceEvaluation = configuration.getAttribute("console-trace", false);
        this.inMap = configuration.getAttribute("in", QVTiLaunchConfigurationDelegate.EMPTY_MAP);
        this.outMap = configuration.getAttribute("out", QVTiLaunchConfigurationDelegate.EMPTY_MAP);
        this.txURI = launchConfigurationDelegate.getTransformationURI(configuration);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException((IStatus)new Status(4, this.getPluginId(), 1, VMMessages.ShallowProcess_InvalidState, null));
        }
        return this.getResult().getSeverity();
    }

    public @NonNull String getLabel() {
        return "";
    }

    public @NonNull ILaunch getLaunch() {
        return this.launch;
    }

    protected @NonNull String getPluginId() {
        return this.launchConfigurationDelegate.getDebugCore().getPluginId();
    }

    public StreamsProxy getStreamsProxy() {
        return this.streamsProxy;
    }

    public boolean isTerminated() {
        return this.getResult() != null;
    }

    protected void noThrow(@NonNull IOException e) {
    }

    public void setAttribute(String key, String value) {
    }

    public void terminate() throws DebugException {
        this.cancel();
    }
}

