/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ExpressionSynthesizer;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.AbstractQVTrelationExpressionSynthesizer;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class QVTrelationExpressionSynthesizer
extends AbstractQVTrelationExpressionSynthesizer {
    protected QVTrelationExpressionSynthesizer(@NonNull RelationAnalysis context) {
        super(context);
    }

    @Override
    protected @NonNull ExpressionSynthesizer createConditionalExpressionSynthesizer() {
        return new ConditionalExpressionSynthesizer(this.getRelationAnalysis());
    }

    @Override
    protected @NonNull ExpressionSynthesizer createRequiredExpressionSynthesizer() {
        return new RequiredExpressionSynthesizer(this.getRelationAnalysis());
    }

    public @NonNull RelationAnalysis getRelationAnalysis() {
        return (RelationAnalysis)((Object)this.context);
    }

    public @Nullable Node visitEnumerationLiteral(@NonNull EnumerationLiteral object) {
        return this.visiting((Visitable)object);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @Nullable Node visitRelationCallExp(@NonNull RelationCallExp relationCallExp) {
        RelationAnalysis relationAnalysis = this.getRelationAnalysis();
        Relation relation = relationAnalysis.getRule();
        boolean isWhen = false;
        Pattern containingPattern = QVTrelationUtil.basicGetContainingPattern((EObject)relationCallExp);
        if (containingPattern != null && relation.getWhen() == containingPattern) {
            isWhen = true;
        }
        Relation invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)relationCallExp);
        RelationAnalysis invokedRelationAnalysis = (RelationAnalysis)((RuleAnalysis)((Object)this.context)).getTransformationAnalysis().getRuleAnalysis((Rule)invokedRelation);
        InvocationAnalysis invocationAnalysis = relationAnalysis.createInvocationAnalysis(invokedRelationAnalysis, relationCallExp, isWhen);
        @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)invokedRelation);
        @NonNull List ownedArguments = QVTrelationUtil.Internal.getOwnedArgumentsList((RelationCallExp)relationCallExp);
        int size = rootVariables.size();
        assert (size == ownedArguments.size());
        int i = 0;
        while (i < size) {
            VariableDeclaration rootVariable = (VariableDeclaration)rootVariables.get(i);
            OCLExpression ownedArgument = (OCLExpression)ownedArguments.get(i);
            Node argumentNode = (Node)ownedArgument.accept((Visitor)this);
            assert (argumentNode != null);
            invocationAnalysis.add(rootVariable, argumentNode);
            ++i;
        }
        return null;
    }

    @Override
    public @Nullable Node visitTemplateExp(@NonNull TemplateExp templateExp) {
        Variable referredVariable = QVTrelationUtil.getBindsTo((TemplateExp)templateExp);
        return ((RuleAnalysis)((Object)this.context)).getReferenceNode((VariableDeclaration)referredVariable);
    }

    public static class ConditionalExpressionSynthesizer
    extends QVTrelationExpressionSynthesizer {
        protected ConditionalExpressionSynthesizer(@NonNull RelationAnalysis context) {
            super(context);
        }

        @Override
        protected @NonNull Node createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull Node sourceNode) {
            return ((RuleAnalysis)((Object)this.context)).createStepNode(name, callExp, sourceNode, false);
        }

        @Override
        protected boolean isUnconditional() {
            return false;
        }
    }

    public static class RequiredExpressionSynthesizer
    extends QVTrelationExpressionSynthesizer {
        protected RequiredExpressionSynthesizer(@NonNull RelationAnalysis context) {
            super(context);
        }

        @Override
        protected @NonNull Node createOperationCallNode(@NonNull CallExp callExp, @NonNull Operation operation, @NonNull Node @NonNull [] sourceAndArgumentNodes) {
            Node operationCallNode = super.createOperationCallNode(callExp, operation, sourceAndArgumentNodes);
            operationCallNode.setRequired();
            return operationCallNode;
        }

        @Override
        protected boolean isRequired() {
            return true;
        }
    }
}

