/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests.emftvm;

import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.impl.resource.EMFTVMResourceFactoryImpl;
import org.eclipse.m2m.atl.emftvm.util.DefaultModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.TimingData;
import org.eclipse.qvtd.doc.bigmde2016.tests.FamiliesGenerator;
import org.eclipse.qvtd.doc.bigmde2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.BigMDE2016CGTests;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.FamiliesPackage;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Persons.PersonsPackage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BigMDE2016EMFTVMTests
extends TestCase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testQVTcCompiler_Families2Persons_EMFTVM() throws Exception {
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                ExecEnv env = EmftvmFactory.eINSTANCE.createExecEnv();
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families", (Object)FamiliesPackage.eINSTANCE);
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Persons", (Object)PersonsPackage.eINSTANCE);
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("emftvm", new EMFTVMResourceFactoryImpl());
                Metamodel metaModel = EmftvmFactory.eINSTANCE.createMetamodel();
                metaModel.setResource(resourceSet.getResource(URI.createURI((String)"http://www.eclipse.org/m2m/atl/2011/EMFTVM"), true));
                env.registerMetaModel("METAMODEL", metaModel);
                metaModel = EmftvmFactory.eINSTANCE.createMetamodel();
                metaModel.setResource(resourceSet.getResource(URI.createURI((String)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families"), true));
                env.registerMetaModel("Families", metaModel);
                metaModel = EmftvmFactory.eINSTANCE.createMetamodel();
                metaModel.setResource(resourceSet.getResource(URI.createURI((String)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Persons"), true));
                env.registerMetaModel("Persons", metaModel);
                Resource familiesResource = resourceSet.createResource(URI.createURI((String)"src/org/eclipse/qvtd/doc/bigmde2016/tests/emftvm/samples-Families.xmi"));
                try {
                    familiesResource.load(new InputStream(){

                        @Override
                        public int read() {
                            return -1;
                        }

                        @Override
                        public int available() {
                            return 0;
                        }
                    }, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Model outModel = EmftvmFactory.eINSTANCE.createModel();
                outModel.setResource(resourceSet.createResource(URI.createFileURI((String)"out.xmi")));
                Model inModel = EmftvmFactory.eINSTANCE.createModel();
                familiesResource.getContents().clear();
                outModel.getResource().getContents().clear();
                env.clearModels();
                BigMDE2016CGTests.garbageCollect();
                List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
                familiesResource.getContents().addAll(rootObjects);
                inModel.setResource(familiesResource);
                env.registerInputModel("IN", inModel);
                env.registerOutputModel("OUT", outModel);
                DefaultModuleResolver mr = new DefaultModuleResolver("src/org/eclipse/qvtd/doc/bigmde2016/tests/emftvm/", (ResourceSet)new ResourceSetImpl());
                TimingData td = new TimingData();
                env.loadModule((ModuleResolver)mr, "Families2Persons");
                td.finishLoading();
                logger.printf("%9d, ", 10 * testSize);
                BigMDE2016CGTests.garbageCollect();
                long startTime = System.nanoTime();
                env.run(td);
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                td.finish();
                Resource personsResource = outModel.getResource();
                @NonNull EList rootObjects2 = personsResource.getContents();
                assert (rootObjects2.size() == 9 * testSize);
                ++n2;
            }
        }
        finally {
            logger.dispose();
        }
    }

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

