/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ContentsAnalysis<R extends Region> {
    protected final @NonNull ScheduleManager scheduleManager;
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> classDatum2newNodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull R>> classDatum2producingRegions = new HashMap<ClassDatum, List<R>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> classDatum2oldNodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull R>> classDatum2consumingRegions = new HashMap<ClassDatum, List<R>>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull List<@NonNull NavigableEdge>> propertyDatum2newEdges = new HashMap<PropertyDatum, List<NavigableEdge>>();

    public ContentsAnalysis(@NonNull ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
    }

    private void addNewEdge(@NonNull R region, @NonNull NavigableEdge newEdge) {
        PropertyDatum propertyDatum = this.getPropertyDatum(newEdge);
        this.addNewEdge(region, newEdge, propertyDatum);
    }

    private void addNewEdge(@NonNull R region, @NonNull NavigableEdge newEdge, @NonNull PropertyDatum propertyDatum) {
        List<@NonNull NavigableEdge> edges = this.propertyDatum2newEdges.get(propertyDatum);
        if (edges == null) {
            edges = new ArrayList<NavigableEdge>();
            this.propertyDatum2newEdges.put(propertyDatum, edges);
        }
        if (!edges.contains(newEdge)) {
            edges.add(newEdge);
            for (PropertyDatum superAbstractDatum : ClassUtil.nullFree((List)propertyDatum.getSuperPropertyDatums())) {
                this.addNewEdge(region, newEdge, superAbstractDatum);
            }
        }
    }

    private void addNewNode(@NonNull R region, @NonNull Node newNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)newNode);
        ClassDatum elementalClassDatum = this.scheduleManager.getElementalClassDatum(classDatum);
        for (ClassDatum superClassDatum : this.scheduleManager.getSuperClassDatums(elementalClassDatum)) {
            List<R> regions;
            List<@NonNull Node> nodes = this.classDatum2newNodes.get(superClassDatum);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                this.classDatum2newNodes.put(superClassDatum, nodes);
            }
            if ((regions = this.classDatum2producingRegions.get(superClassDatum)) == null) {
                regions = new ArrayList<R>();
                this.classDatum2producingRegions.put(superClassDatum, regions);
            }
            nodes.add(newNode);
            if (regions.contains(region)) continue;
            regions.add(region);
        }
    }

    private void addOldNode(@NonNull R region, @NonNull Node oldNode) {
        List<R> regions;
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)oldNode);
        List<@NonNull Node> nodes = this.classDatum2oldNodes.get(classDatum);
        if (nodes == null) {
            nodes = new ArrayList<Node>();
            this.classDatum2oldNodes.put(classDatum, nodes);
        }
        if ((regions = this.classDatum2consumingRegions.get(classDatum)) == null) {
            regions = new ArrayList<R>();
            this.classDatum2consumingRegions.put(classDatum, regions);
        }
        if (!nodes.contains(oldNode)) {
            nodes.add(oldNode);
        }
        if (!regions.contains(region)) {
            regions.add(region);
        }
    }

    public void addRegion(@NonNull R region) {
        for (Node oldNode : region.getOldNodes()) {
            if (oldNode.isDependency() || oldNode.isConstant()) continue;
            if (oldNode.isHead()) {
                this.addOldNode(region, oldNode);
                continue;
            }
            if (this.isOnlyCastOrRecursed(oldNode)) continue;
            this.addOldNode(region, oldNode);
        }
        for (Node newNode : region.getNewNodes()) {
            if (!newNode.isClass()) continue;
            this.addNewNode(region, newNode);
        }
        for (NavigableEdge newEdge : region.getRealizedNavigationEdges()) {
            this.addNewEdge(region, newEdge);
        }
    }

    public @NonNull String dumpClass2newNode() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull ClassDatum> classDatums = new ArrayList<ClassDatum>(this.classDatum2newNodes.keySet());
        Collections.sort(classDatums, NameUtil.NAMEABLE_COMPARATOR);
        for (ClassDatum classDatum : classDatums) {
            s.append("\n\t" + classDatum + " : ");
            ArrayList<@NonNull E> newNodes = new ArrayList(this.classDatum2newNodes.get(classDatum));
            Collections.sort(newNodes, NameUtil.NAMEABLE_COMPARATOR);
            for (Node newNode : newNodes) {
                s.append("\n\t\t" + newNode.getDisplayName());
            }
        }
        return s.toString();
    }

    public @NonNull String dumpClass2oldNode() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull ClassDatum> classDatums = new ArrayList<ClassDatum>(this.classDatum2oldNodes.keySet());
        Collections.sort(classDatums, NameUtil.NAMEABLE_COMPARATOR);
        for (ClassDatum classDatum : classDatums) {
            s.append("\n\t" + classDatum + " : ");
            ArrayList<@NonNull E> oldNodes = new ArrayList(this.classDatum2oldNodes.get(classDatum));
            Collections.sort(oldNodes, NameUtil.NAMEABLE_COMPARATOR);
            for (Node oldNode : oldNodes) {
                s.append("\n\t\t" + oldNode.getDisplayName());
            }
        }
        return s.toString();
    }

    private @Nullable Iterable<@NonNull NavigableEdge> getCompositeNewEdges(@NonNull NavigableEdge predicatedEdge) {
        HashSet<@NonNull E> realizedEdges = null;
        for (Map.Entry<PropertyDatum, List<NavigableEdge>> entry : this.propertyDatum2newEdges.entrySet()) {
            Property property = entry.getKey().getReferredProperty();
            if (property == null) continue;
            Property compositeProperty = null;
            if (property.isIsComposite()) {
                compositeProperty = property;
            } else {
                Property oppositeProperty = property.getOpposite();
                if (oppositeProperty != null && oppositeProperty.isIsComposite()) {
                    compositeProperty = oppositeProperty;
                }
            }
            if (compositeProperty == null) continue;
            if (realizedEdges == null) {
                realizedEdges = new HashSet();
            }
            realizedEdges.addAll(entry.getValue());
        }
        return realizedEdges;
    }

    public @NonNull Iterable<@NonNull R> getConsumingRegions(@NonNull ClassDatum classDatum) {
        List<@NonNull R> consumingRegions = this.classDatum2consumingRegions.get(classDatum);
        return consumingRegions != null ? consumingRegions : Collections.emptyList();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull NavigableEdge edge, @NonNull ClassDatum requiredClassDatum) {
        Property property = edge.getProperty();
        if (property.eContainer() == null) {
            return null;
        }
        if (property == this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty()) {
            return this.getCompositeNewEdges(edge);
        }
        PropertyDatum propertyDatum = this.getPropertyDatum(edge);
        @NonNull Iterable realizedEdges = this.propertyDatum2newEdges.get(propertyDatum);
        if (realizedEdges == null) {
            return null;
        }
        CompleteClass requiredClass = QVTscheduleUtil.getCompleteClass((ClassDatum)requiredClassDatum);
        ArrayList<NavigableEdge> conformantRealizedEdges = null;
        for (NavigableEdge realizedEdge : realizedEdges) {
            Node targetNode = realizedEdge.getEdgeTarget();
            CompleteClass realizedClass = targetNode.getCompleteClass();
            if (!QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)realizedClass, (CompleteClass)requiredClass)) continue;
            if (conformantRealizedEdges == null) {
                conformantRealizedEdges = new ArrayList<NavigableEdge>();
            }
            conformantRealizedEdges.add(realizedEdge);
        }
        return conformantRealizedEdges;
    }

    public @Nullable Iterable<@NonNull Node> getNewNodes(@NonNull ClassDatum classDatum) {
        return this.classDatum2newNodes.get(classDatum);
    }

    public @Nullable Iterable<@NonNull Node> getOldNodes(@NonNull ClassDatum classDatum) {
        return this.classDatum2oldNodes.get(classDatum);
    }

    public @NonNull Iterable<@NonNull R> getProducingRegions(@NonNull ClassDatum classDatum) {
        List<@NonNull R> producingRegions = this.classDatum2producingRegions.get(classDatum);
        return producingRegions != null ? producingRegions : Collections.emptyList();
    }

    private @NonNull PropertyDatum getPropertyDatum(@NonNull NavigableEdge producedEdge) {
        assert (!producedEdge.isCast());
        Property forwardProperty = QVTscheduleUtil.getProperty((NavigableEdge)producedEdge);
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)producedEdge.getEdgeSource());
        ClassDatum forwardClassDatum = this.scheduleManager.getElementalClassDatum(classDatum);
        return this.scheduleManager.getPropertyDatum(forwardClassDatum, forwardProperty);
    }

    private boolean isOnlyCastOrRecursed(@NonNull Node predicatedNode) {
        boolean isCast = false;
        for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)predicatedNode)) {
            if (!outgoingEdge.isCast() && !outgoingEdge.isRecursion()) {
                return false;
            }
            isCast = true;
        }
        return isCast;
    }

    private void removeNewEdge(@NonNull NavigableEdge newEdge) {
        PropertyDatum propertyDatum = this.getPropertyDatum(newEdge);
        this.removeNewEdge(newEdge, propertyDatum);
    }

    private void removeNewEdge(@NonNull NavigableEdge newEdge, @NonNull PropertyDatum propertyDatum) {
        List<@NonNull NavigableEdge> edges = this.propertyDatum2newEdges.get(propertyDatum);
        if (edges != null && edges.remove(newEdge)) {
            for (PropertyDatum superAbstractDatum : ClassUtil.nullFree((List)propertyDatum.getSuperPropertyDatums())) {
                this.removeNewEdge(newEdge, superAbstractDatum);
            }
        }
    }

    private void removeNewNode(@NonNull Node newNode) {
        List<@NonNull Node> nodes = this.classDatum2newNodes.get(newNode.getClassDatum());
        if (nodes != null) {
            nodes.remove(newNode);
        }
    }

    private void removeOldNode(@NonNull Node oldNode) {
        List<@NonNull Node> nodes = this.classDatum2oldNodes.get(oldNode.getClassDatum());
        if (nodes != null) {
            nodes.remove(oldNode);
        }
    }

    public void removeRegion(@NonNull R region) {
        for (Node oldNode : region.getOldNodes()) {
            this.removeOldNode(oldNode);
        }
        for (Node newNode : region.getNewNodes()) {
            this.removeNewNode(newNode);
        }
        for (NavigableEdge newEdge : region.getRealizedNavigationEdges()) {
            this.removeNewEdge(newEdge);
        }
    }
}

