/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartialPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class ResidualPartition
extends AbstractPartialPartition {
    public ResidualPartition(@NonNull MappingPartitioner partitioner, @NonNull ReachabilityForest reachabilityForest) {
        super(partitioner, reachabilityForest, "\u00abresidue\u00bb");
        for (Node node : partitioner.getTraceNodes()) {
            Node localSuccessNode;
            if (!this.hasNode(node)) {
                this.addNode(node, Role.SPECULATED);
            }
            if ((localSuccessNode = partitioner.basicGetLocalSuccessNode(node)) == null) continue;
            this.addNode(localSuccessNode, Role.PREDICATED);
        }
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)partitioner.getRegion())) {
            if (this.hasNode(node)) continue;
            this.addNode(node);
        }
        this.resolvePrecedingNodes();
        this.resolveEdges();
    }

    @Override
    public @NonNull MappingRegion createMicroMappingRegion(int partitionNumber) {
        return this.createMicroMappingRegion("\u00abresidue\u00bb", "_p" + partitionNumber);
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge)) {
            edgeRole = Role.PREDICATED;
        }
        return edgeRole;
    }
}

