/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractMainTab
extends AbstractLaunchConfigurationTab {
    private static final Logger logger = Logger.getLogger(AbstractMainTab.class);
    protected @Nullable OCLInternal ocl;

    public void dispose() {
        OCLInternal ocl2 = this.ocl;
        if (ocl2 != null) {
            ocl2.dispose();
            this.ocl = null;
        }
        super.dispose();
    }

    public @NonNull String getName() {
        return "Main";
    }

    protected boolean launchConfigurationExists(@NonNull String name) {
        ILaunchConfiguration[] cs = new ILaunchConfiguration[]{};
        try {
            cs = this.getLaunchManager().getLaunchConfigurations();
        }
        catch (CoreException ex) {
            logger.error((Object)"Failed to access ILaunchConfiguration", (Throwable)ex);
        }
        int i = 0;
        while (i < cs.length) {
            if (name.equals(cs[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String newLaunchConfigurationName(@NonNull String fileName) {
        if (!this.launchConfigurationExists(fileName)) {
            return fileName;
        }
        int i = 1;
        String configurationName;
        while (this.launchConfigurationExists(configurationName = String.valueOf(fileName) + " (" + i + ")")) {
            ++i;
        }
        return configurationName;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IWorkbenchPage activePage;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null) {
            String fileName;
            IEditorInput editorInput;
            IEditorPart activeEditor;
            Object adaptedObject;
            Object selectedObject;
            IFile iFile = null;
            ISelection selection = activePage.getSelection();
            if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (adaptedObject = ((IAdaptable)selectedObject).getAdapter(IFile.class)) instanceof IFile) {
                iFile = (IFile)adaptedObject;
            }
            if (iFile == null && (activeEditor = activePage.getActiveEditor()) != null && (editorInput = activeEditor.getEditorInput()) instanceof FileEditorInput) {
                iFile = ((FileEditorInput)editorInput).getFile();
            }
            if (iFile != null && (fileName = iFile.getName()).length() > 0) {
                configuration.rename(this.newLaunchConfigurationName(fileName));
                this.setDefaults(configuration, iFile);
            }
        }
    }

    protected abstract void setDefaults(@NonNull ILaunchConfigurationWorkingCopy var1, @NonNull IFile var2);
}

