/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.AbstractQVTc2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.AbstractQVTr2QVTcRelations;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.InvokedRelationToMappingForEnforcement;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.KeyToFunctionForIdentification;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.RelationalTransformationToMappingTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.TopLevelRelationToMappingForEnforcement;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationHelper;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class QVTr2QVTc
extends AbstractQVTc2QVTc {
    public static final @NonNull TracingOption CALL_TREE = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvtc/callTree");
    public static final @NonNull TracingOption SYNTHESIS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvtc/synthesis");
    public static final @NonNull TracingOption VARIABLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtr2qvtc/variables");
    protected final @NonNull StandardLibrary standardLibrary;
    private final @NonNull Resource qvtrResource;
    private final @NonNull Resource qvtcResource;
    protected final @NonNull QVTrelationHelper rHelper;
    protected final @NonNull QVTrNameGenerator nameGenerator;
    private @Nullable String traceNsURI = null;
    private final @NonNull Map<@NonNull Element, @NonNull Element> globalTarget2source = new HashMap<Element, Element>();
    private final @NonNull Map<@NonNull Element, @NonNull List<@NonNull Element>> globalSource2targets = new HashMap<Element, List<Element>>();
    private final @NonNull List<@NonNull Package> txTracePackages = new ArrayList<Package>();
    private final @NonNull Map<@NonNull Key, @NonNull Map<@NonNull TypedModel, @NonNull Function>> key2typedModel2function = new HashMap<Key, Map<TypedModel, Function>>();
    private final @NonNull Map<@NonNull CompleteClass, @Nullable Key> completeClass2key = new HashMap<CompleteClass, Key>();
    private final @NonNull Map<@NonNull Relation, @NonNull Class> relation2traceClass = new HashMap<Relation, Class>();
    private final @NonNull Map<@NonNull Relation, @Nullable List<@NonNull RelationCallExp>> relation2incomingWhenInvocations = new HashMap<Relation, List<RelationCallExp>>();
    private final @NonNull Map<@NonNull Relation, @Nullable List<@NonNull RelationCallExp>> relation2outgoingWhenInvocations = new HashMap<Relation, List<RelationCallExp>>();
    private final @NonNull Map<@NonNull Relation, @Nullable List<@NonNull RelationCallExp>> relation2incomingWhereInvocations = new HashMap<Relation, List<RelationCallExp>>();
    private final @NonNull Map<@NonNull Relation, @Nullable List<@NonNull RelationCallExp>> relation2outgoingWhereInvocations = new HashMap<Relation, List<RelationCallExp>>();
    @Deprecated
    private final @NonNull Map<@NonNull RelationCallExp, @NonNull Relation> invocation2invokingRelation = new HashMap<RelationCallExp, Relation>();
    private @NonNull CoreModel coreModel;
    private @NonNull Map<@NonNull RelationalTransformation, @NonNull Transformation> rTransformation2cTransformation = new HashMap<RelationalTransformation, Transformation>();
    private @NonNull Map<@NonNull RelationalTransformation, @NonNull Package> rTransformation2tracePackage = new HashMap<RelationalTransformation, Package>();
    private @Nullable RelationalTransformation2TracePackage relationalTransformation2TracePackage = null;
    private @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> relationalTypedModel2coreTypedModel = new HashMap<TypedModel, TypedModel>();
    private @NonNull Map<@NonNull Transformation, @NonNull Map<@NonNull String, @NonNull Mapping>> transformation2name2mapping = new HashMap<Transformation, Map<String, Mapping>>();
    private @NonNull Map<@NonNull Relation, @NonNull List<@NonNull Variable>> relation2rootVariables = new HashMap<Relation, List<Variable>>();
    private @NonNull Map<@NonNull Relation, @Nullable Set<@NonNull Relation>> relation2overridingRelations = new HashMap<Relation, Set<Relation>>();
    private @NonNull Map<@NonNull Relation, @NonNull AbstractQVTr2QVTcRelations> relation2relation2mapping = new HashMap<Relation, AbstractQVTr2QVTcRelations>();
    private @Nullable Property oclContainerProperty = null;

    public static @NonNull String getProjectName(@NonNull URI traceURI) {
        URI trimFileExtension = traceURI.trimFileExtension();
        if (trimFileExtension.isPlatform()) {
            return trimFileExtension.segment(1);
        }
        return trimFileExtension.segment(0);
    }

    public QVTr2QVTc(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource qvtrResource, @NonNull Resource qvtcResource) {
        super(environmentFactory);
        this.standardLibrary = environmentFactory.getStandardLibrary();
        this.qvtrResource = qvtrResource;
        this.qvtcResource = qvtcResource;
        this.rHelper = new QVTrelationHelper(environmentFactory);
        this.nameGenerator = new QVTrNameGenerator(this);
        this.coreModel = QVTcoreFactory.eINSTANCE.createCoreModel();
        TreeIterator it = qvtrResource.getAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            if (eo instanceof Key) {
                this.analyzeKey((Key)eo);
            }
            if (eo instanceof Relation) {
                Relation relation = (Relation)eo;
                this.analyzeInvocations(relation);
                this.analyzeRootVariables(relation);
                Relation anOverriddenRelation = relation;
                while (anOverriddenRelation != null) {
                    if (anOverriddenRelation != relation && !this.addOverridingRelation(anOverriddenRelation, relation)) break;
                    anOverriddenRelation = QVTrelationUtil.basicGetOverridden((Relation)anOverriddenRelation);
                }
            }
            if (!(eo instanceof Import)) continue;
            this.coreModel.getOwnedImports().add((Import)EcoreUtil.copy((EObject)eo));
        }
    }

    private boolean addOverridingRelation(@NonNull Relation overriddenRelation, @NonNull Relation overridingRelation) {
        assert (overridingRelation != overriddenRelation);
        Set<@NonNull Relation> overridingRelations = this.relation2overridingRelations.get(overriddenRelation);
        if (overridingRelations == null) {
            overridingRelations = new HashSet<Relation>();
            this.relation2overridingRelations.put(overriddenRelation, overridingRelations);
        }
        return overridingRelations.add(overridingRelation);
    }

    protected void analyzeInvocations(@NonNull Relation callingRelation) {
        Pattern wherePattern;
        Pattern whenPattern = callingRelation.getWhen();
        if (whenPattern != null) {
            this.analyzeInvocations(callingRelation, whenPattern, this.relation2incomingWhenInvocations, this.relation2outgoingWhenInvocations);
        }
        if ((wherePattern = callingRelation.getWhere()) != null) {
            this.analyzeInvocations(callingRelation, wherePattern, this.relation2incomingWhereInvocations, this.relation2outgoingWhereInvocations);
        }
    }

    protected void analyzeInvocations(@NonNull Relation callingRelation, @NonNull Pattern pattern, @NonNull Map<@NonNull Relation, @Nullable List<@NonNull RelationCallExp>> relation2incomingInvocations, @NonNull Map<@NonNull Relation, @Nullable List<@NonNull RelationCallExp>> relation2outgoingInvocations) {
        for (Predicate predicate : QVTrelationUtil.getOwnedPredicates((Pattern)pattern)) {
            OCLExpression predicateExpression = predicate.getConditionExpression();
            if (!(predicateExpression instanceof RelationCallExp)) continue;
            RelationCallExp relationInvocation = (RelationCallExp)predicateExpression;
            Relation invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)relationInvocation);
            List<@NonNull RelationCallExp> incomingInvocations = relation2incomingInvocations.get(invokedRelation);
            if (incomingInvocations == null) {
                incomingInvocations = new ArrayList<RelationCallExp>();
                relation2incomingInvocations.put(invokedRelation, incomingInvocations);
            }
            incomingInvocations.add(relationInvocation);
            Relation invokingRelation = QVTrelationUtil.getContainingRelation((EObject)relationInvocation);
            List<@NonNull RelationCallExp> outgoingInvocations = relation2outgoingInvocations.get(invokingRelation);
            if (outgoingInvocations == null) {
                outgoingInvocations = new ArrayList<RelationCallExp>();
                relation2outgoingInvocations.put(invokingRelation, outgoingInvocations);
            }
            outgoingInvocations.add(relationInvocation);
            this.invocation2invokingRelation.put(relationInvocation, callingRelation);
        }
    }

    protected void analyzeKey(@NonNull Key key) {
        CompleteClass identifies = this.getCompleteClass((Type)QVTrelationUtil.getIdentifies((Key)key));
        this.completeClass2key.put(identifies, key);
    }

    protected void analyzeRootVariables(@NonNull Relation relation) {
        ArrayList<@NonNull Variable> rootVariables = new ArrayList<Variable>();
        for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
            for (DomainPattern rDomainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)rDomain)) {
                TemplateExp rRootTemplateExpression = rDomainPattern.getTemplateExpression();
                if (rRootTemplateExpression == null) continue;
                rootVariables.add(QVTrelationUtil.getBindsTo((TemplateExp)rRootTemplateExpression));
            }
        }
        this.relation2rootVariables.put(relation, rootVariables);
    }

    public @Nullable Class basicGetSignatureClass(@NonNull Relation rRelation) {
        return this.getRelationalTransformation2TracePackage().basicGetSignatureClass(rRelation);
    }

    public @Nullable Property basicGetTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) throws CompilerChainException {
        Property traceProperty = this.getRelationalTransformation2TracePackage().basicGetTraceProperty(aClass, rVariable);
        if (traceProperty != null) {
            return traceProperty;
        }
        String name = QVTrelationUtil.getName((NamedElement)rVariable);
        CompleteClass completeClass = this.getCompleteClass(aClass);
        return completeClass.getProperty(name);
    }

    public @NonNull CoreDomain createCoreDomain(@NonNull TypedModel typedModel) {
        CoreDomain coreDomain = QVTcoreFactory.eINSTANCE.createCoreDomain();
        coreDomain.setTypedModel(typedModel);
        coreDomain.setName(QVTrelationUtil.getName((NamedElement)typedModel));
        GuardPattern guardPattern = QVTcoreFactory.eINSTANCE.createGuardPattern();
        coreDomain.setGuardPattern(guardPattern);
        BottomPattern bottomPattern = QVTcoreFactory.eINSTANCE.createBottomPattern();
        coreDomain.setBottomPattern(bottomPattern);
        return coreDomain;
    }

    @Override
    protected @NonNull AbstractQVTc2QVTc.AbstractCreateVisitor<@NonNull ?> createCreateVisitor() {
        return new CreateVisitor(this);
    }

    public @NonNull String createKeyFunctionName(@NonNull TypedModel rTypedModel, @NonNull Key rKey) {
        return this.nameGenerator.createKeyFunctionName(rTypedModel, rKey);
    }

    public @NonNull String createKeyedVariableName(@NonNull Variable identifiedVariable) {
        return this.nameGenerator.createKeyedVariableName(identifiedVariable);
    }

    @NonNull Mapping createMapping(@NonNull Relation relation, @NonNull String name) {
        RelationalTransformation rt = QVTrelationUtil.getTransformation((Relation)relation);
        @NonNull Transformation cTransformation = this.getCoreTransformation(rt);
        Map<@NonNull String, @NonNull Mapping> name2mapping = this.transformation2name2mapping.get(cTransformation);
        if (name2mapping == null) {
            name2mapping = new HashMap<String, Mapping>();
            this.transformation2name2mapping.put(cTransformation, name2mapping);
        }
        Mapping coreMapping = name2mapping.get(name);
        assert (coreMapping == null);
        coreMapping = this.helper.createMapping(name);
        this.putGlobalTrace((Element)coreMapping, (Element)relation);
        coreMapping.setTransformation(cTransformation);
        name2mapping.put(name, coreMapping);
        return coreMapping;
    }

    public @NonNull RealizedVariable createRealizedVariable(@NonNull TypedElement typedElement) {
        return this.createRealizedVariable(QVTrelationUtil.getName((NamedElement)typedElement), QVTrelationUtil.getType((TypedElement)typedElement));
    }

    public @NonNull RealizedVariable createRealizedVariable(@NonNull String name, @NonNull Type type) {
        RealizedVariable realizedVariable = QVTcoreFactory.eINSTANCE.createRealizedVariable();
        realizedVariable.setName(name);
        realizedVariable.setType(type);
        realizedVariable.setIsRequired(true);
        return realizedVariable;
    }

    public @NonNull String createTraceClassName(@NonNull Relation relation) {
        return this.nameGenerator.createTraceClassName(relation);
    }

    @Override
    protected @NonNull AbstractQVTc2QVTc.AbstractUpdateVisitor<@NonNull ?> createUpdateVisitor() {
        return new UpdateVisitor(this);
    }

    public void dispose() {
    }

    public @NonNull CompleteClass getCompleteClass(@NonNull Type type) {
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(type);
        return completeClass;
    }

    @NonNull Transformation getCoreTransformation(@NonNull RelationalTransformation rTransformation) {
        return (Transformation)ClassUtil.nonNullState((Object)this.rTransformation2cTransformation.get(rTransformation));
    }

    @NonNull TypedModel getCoreTypedModel(@NonNull TypedModel relationTypedModel) {
        return (TypedModel)ClassUtil.nonNullState((Object)this.relationalTypedModel2coreTypedModel.get(relationTypedModel));
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @Nullable List<@NonNull Element> getGlobalTargets(@NonNull Element element) {
        return this.globalSource2targets.get(element);
    }

    @Override
    public @NonNull QVTcoreHelper getHelper() {
        return this.helper;
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getIncomingWhenInvocationsOf(@NonNull Relation relation) {
        return this.relation2incomingWhenInvocations.get(relation);
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getIncomingWhereInvocationsOf(@NonNull Relation relation) {
        return this.relation2incomingWhereInvocations.get(relation);
    }

    @NonNull Relation getInvokingRelation(@NonNull RelationCallExp rInvocation) {
        Relation rRelation1 = (Relation)ClassUtil.nonNullState((Object)this.invocation2invokingRelation.get(rInvocation));
        Relation rRelation2 = (Relation)((Predicate)rInvocation.eContainer()).getPattern().eContainer();
        assert (rRelation1 == rRelation2);
        return rRelation1;
    }

    public @Nullable Key getKeyForCompleteClass(@NonNull CompleteClass completeClass) {
        Key key = this.completeClass2key.get(completeClass);
        if (key == null && !this.completeClass2key.containsKey(completeClass)) {
            HashSet<@NonNull Property> parts = null;
            for (CompleteClass superCompleteClass : completeClass.getProperSuperCompleteClasses()) {
                Key superKey = this.getKeyForCompleteClass(superCompleteClass);
                if (superKey == null) continue;
                if (parts == null) {
                    parts = new HashSet<Property>();
                }
                for (Property property : QVTrelationUtil.getOwnedParts((Key)superKey)) {
                    parts.add(property);
                }
                for (Property property : QVTrelationUtil.getOwnedOppositeParts((Key)superKey)) {
                    parts.add(QVTrelationUtil.getOpposite((Property)property));
                }
            }
            if (parts != null) {
                key = new QVTrelationHelper(this.environmentFactory).createKey(completeClass.getPrimaryClass(), parts);
            }
            this.completeClass2key.put(completeClass, key);
        }
        return key;
    }

    public @Nullable Key getKeyForType(@NonNull Type type) {
        CompleteClass completeClass = this.getCompleteClass(type);
        return this.getKeyForCompleteClass(completeClass);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull Function getKeyFunction(@NonNull TypedModel rTypedModel, @NonNull Key rKey) throws CompilerChainException {
        Function cKeyFunction;
        Map<@NonNull TypedModel, @NonNull Function> typedModel2function = this.key2typedModel2function.get(rKey);
        if (typedModel2function == null) {
            typedModel2function = new HashMap<TypedModel, Function>();
            this.key2typedModel2function.put(rKey, typedModel2function);
        }
        if ((cKeyFunction = typedModel2function.get(rTypedModel)) == null) {
            @NonNull Iterable usedClasses = QVTrelationUtil.getUsedClasses((TypedModel)rTypedModel);
            @NonNull Class identifiedClass = QVTrelationUtil.getIdentifies((Key)rKey);
            assert (Iterables.contains((Iterable)usedClasses, (Object)identifiedClass));
            SYNTHESIS.println("key " + rKey);
            KeyToFunctionForIdentification keyToMapping = new KeyToFunctionForIdentification(this, rTypedModel, rKey);
            cKeyFunction = keyToMapping.transform();
            this.getCoreTransformation(QVTrelationUtil.getContainingTransformation((EObject)rTypedModel)).getOwnedOperations().add(cKeyFunction);
            typedModel2function.put(rTypedModel, cKeyFunction);
        }
        return cKeyFunction;
    }

    public @NonNull QVTrNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public @NonNull Property getOclContainerProperty() {
        Property oclContainerProperty2 = this.oclContainerProperty;
        if (oclContainerProperty2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            oclContainerProperty2 = (Property)NameUtil.getNameable((Iterable)oclElementType.getOwnedProperties(), (String)"oclContainer");
            assert (oclContainerProperty2 != null) : "OCL Standard Library has no OclElement::oclContainer property";
            this.oclContainerProperty = oclContainerProperty2;
        }
        return oclContainerProperty2;
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getOutgoingWhenInvocationsOf(@NonNull Relation relation) {
        return this.relation2outgoingWhenInvocations.get(relation);
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getOutgoingWhereInvocationsOf(@NonNull Relation relation) {
        return this.relation2outgoingWhereInvocations.get(relation);
    }

    public @NonNull Iterable<@NonNull Relation> getOverridingRelations(@NonNull Relation overriddenRelation) {
        Set<@NonNull Relation> overridingRelations = this.relation2overridingRelations.get(overriddenRelation);
        return overridingRelations != null ? overridingRelations : Collections.emptyList();
    }

    public Predicate getPredicateForRelationCallExp(RelationCallExp ri) {
        return null;
    }

    protected @NonNull Property getProperty(Type aClass, String name) throws CompilerChainException {
        assert (aClass != null && name != null);
        CompleteClass completeClass = this.getCompleteClass(aClass);
        Property p = completeClass.getProperty(name);
        if (p != null) {
            return p;
        }
        throw new CompilerChainException("No property '" + name + "' in '" + aClass + "::" + "'", new Object[0]);
    }

    public Resource getQvtcSource() {
        return this.qvtcResource;
    }

    public @NonNull RelationalTransformation2TracePackage getRelationalTransformation2TracePackage() {
        return (RelationalTransformation2TracePackage)ClassUtil.nonNullState((Object)this.relationalTransformation2TracePackage);
    }

    public @NonNull List<@NonNull Variable> getRootVariables(@NonNull Relation relation) {
        return (List)ClassUtil.nonNullState(this.relation2rootVariables.get(relation));
    }

    public @NonNull Class getSignatureClass(@NonNull Relation rRelation) {
        return this.getRelationalTransformation2TracePackage().getSignatureClass(rRelation);
    }

    protected @NonNull Property getSignatureProperty(@NonNull Class aClass, @NonNull VariableDeclaration rVariable) {
        return this.getRelationalTransformation2TracePackage().getSignatureProperty(aClass, rVariable);
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @NonNull Class getTraceClass(@NonNull Relation rRelation) {
        return this.getRelationalTransformation2TracePackage().getTraceClass(rRelation);
    }

    @NonNull Package getTracePackage(@NonNull RelationalTransformation rTransformation) {
        return (Package)ClassUtil.nonNullState((Object)this.rTransformation2tracePackage.get(rTransformation));
    }

    protected @NonNull Property getTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) throws CompilerChainException {
        Property property = this.getRelationalTransformation2TracePackage().basicGetTraceProperty(aClass, rVariable);
        if (property != null) {
            return property;
        }
        property = this.getProperty(aClass, rVariable.getName());
        if (rVariable instanceof Property) assert (rVariable == property);
        return property;
    }

    public @NonNull Property getTraceProperty(@NonNull RelationCallExp rInvocation) {
        return this.getRelationalTransformation2TracePackage().getTraceProperty(rInvocation);
    }

    private void getUsedGenPackageClosure(@NonNull ProblemHandler problemHandler, @NonNull Map<@NonNull String, @NonNull GenPackage> uri2genPackage, @NonNull Iterable<@NonNull ? extends GenPackage> genPackages) {
        for (GenPackage genPackage : genPackages) {
            String nsURI = genPackage.getNSURI();
            if (nsURI == null) {
                problemHandler.addProblem(new CompilerChainException("Null nsURI for " + genPackage, genPackage));
                continue;
            }
            GenPackage oldGenPackage = uri2genPackage.put(nsURI, genPackage);
            if (oldGenPackage == genPackage) continue;
            if (oldGenPackage != null) {
                problemHandler.addProblem(new CompilerChainException("Conflicting " + oldGenPackage + " ignored", oldGenPackage));
                continue;
            }
            GenModel newGenModel = genPackage.getGenModel();
            EList newUsedGenPackages = ClassUtil.nullFree((EList)newGenModel.getUsedGenPackages());
            this.getUsedGenPackageClosure(problemHandler, uri2genPackage, (Iterable<? extends GenPackage>)newUsedGenPackages);
        }
    }

    protected void mapQueries(@NonNull RelationalTransformation rTransformation, @NonNull Transformation cTransformation) {
        ArrayList<@NonNull Operation> cOperations = new ArrayList<Operation>();
        for (Operation rOperation : QVTbaseUtil.getOwnedOperations((Transformation)rTransformation)) {
            Element cOperation = (Element)rOperation.accept((Visitor)this.createVisitor);
            if (!(cOperation instanceof Operation)) continue;
            cOperations.add((Operation)cOperation);
            this.putGlobalTrace(cOperation, (Element)rOperation);
        }
        cTransformation.getOwnedOperations().addAll(cOperations);
        for (Operation cOperation : cOperations) {
            cOperation.accept((Visitor)this.updateVisitor);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void mapTransformation(@NonNull RelationalTransformation rTransformation, @NonNull Transformation cTransformation) throws CompilerChainException {
        @NonNull ArrayList rRelations = Lists.newArrayList((Iterable)QVTrelationUtil.getOwnedRelations((RelationalTransformation)rTransformation));
        Collections.sort(rRelations, new RelationComparator());
        Variable cThis = QVTbaseUtil.getContextVariable((StandardLibrary)this.standardLibrary, (Transformation)cTransformation);
        Variable rThis = QVTbaseUtil.getContextVariable((StandardLibrary)this.standardLibrary, (Transformation)rTransformation);
        this.addTrace((Element)rThis, (Element)cThis);
        this.mapQueries(rTransformation, cTransformation);
        for (Relation rRelation : rRelations) {
            AbstractQVTr2QVTcRelations relation2mappings;
            if (rRelation.isIsTopLevel()) {
                SYNTHESIS.println("topLevel " + rRelation);
                relation2mappings = new TopLevelRelationToMappingForEnforcement(this, rRelation);
            } else {
                relation2mappings = new InvokedRelationToMappingForEnforcement(this, rRelation);
            }
            ((AbstractQVTr2QVTcRelations)relation2mappings).analyze();
            this.relation2relation2mapping.put(rRelation, relation2mappings);
        }
        for (Relation rRelation : rRelations) {
            AbstractQVTr2QVTcRelations relation2mapping = this.relation2relation2mapping.get(rRelation);
            assert (relation2mapping != null);
            relation2mapping.synthesize();
        }
        CompilerUtil.normalizeNameables(QVTbaseUtil.Internal.getOwnedOperationsList((Class)cTransformation));
        CompilerUtil.normalizeNameables(QVTbaseUtil.getRule((Transformation)cTransformation));
    }

    public void addRelation2Mappings(@NonNull AbstractQVTr2QVTcRelations relation2mappings) {
        Relation rRelation = relation2mappings.getRelation();
        this.relation2relation2mapping.put(rRelation, relation2mappings);
    }

    public @NonNull AbstractQVTr2QVTcRelations getRelation2Mappings(@NonNull Relation rRelation) {
        return (AbstractQVTr2QVTcRelations)((Object)ClassUtil.nonNullState((Object)((Object)this.relation2relation2mapping.get(rRelation))));
    }

    public void prepare() {
        try {
            this.qvtrResource.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void putCoreTransformation(@NonNull RelationalTransformation relationTransformation, @NonNull Transformation cTransformation) {
        this.rTransformation2cTransformation.put(relationTransformation, cTransformation);
        this.putGlobalTrace((Element)cTransformation, (Element)relationTransformation);
    }

    void putGlobalTrace(@NonNull Element coreElement, @NonNull Element relationElement) {
        Element oldRelationElement = this.globalTarget2source.put(coreElement, relationElement);
        assert (oldRelationElement == null);
        List<@NonNull Element> targets = this.globalSource2targets.get(relationElement);
        if (targets == null) {
            targets = new ArrayList<Element>();
            this.globalSource2targets.put(relationElement, targets);
        }
        targets.add(coreElement);
    }

    public void putRelationTrace(@NonNull Relation rRelation, @NonNull Class traceClass) {
        Class oldTraceClass = this.relation2traceClass.put(rRelation, traceClass);
        assert (oldTraceClass == null);
    }

    public void putTracePackage(@NonNull RelationalTransformation rt, @NonNull Package tracePackage) {
        Package oldTracePackage = this.rTransformation2tracePackage.put(rt, tracePackage);
        assert (oldTracePackage == null);
    }

    public void putTypedModel(@NonNull TypedModel relationTypedModel, @NonNull TypedModel coreTypedModel) {
        TypedModel oldTypedModel = this.relationalTypedModel2coreTypedModel.put(relationTypedModel, coreTypedModel);
        assert (oldTypedModel == null);
    }

    public void saveCore(@NonNull Resource asResource, @NonNull Map<?, ?> options) throws IOException {
        asResource.getContents().add((Object)this.coreModel);
        for (Package asPackage : this.txTracePackages) {
            Import asImport = this.helper.createImport(null, (Namespace)asPackage);
            this.coreModel.getOwnedImports().add(asImport);
        }
        asResource.save(options);
    }

    public @NonNull GenModel saveGenModel(@NonNull ProblemHandler problemHandler, @NonNull Resource asResource, @NonNull URI traceURI, @NonNull URI genModelURI, @Nullable Map<@NonNull String, @Nullable String> genModelOptions, @NonNull Map<Object, Object> saveOptions2, @Nullable Collection<@NonNull ? extends GenPackage> usedGenPackages) throws IOException {
        String copyrightText;
        URI trimFileExtension = traceURI.trimFileExtension();
        String projectName = QVTr2QVTc.getProjectName(traceURI);
        Resource genmodelResource = this.environmentFactory.getResourceSet().createResource(genModelURI);
        @NonNull GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.getForeignModel().add((Object)traceURI.lastSegment());
        String string = copyrightText = genModelOptions != null ? genModelOptions.get("genModelCopyrightText") : null;
        if (copyrightText != null) {
            genModel.setCopyrightText(copyrightText);
        }
        HashMap<@NonNull String, @NonNull GenPackage> uri2genPackage = new HashMap<String, GenPackage>();
        ArrayList<@NonNull V> allUsedGenPackages = new ArrayList();
        if (usedGenPackages != null) {
            this.getUsedGenPackageClosure(problemHandler, uri2genPackage, usedGenPackages);
            allUsedGenPackages.addAll(uri2genPackage.values());
            Collections.sort(allUsedGenPackages, GenPackageComparator.INSTANCE);
            genModel.getUsedGenPackages().addAll(allUsedGenPackages);
        }
        genModel.setModelDirectory("/" + projectName + "/src-gen");
        genModel.setModelPluginID(projectName);
        genModel.setModelName(trimFileExtension.lastSegment());
        genModel.setBundleManifest(false);
        genModel.setUpdateClasspath(false);
        genModel.setImporterID(new EcoreImporter().getID());
        genModel.setComplianceLevel(GenJDKLevel.JDK80_LITERAL);
        genModel.setCopyrightFields(false);
        genModel.setOperationReflection(true);
        genModel.setImportOrganizing(true);
        genModel.setRootExtendsClass(MinimalEObjectImpl.Container.class.getName());
        genModel.setPluginKey("");
        genmodelResource.getContents().add((Object)genModel);
        String basePrefix = genModelOptions != null ? genModelOptions.get("genModelBasePrefix") : null;
        EList genPackages = genModel.getGenPackages();
        for (EObject eObject : asResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            Model asModel = (Model)eObject;
            for (Package asPackage : QVTrelationUtil.getOwnedPackages((Model)asModel)) {
                GenPackage genPackage = genModel.createGenPackage();
                EPackage ePackage = (EPackage)asPackage.getESObject();
                genPackage.setEcorePackage(ePackage);
                genPackage.setPrefix(ePackage.getName());
                if (basePrefix != null) {
                    genPackage.setBasePackage(basePrefix);
                }
                genPackages.add(genPackage);
            }
            HashSet<@NonNull Package> asPackages = new HashSet<Package>();
            for (EObject element : new TreeIterable((EObject)asModel, false)) {
                Package asPackage;
                if (!(element instanceof Property)) continue;
                Property property = (Property)element;
                Type type = property.getType();
                while (type instanceof CollectionType) {
                    type = ((CollectionType)type).getElementType();
                }
                if (!(type instanceof Class) || (asPackage = ((Class)type).getOwningPackage()) == null) continue;
                asPackages.add(asPackage);
            }
            for (Import asImport : QVTrelationUtil.getOwnedImports((Model)asModel)) {
                Namespace asNamespace = asImport.getImportedNamespace();
                if (!(asNamespace instanceof Package)) continue;
                @NonNull Package asPackage = (Package)asNamespace;
                asPackages.add(asPackage);
            }
            ArrayList<@NonNull E> asPackageList = new ArrayList(asPackages);
            Collections.sort(asPackageList, NameUtil.NAMEABLE_COMPARATOR);
            for (Package asPackage : asPackageList) {
                EPackage ePackage = (EPackage)asPackage.getESObject();
                if (ePackage == null) continue;
                GenPackage genPackage = null;
                if (allUsedGenPackages != null) {
                    for (GenPackage usedGenPackage : allUsedGenPackages) {
                        EPackage ecorePackage = usedGenPackage.getEcorePackage();
                        if (ecorePackage == null || !ClassUtil.safeEquals((Object)ecorePackage.getNsURI(), (Object)ePackage.getNsURI())) continue;
                        genPackage = usedGenPackage;
                        break;
                    }
                }
                if (genPackage != null) continue;
                genPackage = genModel.createGenPackage();
                genPackage.setEcorePackage(ePackage);
                genPackage.setPrefix(ePackage.getName());
                if (basePrefix != null) {
                    genPackage.setBasePackage(basePrefix);
                }
                genPackages.add(genPackage);
            }
        }
        genModel.reconcile();
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>(saveOptions2);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("LINE_DELIMITER", "\n");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        genmodelResource.save(saveOptions);
        return genModel;
    }

    public @NonNull Resource saveTrace(@NonNull Resource asResource, @NonNull URI traceURI, @NonNull URI genModelURI, @Nullable Map<@NonNull String, @Nullable String> traceOptions, @NonNull Map<?, ?> saveOptions) throws IOException {
        Model root = PivotFactory.eINSTANCE.createModel();
        root.setExternalURI(traceURI.toString());
        asResource.getContents().add((Object)root);
        if (this.traceNsURI != null && this.txTracePackages.size() == 1) {
            this.txTracePackages.get(0).setURI(this.traceNsURI);
        }
        Iterator<Package> iterator = this.txTracePackages.iterator();
        while (iterator.hasNext()) {
            Package txTracePackage;
            @NonNull Package rootPackage = txTracePackage = iterator.next();
            EObject eContainer = rootPackage.eContainer();
            while (eContainer instanceof Package) {
                rootPackage = (Package)eContainer;
                eContainer = eContainer.eContainer();
            }
            if (root.getOwnedPackages().contains(rootPackage)) continue;
            root.getOwnedPackages().add(rootPackage);
        }
        AS2Ecore as2ecore = new AS2Ecore((EnvironmentFactoryInternal)this.environmentFactory, traceURI, null);
        XMLResource ecoreResource = as2ecore.convertResource(asResource, traceURI);
        ecoreResource.save(saveOptions);
        return ecoreResource;
    }

    public void setTraceNsURI(@Nullable String traceNsURI) {
        this.traceNsURI = traceNsURI;
    }

    public void transformToCoreTransformations() throws CompilerChainException {
        this.setDebugSource(this.qvtrResource);
        for (EObject eObject : this.qvtrResource.getContents()) {
            if (!(eObject instanceof RelationModel)) continue;
            RelationModel relationModel = (RelationModel)eObject;
            String externalURI = relationModel.getExternalURI();
            if (externalURI.endsWith(".qvtras")) {
                externalURI = externalURI.replace(".qvtras", ".qvtcas");
            } else if (externalURI.endsWith(".qvtr")) {
                externalURI = externalURI.replace(".qvtr", ".qvtcas");
            }
            this.coreModel.setExternalURI(externalURI);
            this.transformToCoreTransformationHierarchy(QVTrelationUtil.Internal.getOwnedPackagesList((Model)this.coreModel), QVTrelationUtil.getOwnedPackages((Model)relationModel));
        }
        ArrayList<@NonNull RelationalTransformation> rTransformations = new ArrayList<RelationalTransformation>(this.rTransformation2cTransformation.keySet());
        Collections.sort(rTransformations, NameUtil.NAMEABLE_COMPARATOR);
        for (RelationalTransformation rTransformation : rTransformations) {
            Transformation cTransformation = this.getCoreTransformation(rTransformation);
            this.pushScope((NamedElement)cTransformation);
            this.mapTransformation(rTransformation, cTransformation);
            this.popScope();
        }
    }

    private void transformToCoreTransformationHierarchy(@NonNull List<@NonNull Package> corePackages, @NonNull Iterable<@NonNull Package> relationPackages) {
        for (Package relationPackage : relationPackages) {
            String name = relationPackage.getName();
            assert (name != null);
            @NonNull Package corePackage = this.helper.createPackage(name, relationPackage.getNsPrefix(), relationPackage.getURI());
            corePackages.add(corePackage);
            for (Class relationClass : QVTrelationUtil.getOwnedClasses((Package)relationPackage)) {
                if (!(relationClass instanceof RelationalTransformation)) continue;
                RelationalTransformationToMappingTransformation rTransformationToMappingTransformation = new RelationalTransformationToMappingTransformation(this);
                Transformation cTransformation = rTransformationToMappingTransformation.doRelationalTransformationToMappingTransformation((RelationalTransformation)relationClass);
                corePackage.getOwnedClasses().add(cTransformation);
            }
            CompilerUtil.normalizeNameables(QVTrelationUtil.Internal.getOwnedClassesList((Package)corePackage));
            this.transformToCoreTransformationHierarchy(QVTrelationUtil.Internal.getOwnedPackagesList((Package)corePackage), QVTrelationUtil.getOwnedPackages((Package)relationPackage));
        }
    }

    public void transformToTracePackages() throws CompilerChainException {
        ArrayList<@NonNull Package> rootTracePackages = null;
        for (EObject eObject : this.qvtrResource.getContents()) {
            List<Package> tracePackages;
            if (!(eObject instanceof RelationModel) || (tracePackages = this.transformToTracePackageHierarchy(QVTrelationUtil.getOwnedPackages((Model)((RelationModel)eObject)))) == null) continue;
            if (rootTracePackages == null) {
                rootTracePackages = new ArrayList<Package>();
            }
            rootTracePackages.addAll(tracePackages);
        }
        if (rootTracePackages != null) {
            CompilerUtil.normalizeNameables(rootTracePackages);
        }
    }

    private @Nullable List<@NonNull Package> transformToTracePackageHierarchy(@NonNull Iterable<@NonNull Package> relationPackages) throws CompilerChainException {
        ArrayList<@NonNull Package> nestingTracePackages = null;
        for (Package relationPackage : relationPackages) {
            ArrayList<Package> nestedTracePackages = null;
            for (Class relationClass : QVTrelationUtil.getOwnedClasses((Package)relationPackage)) {
                if (!(relationClass instanceof RelationalTransformation)) continue;
                this.relationalTransformation2TracePackage = new RelationalTransformation2TracePackage(this, (RelationalTransformation)relationClass);
                Package nestedTracePackage = this.relationalTransformation2TracePackage.transform();
                this.txTracePackages.add(nestedTracePackage);
                if (nestedTracePackages == null) {
                    nestedTracePackages = new ArrayList();
                }
                nestedTracePackages.add(nestedTracePackage);
            }
            List<@NonNull Package> nestedTracePackages2 = this.transformToTracePackageHierarchy(QVTrelationUtil.Internal.getOwnedPackagesList((Package)relationPackage));
            if (nestedTracePackages2 != null) {
                if (nestedTracePackages == null) {
                    nestedTracePackages = new ArrayList<Package>();
                }
                nestedTracePackages.addAll(nestedTracePackages2);
            }
            if (nestedTracePackages == null) continue;
            CompilerUtil.normalizeNameables(nestedTracePackages);
            if (nestingTracePackages == null) {
                nestingTracePackages = new ArrayList<Package>();
            }
            nestingTracePackages.addAll(nestedTracePackages);
        }
        return nestingTracePackages;
    }

    protected static class CreateVisitor
    extends AbstractQVTc2QVTc.AbstractCreateVisitor<QVTr2QVTc> {
        public CreateVisitor(@NonNull QVTr2QVTc context) {
            super(context);
        }
    }

    public static final class GenPackageComparator
    implements Comparator<GenPackage> {
        public static final @NonNull GenPackageComparator INSTANCE = new GenPackageComparator();

        @Override
        public int compare(@NonNull GenPackage o1, @NonNull GenPackage o2) {
            String n1 = String.valueOf(o1.getNSURI());
            String n2 = String.valueOf(o2.getNSURI());
            return n1.compareTo(n2);
        }
    }

    public static final class RelationComparator
    implements Comparator<Relation> {
        private @NonNull Map<@NonNull Relation, @NonNull Set<@NonNull Relation>> relation2overriddens = new HashMap<Relation, Set<Relation>>();

        @Override
        public int compare(@NonNull Relation r1, @NonNull Relation r2) {
            boolean t2;
            boolean t1 = r1.isIsTopLevel();
            if (t1 != (t2 = r2.isIsTopLevel())) {
                return t1 ? -1 : 1;
            }
            Set<@NonNull Relation> o1 = this.getOverriddens(r1);
            Set<@NonNull Relation> o2 = this.getOverriddens(r2);
            if (o1.contains(r2)) {
                assert (!o2.contains(r1));
                return 1;
            }
            if (o2.contains(r1)) {
                return -1;
            }
            String n1 = NameUtil.getSafeName((Nameable)r1);
            String n2 = NameUtil.getSafeName((Nameable)r2);
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }

        private @NonNull Set<@NonNull Relation> getOverriddens(@NonNull Relation relation) {
            Set<@NonNull Relation> overriddens = this.relation2overriddens.get(relation);
            if (overriddens == null) {
                overriddens = new HashSet<Relation>();
                Relation overridden = relation;
                while (overridden != null) {
                    if (!overriddens.add(overridden)) {
                        System.err.println("Cyclic override for " + relation + " at " + overridden);
                        break;
                    }
                    overridden = QVTrelationUtil.basicGetOverridden((Relation)overridden);
                }
                this.relation2overriddens.put(relation, overriddens);
            }
            return overriddens;
        }
    }

    protected static class UpdateVisitor
    extends AbstractQVTc2QVTc.AbstractUpdateVisitor<QVTr2QVTc> {
        public UpdateVisitor(@NonNull QVTr2QVTc context) {
            super(context);
        }
    }
}

