/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edges;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Nodes;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region2Depth;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Role;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SuperRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitor;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class RootCompositionRegion
extends AbstractRegion
implements SimpleRegion {
    private SimpleNode nullNode = null;
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull Map<@Nullable Property, @NonNull SimpleNode>> classDatumAnalysis2property2node = new HashMap<ClassDatumAnalysis, Map<Property, SimpleNode>>();
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull Map<@Nullable ClassDatumAnalysis, @NonNull SimpleNode>> classDatumAnalysis2type2node = new HashMap<ClassDatumAnalysis, Map<ClassDatumAnalysis, SimpleNode>>();

    protected RootCompositionRegion(@NonNull SuperRegion superRegion) {
        super(superRegion);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitRootCompositionRegion(this);
    }

    @Override
    protected @NonNull SymbolNameBuilder computeSymbolName() {
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("__root__");
        return s;
    }

    @Override
    public void createIncomingConnections() {
    }

    public @NonNull SimpleNode getIntroducerNode(@NonNull Node consumerNode) {
        SimpleNode introducedNode;
        NavigationEdge containerEdge = null;
        Property parent2childProperty = null;
        ClassDatumAnalysis containingClassDatumAnalysis = null;
        SchedulerConstants scheduler = this.getSchedulerConstants();
        for (NavigationEdge edge : consumerNode.getNavigationEdges()) {
            Property property = edge.getProperty().getOpposite();
            if (property == null || !property.isIsComposite()) continue;
            containerEdge = edge;
            parent2childProperty = property;
            if (property != scheduler.getOclContainerProperty()) break;
            containingClassDatumAnalysis = edge.getSource().getClassDatumAnalysis();
            break;
        }
        CompleteEnvironment completeEnvironment = scheduler.getEnvironmentFactory().getCompleteEnvironment();
        ClassDatumAnalysis consumedClassDatumAnalysis = consumerNode.getClassDatumAnalysis();
        Class elementType = consumedClassDatumAnalysis.getCompleteClass().getPrimaryClass();
        TypedModel typedModel = consumedClassDatumAnalysis.getTypedModel();
        CollectionType childCollectionType = completeEnvironment.getSetType((Type)elementType, true, null, null);
        ClassDatumAnalysis childrenClassDatumAnalysis = scheduler.getClassDatumAnalysis((Class)childCollectionType, typedModel);
        if (parent2childProperty == null) {
            Map<@Nullable ClassDatumAnalysis, @NonNull SimpleNode> type2node = this.classDatumAnalysis2type2node.get(consumedClassDatumAnalysis);
            if (type2node == null) {
                type2node = new HashMap<ClassDatumAnalysis, SimpleNode>();
                this.classDatumAnalysis2type2node.put(consumedClassDatumAnalysis, type2node);
            }
            if ((introducedNode = type2node.get(null)) == null) {
                introducedNode = Nodes.COMPOSING.createSimpleNode((SimpleRegion)this, "\u00ab" + elementType.getName() + "\u00bb", childrenClassDatumAnalysis);
                type2node.put(null, introducedNode);
            }
        } else if (containerEdge != null && containerEdge.getTarget().isNull()) {
            Map<@Nullable Property, @NonNull SimpleNode> property2node = this.classDatumAnalysis2property2node.get(consumedClassDatumAnalysis);
            if (property2node == null) {
                property2node = new HashMap<Property, SimpleNode>();
                this.classDatumAnalysis2property2node.put(consumedClassDatumAnalysis, property2node);
            }
            if ((introducedNode = property2node.get(null)) == null) {
                introducedNode = Nodes.COMPOSING.createSimpleNode((SimpleRegion)this, "\u00ab" + elementType.getName() + "-null\u00bb", childrenClassDatumAnalysis);
                property2node.put(null, introducedNode);
                Edges.NAVIGABLE_NAVIGATION.createSimpleEdge(this, this.getNullNode(), parent2childProperty, introducedNode);
            }
        } else if (containingClassDatumAnalysis != null) {
            Map<@Nullable ClassDatumAnalysis, @NonNull SimpleNode> type2node = this.classDatumAnalysis2type2node.get(consumedClassDatumAnalysis);
            if (type2node == null) {
                type2node = new HashMap<ClassDatumAnalysis, SimpleNode>();
                this.classDatumAnalysis2type2node.put(consumedClassDatumAnalysis, type2node);
            }
            if ((introducedNode = type2node.get(containingClassDatumAnalysis)) == null) {
                introducedNode = Nodes.COMPOSING.createSimpleNode((SimpleRegion)this, "\u00ab" + elementType.getName() + "-oclContents\u00bb", childrenClassDatumAnalysis);
                type2node.put(containingClassDatumAnalysis, introducedNode);
                SimpleNode containerNode = Nodes.COMPOSING.createSimpleNode((SimpleRegion)this, "\u00ab" + containingClassDatumAnalysis.getCompleteClass().getName() + "-oclContainer\u00bb", containingClassDatumAnalysis);
                Edges.NAVIGABLE_NAVIGATION.createSimpleEdge(this, containerNode, parent2childProperty, introducedNode);
            }
        } else {
            Map<@Nullable Property, @NonNull SimpleNode> property2node = this.classDatumAnalysis2property2node.get(consumedClassDatumAnalysis);
            if (property2node == null) {
                property2node = new HashMap<Property, SimpleNode>();
                this.classDatumAnalysis2property2node.put(consumedClassDatumAnalysis, property2node);
            }
            if ((introducedNode = property2node.get(parent2childProperty)) == null) {
                introducedNode = Nodes.COMPOSING.createSimpleNode((SimpleRegion)this, "\u00ab" + elementType.getName() + "-" + parent2childProperty.getName() + "\u00bb", childrenClassDatumAnalysis);
                property2node.put(parent2childProperty, introducedNode);
                Class owningClass = parent2childProperty.getOwningClass();
                assert (owningClass != null);
                containingClassDatumAnalysis = scheduler.getClassDatumAnalysis(owningClass, typedModel);
                SimpleNode containerNode = Nodes.COMPOSING.createSimpleNode((SimpleRegion)this, "\u00ab" + owningClass.getName() + "-" + parent2childProperty.getName() + "\u00bb", containingClassDatumAnalysis);
                Edges.NAVIGABLE_NAVIGATION.createSimpleEdge(this, containerNode, parent2childProperty, introducedNode);
            }
        }
        return introducedNode;
    }

    @Override
    public @NonNull String getName() {
        return "__root__";
    }

    @Override
    public @NonNull List<@NonNull Node> getHeadNodes() {
        return SchedulerConstants.EMPTY_NODE_LIST;
    }

    private @NonNull SimpleNode getNullNode() {
        SimpleNode nullNode2 = this.nullNode;
        if (nullNode2 == null) {
            this.nullNode = nullNode2 = Nodes.NULL.createSimpleNode(this);
        }
        return nullNode2;
    }

    @Override
    public boolean isLateMergeable(@NonNull Region innerRegion, @NonNull Region2Depth region2depths) {
        return false;
    }

    @Override
    public boolean isRootCompositionRegion() {
        return true;
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.setLabel(this.getName());
        s.setColor("lightblue");
        s.setPenwidth(Role.LINE_WIDTH);
        s.pushCluster();
        for (Node node : this.getNodes()) {
            s.appendNode((GraphStringBuilder.GraphNode)node);
        }
        for (Edge edge : this.getEdges()) {
            s.appendEdge((GraphStringBuilder.GraphNode)edge.getSource(), (GraphStringBuilder.GraphEdge)edge, (GraphStringBuilder.GraphNode)edge.getTarget());
        }
        s.popCluster();
    }
}

