/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassRelationships;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.AbstractMapping;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.schedule.AbstractDatum;
import org.eclipse.qvtd.pivot.schedule.ClassDatum;
import org.eclipse.qvtd.pivot.schedule.DataParameter;
import org.eclipse.qvtd.pivot.schedule.MappingAction;
import org.eclipse.qvtd.pivot.schedule.PropertyDatum;
import org.eclipse.qvtd.pivot.schedule.Schedule;
import org.eclipse.qvtd.pivot.schedule.ScheduleFactory;

public class QVTp2QVTg {
    private final @NonNull Schedule dg = ScheduleFactory.eINSTANCE.createSchedule();
    private Map<@NonNull TypedModel, Map<Class, ClassDatum>> typedModel2class2datum = new HashMap<TypedModel, Map<Class, ClassDatum>>();
    private Map<AbstractMapping, List<OperationCallExp>> mapping2opCallExps = new HashMap<AbstractMapping, List<OperationCallExp>>();
    private Map<AbstractMapping, List<@NonNull NavigationAssignment>> mapping2propAssigns = new HashMap<AbstractMapping, List<NavigationAssignment>>();
    private Map<AbstractMapping, List<NavigationCallExp>> mapping2navCallExps = new HashMap<AbstractMapping, List<NavigationCallExp>>();
    private final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    private final @NonNull ClassRelationships classRelationships;

    public static @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatums(@NonNull ClassDatum cDatum) {
        return QVTp2QVTg.getAllPropertyDatumsInternal(new HashSet<ClassDatum>(), new HashSet<PropertyDatum>(), cDatum);
    }

    private static @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatumsInternal(@NonNull Set<@NonNull ClassDatum> classDatums, @NonNull Set<@NonNull PropertyDatum> propertyDatums, @NonNull ClassDatum cDatum) {
        if (classDatums.add(cDatum)) {
            propertyDatums.addAll((Collection<PropertyDatum>)ClassUtil.nullFree((EList)cDatum.getPropertyDatums()));
        }
        for (AbstractDatum superClassDatum : ClassUtil.nullFree((EList)cDatum.getSuper())) {
            if (!(superClassDatum instanceof ClassDatum)) continue;
            QVTp2QVTg.getAllPropertyDatumsInternal(classDatums, propertyDatums, (ClassDatum)superClassDatum);
        }
        return propertyDatums;
    }

    public QVTp2QVTg(@NonNull RootDomainUsageAnalysis domainAnalysis, @NonNull ClassRelationships classRelationships) {
        this.domainUsageAnalysis = domainAnalysis;
        this.classRelationships = classRelationships;
    }

    private boolean assertValidTypedModel(@NonNull TypedModel typedModel, @NonNull Type aType) {
        Type elementType = QVTbaseUtil.getElementalType((Type)aType);
        if (elementType instanceof DataType ? !$assertionsDisabled && typedModel != this.domainUsageAnalysis.getPrimitiveTypeModel() : !$assertionsDisabled && typedModel == null) {
            throw new AssertionError();
        }
        return true;
    }

    private void clearCaches() {
        this.typedModel2class2datum.clear();
        this.mapping2opCallExps.clear();
        this.mapping2propAssigns.clear();
        this.mapping2navCallExps.clear();
    }

    private void computeInitialCaches(Transformation tx) {
        for (Rule rule : tx.getRule()) {
            AbstractMapping mapping = (AbstractMapping)rule;
            TreeIterator it = mapping.eAllContents();
            while (it.hasNext()) {
                EObject eObj = (EObject)it.next();
                if (eObj instanceof OperationCallExp) {
                    List<OperationCallExp> opCallExps = this.mapping2opCallExps.get(mapping);
                    if (opCallExps == null) {
                        opCallExps = new ArrayList<OperationCallExp>();
                        this.mapping2opCallExps.put(mapping, opCallExps);
                    }
                    opCallExps.add((OperationCallExp)eObj);
                    continue;
                }
                if (eObj instanceof NavigationAssignment) {
                    List<NavigationAssignment> propAssigns = this.mapping2propAssigns.get(mapping);
                    if (propAssigns == null) {
                        propAssigns = new ArrayList<NavigationAssignment>();
                        this.mapping2propAssigns.put(mapping, propAssigns);
                    }
                    propAssigns.add((NavigationAssignment)eObj);
                    continue;
                }
                if (!(eObj instanceof NavigationCallExp)) continue;
                List<NavigationCallExp> navCallExps = this.mapping2navCallExps.get(mapping);
                if (navCallExps == null) {
                    navCallExps = new ArrayList<NavigationCallExp>();
                    this.mapping2navCallExps.put(mapping, navCallExps);
                }
                navCallExps.add((NavigationCallExp)eObj);
            }
        }
    }

    public void run(@NonNull Resource qvtpModel, @NonNull Resource qvtsModel) {
        this.clearCaches();
        for (EObject eObject : qvtpModel.getContents()) {
            if (!(eObject instanceof BaseModel)) continue;
            this.transformPackages(((BaseModel)eObject).getOwnedPackages());
        }
        qvtsModel.getContents().clear();
        qvtsModel.getContents().add((Object)this.dg);
    }

    protected void transformPackages(@NonNull List<Package> pPackages) {
        for (Package pPackage : pPackages) {
            for (Class pClass : pPackage.getOwnedClasses()) {
                if (!(pClass instanceof Transformation)) continue;
                this.transformTransformation((Transformation)pClass);
            }
            this.transformPackages(pPackage.getOwnedPackages());
        }
    }

    protected void transformTransformation(@NonNull Transformation pTransformation) {
        this.computeInitialCaches(pTransformation);
        for (Rule pRule : pTransformation.getRule()) {
            this.createMappingAction((AbstractMapping)pRule);
        }
    }

    protected MappingAction createMappingAction(AbstractMapping mapping) {
        TypedModel typedModel;
        MappingAction ma = ScheduleFactory.eINSTANCE.createMappingAction();
        ma.setSchedule(this.dg);
        ma.setMapping(mapping);
        for (Variable inputVar : this.getInputVariables(mapping)) {
            typedModel = this.getTypedModel((Element)inputVar);
            ma.getParameters().add((Object)this.createDataParameter(inputVar));
            ma.getRequisites().add((Object)this.getClassDatum(typedModel, (Class)ClassUtil.nonNullState((Object)((Class)inputVar.getType()))));
        }
        for (RealizedVariable outputVar : this.getOutputVariables(mapping)) {
            typedModel = this.getTypedModel((Element)outputVar);
            ma.getResults().add((Object)this.createDataParameter((Variable)outputVar));
            ma.getProductions().add((Object)this.getClassDatum(typedModel, (Class)ClassUtil.nonNullState((Object)((Class)outputVar.getType()))));
        }
        for (NavigationCallExp propRead : this.getPropertyNavigations(mapping)) {
            ma.getRequisites().add((Object)this.getPropertyDatum(propRead));
        }
        for (NavigationAssignment propWrite : this.getNavigationAssignments(mapping)) {
            ma.getProductions().addAll(this.getPropertyDatum(propWrite));
        }
        for (OperationCallExp opCall : this.getOperationCallExps(mapping)) {
            Class context = this.getContextType((CallExp)opCall);
            ma.getRequisites().addAll(this.getPropertyDatums(opCall, context, new HashMap<Class, Set<Operation>>(), new HashMap<Variable, Set<Class>>()));
        }
        return ma;
    }

    protected DataParameter createDataParameter(@NonNull Variable variable) {
        TypedModel typedModel = this.getTypedModel((Element)variable);
        DataParameter dp = ScheduleFactory.eINSTANCE.createDataParameter();
        dp.setVariable(variable);
        dp.setDatum((AbstractDatum)this.getClassDatum(typedModel, (Class)ClassUtil.nonNullState((Object)((Class)variable.getType()))));
        return dp;
    }

    protected @NonNull ClassDatum createClassDatum(@NonNull TypedModel typedModel, @NonNull Class aClass) {
        assert (this.assertValidTypedModel(typedModel, (Type)aClass));
        ClassDatum cDatum = ScheduleFactory.eINSTANCE.createClassDatum();
        cDatum.setSchedule(this.dg);
        cDatum.setType(aClass);
        cDatum.setTypedModel(typedModel);
        if (!(aClass instanceof DataType)) {
            for (Class superClass : aClass.getSuperClasses()) {
                ClassDatum superCDatum = this.getClassDatum(typedModel, superClass);
                cDatum.getSuper().add((Object)superCDatum);
            }
        }
        return cDatum;
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull Class aClass) {
        ClassDatum cDatum;
        assert (this.assertValidTypedModel(typedModel, (Type)aClass));
        Map<Class, ClassDatum> class2datum = this.typedModel2class2datum.get(typedModel);
        if (class2datum == null) {
            class2datum = new HashMap<Class, ClassDatum>();
            this.typedModel2class2datum.put(typedModel, class2datum);
        }
        if ((cDatum = class2datum.get(aClass)) == null) {
            cDatum = this.createClassDatum(typedModel, aClass);
            class2datum.put(aClass, cDatum);
        }
        return cDatum;
    }

    public @NonNull ClassRelationships getClassRelationships() {
        return this.classRelationships;
    }

    protected @NonNull PropertyDatum createPropertyDatum(@NonNull TypedModel typedModel, @NonNull Class context, Property property) {
        PropertyDatum pDatum = ScheduleFactory.eINSTANCE.createPropertyDatum();
        ClassDatum classDatum = this.getClassDatum(typedModel, context);
        pDatum.setTypedModel(classDatum.getTypedModel());
        pDatum.setProperty(property);
        pDatum.setClassDatum(classDatum);
        if (context != property.getOwningClass()) {
            for (Class superClass : context.getSuperClasses()) {
                PropertyDatum superPropDatum = this.getPropertyDatum(typedModel, superClass, property);
                pDatum.getSuper().add((Object)superPropDatum);
            }
        }
        return pDatum;
    }

    protected @NonNull PropertyDatum getPropertyDatum(@NonNull TypedModel typedModel, @NonNull Class context, Property property) {
        ClassDatum cDatum = this.getClassDatum(typedModel, context);
        for (PropertyDatum pDatum : QVTp2QVTg.getAllPropertyDatums(cDatum)) {
            if (!pDatum.getProperty().equals(property)) continue;
            return pDatum;
        }
        return this.createPropertyDatum(typedModel, context, property);
    }

    protected List<Variable> getInputVariables(AbstractMapping mapping) {
        ArrayList<Variable> mInputVars = new ArrayList<Variable>();
        mInputVars.addAll((Collection<Variable>)mapping.getGuardPattern().getVariable());
        for (Domain domain : mapping.getDomain()) {
            CoreDomain cDomain = (CoreDomain)domain;
            mInputVars.addAll((Collection<Variable>)cDomain.getGuardPattern().getVariable());
        }
        return mInputVars;
    }

    protected List<RealizedVariable> getOutputVariables(AbstractMapping mapping) {
        ArrayList<RealizedVariable> mOutputVars = new ArrayList<RealizedVariable>();
        mOutputVars.addAll((Collection<RealizedVariable>)mapping.getBottomPattern().getRealizedVariable());
        for (Domain domain : mapping.getDomain()) {
            CoreDomain cDomain = (CoreDomain)domain;
            mOutputVars.addAll((Collection<RealizedVariable>)cDomain.getBottomPattern().getRealizedVariable());
        }
        return mOutputVars;
    }

    protected List<NavigationCallExp> getPropertyNavigations(AbstractMapping mapping) {
        List<NavigationCallExp> navCallExps = this.mapping2navCallExps.get(mapping);
        return navCallExps == null ? Collections.emptyList() : navCallExps;
    }

    protected List<@NonNull NavigationAssignment> getNavigationAssignments(AbstractMapping mapping) {
        List<@NonNull NavigationAssignment> propAssigns = this.mapping2propAssigns.get(mapping);
        return propAssigns == null ? Collections.emptyList() : propAssigns;
    }

    protected List<OperationCallExp> getOperationCallExps(AbstractMapping mapping) {
        List<OperationCallExp> opCallExps = this.mapping2opCallExps.get(mapping);
        return opCallExps == null ? Collections.emptyList() : opCallExps;
    }

    protected @NonNull PropertyDatum getPropertyDatum(NavigationCallExp navCallExp) {
        Class context = (Class)ClassUtil.nonNullState((Object)((Class)navCallExp.getOwnedSource().getType()));
        return this.getPropertyDatum(navCallExp, context);
    }

    protected @NonNull PropertyDatum getPropertyDatum(@NonNull NavigationCallExp navCallExp, @NonNull Class context) {
        Property property = PivotUtil.getReferredProperty((NavigationCallExp)navCallExp);
        OCLExpression ownedSource = navCallExp.getOwnedSource();
        assert (ownedSource != null);
        TypedModel typedModel = this.getTypedModel((Element)ownedSource);
        return this.getPropertyDatum(typedModel, context, property);
    }

    protected @NonNull Set<PropertyDatum> getPropertyDatum(@NonNull NavigationAssignment propAssign) {
        LinkedHashSet<PropertyDatum> result = new LinkedHashSet<PropertyDatum>();
        Property targetProp = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)propAssign);
        OCLExpression slotExpression = (OCLExpression)ClassUtil.nonNullState((Object)propAssign.getSlotExpression());
        TypedModel typedModel = this.getTypedModel((Element)slotExpression);
        PropertyDatum targetDatum = this.getPropertyDatum(typedModel, (Class)ClassUtil.nonNullState((Object)slotExpression.getType().isClass()), targetProp);
        result.add(targetDatum);
        Property oppositeProp = targetProp.getOpposite();
        if (oppositeProp != null) {
            TypedModel oppositeTypedModel;
            OCLExpression value = propAssign.getValue();
            assert (value != null);
            DomainUsage valueUsage = this.getUsage((Element)value);
            if (valueUsage == null) {
                this.getUsage((Element)value);
                throw new IllegalStateException("No DomainUsage for " + value);
            }
            Type propertyType = targetProp.getType();
            if (propertyType != null && propertyType.getESObject() != EcorePackage.Literals.EOBJECT) {
                DomainUsage propertyUsage = this.getUsage((Element)propertyType);
                if (propertyUsage == null) {
                    this.getUsage((Element)propertyType);
                    throw new IllegalStateException("No DomainUsage for " + propertyType);
                }
                valueUsage = this.domainUsageAnalysis.intersection(propertyUsage, valueUsage);
            }
            if ((oppositeTypedModel = valueUsage.getTypedModel((Element)propAssign)) == null) {
                throw new IllegalStateException("No left/right DomainUsage commonality for \"" + propAssign + "\"");
            }
            PropertyDatum oppositeDatum = this.getPropertyDatum(oppositeTypedModel, (Class)ClassUtil.nonNullState((Object)this.getElementClass((TypedElement)targetProp)), oppositeProp);
            targetDatum.setOpposite(oppositeDatum);
            result.add(oppositeDatum);
        }
        return result;
    }

    private @NonNull Set<PropertyDatum> getPropertyDatums(OperationCallExp opCall, Class context, Map<Class, Set<Operation>> type2VisitedOps, Map<Variable, Set<Class>> variable2BoundContext) {
        Set<Operation> visitedOps = type2VisitedOps.get(context);
        if (visitedOps == null) {
            visitedOps = new HashSet<Operation>();
            type2VisitedOps.put(context, visitedOps);
        }
        LinkedHashSet<PropertyDatum> result = new LinkedHashSet<PropertyDatum>();
        Operation op = (Operation)ClassUtil.nonNullState((Object)opCall.getReferredOperation());
        if (!visitedOps.contains(op)) {
            visitedOps.add(op);
            if (this.isOclContainerOp(op)) {
                for (TypedModel typedModel : this.getTypedModels((Element)context)) {
                    for (Class newContext : this.getComputedContexts((CallExp)opCall, variable2BoundContext)) {
                        result.addAll(this.analyseOclContainerCall(typedModel, newContext));
                    }
                }
            } else {
                result.addAll(this.getPropertyDatums(op, context, type2VisitedOps));
            }
        }
        return result;
    }

    private @NonNull Set<PropertyDatum> getPropertyDatums(Operation op, Class context, Map<Class, Set<Operation>> type2VisitedOps) {
        ExpressionInOCL expInOCL;
        LinkedHashSet<PropertyDatum> result = new LinkedHashSet<PropertyDatum>();
        LanguageExpression langExp = op.getBodyExpression();
        if (langExp instanceof ExpressionInOCL && (expInOCL = (ExpressionInOCL)langExp).getOwnedBody() != null) {
            HashMap<Variable, Set<Class>> variable2BoundContext = new HashMap<Variable, Set<Class>>();
            LinkedHashSet<Class> boundContexts = new LinkedHashSet<Class>();
            boundContexts.add(context);
            variable2BoundContext.put(expInOCL.getOwnedContext(), boundContexts);
            TreeIterator it = expInOCL.eAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (eObject instanceof LetExp) {
                    this.updateVariableBindings((LetExp)eObject, variable2BoundContext);
                    continue;
                }
                if (eObject instanceof NavigationCallExp) {
                    NavigationCallExp navCallExp = (NavigationCallExp)eObject;
                    for (Class newContext : this.getComputedContexts((CallExp)navCallExp, variable2BoundContext)) {
                        result.add(this.getPropertyDatum(navCallExp, newContext));
                    }
                    continue;
                }
                if (!(eObject instanceof OperationCallExp)) continue;
                OperationCallExp opCallExp = (OperationCallExp)eObject;
                for (Class newContext : this.getComputedContexts((CallExp)opCallExp, variable2BoundContext)) {
                    result.addAll(this.getPropertyDatums(opCallExp, newContext, type2VisitedOps, variable2BoundContext));
                }
            }
        }
        return result;
    }

    private @NonNull TypedModel getTypedModel(@NonNull Element element) {
        DomainUsage domainUsage = this.getUsage(element);
        if (domainUsage == null) {
            this.getUsage(element);
            throw new IllegalStateException("No DomainUsage for " + element);
        }
        Iterator<TypedModel> typedModels = this.getTypedModels(element).iterator();
        if (!typedModels.hasNext()) {
            throw new IllegalStateException("No TypedModel for " + element);
        }
        @NonNull TypedModel typedModel = typedModels.next();
        if (typedModels.hasNext()) {
            this.getUsage(element);
            throw new IllegalStateException("Ambiguous TypedModel: " + domainUsage + " for " + element);
        }
        return typedModel;
    }

    private @NonNull Iterable<TypedModel> getTypedModels(@NonNull Element element) {
        DomainUsage domainUsage = this.getUsage(element);
        if (domainUsage == null) {
            this.getUsage(element);
            throw new IllegalStateException("No DomainUsage for " + element);
        }
        return domainUsage.getTypedModels();
    }

    private @Nullable DomainUsage getUsage(@NonNull Element element) {
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            DomainUsageAnalysis analysis = this.domainUsageAnalysis.getAnalysis(operation);
            return analysis.getUsage(element);
        }
        return this.domainUsageAnalysis.getUsage(element);
    }

    private boolean isOclContainerOp(@NonNull Operation op) {
        return op.getOperationId() == this.domainUsageAnalysis.getOclContainerId();
    }

    private @NonNull Set<PropertyDatum> analyseOclContainerCall(@NonNull TypedModel typedModel, @NonNull Class context) {
        LinkedHashSet<PropertyDatum> result = new LinkedHashSet<PropertyDatum>();
        for (Class parentClass : this.getContainingTypes(context)) {
            for (Property prop : parentClass.getOwnedProperties()) {
                Set<Class> allSuperAndSubClasses;
                if (!prop.isIsComposite() || !(allSuperAndSubClasses = this.getAllSuperAndSubClassesIncludingSelf(context)).contains(this.getElementClass((TypedElement)prop))) continue;
                result.add(this.getPropertyDatum(typedModel, parentClass, prop));
            }
        }
        return result;
    }

    private void updateVariableBindings(LetExp letExp, Map<Variable, Set<Class>> variable2BoundContext) {
        Variable variable = letExp.getOwnedVariable();
        variable2BoundContext.put(variable, this.computeContexts(variable.getOwnedInit(), variable2BoundContext));
    }

    private Set<Class> computeContexts(OCLExpression oclExp, Map<Variable, Set<Class>> variable2BoundContext) {
        LinkedHashSet<Class> result = new LinkedHashSet<Class>();
        if (oclExp instanceof VariableExp) {
            VariableExp varExp = (VariableExp)oclExp;
            Set<Class> context = variable2BoundContext.get(varExp.getReferredVariable());
            if (context != null) {
                result.addAll(context);
            } else {
                result.add(varExp.getType().isClass());
            }
        } else if (oclExp instanceof CallExp) {
            CallExp callExp = (CallExp)oclExp;
            if (callExp instanceof OperationCallExp && this.isOclContainerOp((Operation)ClassUtil.nonNullState((Object)((OperationCallExp)callExp).getReferredOperation()))) {
                for (Class oclContainerOpContext : this.computeContexts(callExp.getOwnedSource(), variable2BoundContext)) {
                    result.addAll(this.getContainingTypes(oclContainerOpContext));
                }
            } else {
                result.add(callExp.getType().isClass());
            }
        } else if (oclExp instanceof ShadowExp) {
            result.add(((ShadowExp)oclExp).getType());
        } else {
            throw new IllegalStateException("OCLExpression has not been considered yet");
        }
        return result;
    }

    private Set<Class> getComputedContexts(CallExp callExp, Map<Variable, Set<Class>> variable2BoundContext) {
        OCLExpression source = callExp.getOwnedSource();
        return this.computeContexts(source, variable2BoundContext);
    }

    private @NonNull Set<Class> getContainingTypes(@NonNull Class aClass) {
        return this.classRelationships.getContainerClasses(aClass);
    }

    private Class getContextType(CallExp callExp) {
        OCLExpression ownedSource = callExp.getOwnedSource();
        if (ownedSource == null) {
            return null;
        }
        Type type = ownedSource.getType();
        if (type == null) {
            return null;
        }
        return type.isClass();
    }

    private @NonNull Set<Class> getAllSuperClasses(@NonNull Class context) {
        return this.classRelationships.getAllSuperClasses(context);
    }

    private @NonNull Set<Class> getAllSubClasses(@NonNull Class context) {
        return this.classRelationships.getAllSubClasses(context);
    }

    private Set<Class> getAllSuperAndSubClasses(@NonNull Class context) {
        LinkedHashSet<Class> result = new LinkedHashSet<Class>();
        result.addAll(this.getAllSuperClasses(context));
        result.addAll(this.getAllSubClasses(context));
        return result;
    }

    private Set<Class> getAllSuperAndSubClassesIncludingSelf(@NonNull Class context) {
        Set<Class> result = this.getAllSuperAndSubClasses(context);
        result.add(context);
        return result;
    }

    public @NonNull RootDomainUsageAnalysis getDomainUsageAnalysis() {
        return this.domainUsageAnalysis;
    }

    private Class getElementClass(TypedElement tElement) {
        Type type = tElement.getType();
        if (type instanceof CollectionType) {
            return ((CollectionType)type).getElementType().isClass();
        }
        return type.isClass();
    }
}

