/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QvtrToQvtcTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Rule;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RuleBindings;

public abstract class AbstractRule
implements Rule {
    @NonNull
    protected final QvtrToQvtcTransformation transformation;
    @NonNull
    protected final RuleBindings ruleBindings = new RuleBindings(this);
    protected boolean executed = false;

    protected AbstractRule(@NonNull QvtrToQvtcTransformation transformation) {
        this.transformation = transformation;
    }

    @Override
    public void check() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void instantiateOutput() {
    }

    @Override
    @NonNull
    public RuleBindings getRuleBindings() {
        return this.ruleBindings;
    }

    @Override
    @NonNull
    public RuleBindings.KeySet getRuleBindingsKeys() {
        return (RuleBindings.KeySet)((Object)this.ruleBindings.keySet());
    }

    @Override
    public boolean hasExecuted() {
        return this.executed;
    }

    @Override
    public void setAttributes() {
    }

    @Override
    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    @Override
    public boolean when() {
        return true;
    }

    @Override
    public void where() {
    }

    public abstract class AbstractSubRecord
    implements Rule.SubRecord {
        @NonNull
        protected final RuleBindings ruleBindings;

        protected AbstractSubRecord(Rule rule) {
            this.ruleBindings = new RuleBindings(rule);
        }

        @Override
        @NonNull
        public RuleBindings getRuleBindings() {
            return this.ruleBindings;
        }

        @Override
        @NonNull
        public RuleBindings.KeySet getRuleBindingsKeys() {
            return (RuleBindings.KeySet)((Object)this.ruleBindings.keySet());
        }
    }

    protected static abstract class Factory
    implements Rule.Factory {
        protected Factory() {
        }

        @Override
        @Nullable
        public abstract Rule createRule(@NonNull QvtrToQvtcTransformation var1, @NonNull EObject var2);

        @Override
        @Nullable
        public abstract Rule createRule(@NonNull QvtrToQvtcTransformation var1, @NonNull List<EObject> var2);

        @Override
        @NonNull
        public List<Rule> getRules(@NonNull QvtrToQvtcTransformation transformation, @NonNull Resource inputModel) {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            TreeIterator it = inputModel.getAllContents();
            while (it.hasNext()) {
                Rule rule;
                EObject eo = (EObject)it.next();
                if (eo == null || (rule = this.createRule(transformation, eo)) == null) continue;
                rules.add(rule);
            }
            return rules;
        }
    }
}

