/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.environment;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import lpg.runtime.Monitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.examples.modelregistry.environment.AbstractModelResolver;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.qvt.declarative.ecore.utils.XMIUtils;
import org.eclipse.qvt.declarative.parser.environment.CSTEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileAnalyzer;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTNodeEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTRootEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.environment.LPGProgressMonitor;
import org.eclipse.qvt.declarative.parser.utils.CSTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTFileEnvironment<R extends ICSTRootEnvironment, E extends ICSTNodeEnvironment, CST extends CSTNode>
extends CSTEnvironment<E>
implements ICSTFileEnvironment {
    protected final EPackage.Registry registryToo;
    protected final XMIResource ast;
    protected final AbstractModelResolver resolver;
    private TypeResolver<EClassifier, EOperation, EStructuralFeature> typeResolver;

    private CSTFileEnvironment(EPackage.Registry registry, FileHandle file, ResourceSet resourceSet, XMIResource astResource) {
        super(registry, null);
        this.ast = astResource;
        this.typeResolver = this.createTypeResolver((Resource)this.ast);
        this.registryToo = registry;
        if (file != null) {
            this.resolver = new AbstractModelResolver(file);
            this.resolver.setResourceSet(resourceSet);
        } else {
            this.resolver = null;
        }
    }

    protected CSTFileEnvironment(FileHandle file, ResourceSet resourceSet, XMIResource astResource) {
        this((EPackage.Registry)new EPackageRegistryImpl(), file, resourceSet, astResource);
    }

    public abstract ICSTFileAnalyzer<R> createAnalyzer(Monitor var1);

    protected abstract R createRootEnvironment(XMIResource var1, CST var2);

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver(Resource resource) {
        return resource != null ? super.createTypeResolver(resource) : null;
    }

    @Override
    public XMIResource getASTResource() {
        return this.ast;
    }

    protected abstract String getContentTypeIdentifier();

    @Override
    public FileHandle getFile() {
        return this.getResolver().getHandle();
    }

    @Override
    public ICSTFileEnvironment getFileEnvironment() {
        return this;
    }

    @Override
    public EPackage.Registry getRegistry() {
        return this.registryToo;
    }

    @Override
    public AbstractModelResolver getResolver() {
        return this.resolver;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resolver.getResourceSet();
    }

    public TypeResolver<EClassifier, EOperation, EStructuralFeature> getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public void initializePackageNs(EPackage ePackage) {
        ePackage.setNsPrefix(ePackage.getName());
        ePackage.setNsURI(CSTUtils.computePackageNs(this.resolver.getHandle(), ePackage));
    }

    @Override
    public ICSTRootEnvironment parse(Reader reader, FileHandle file, IProgressMonitor monitor) throws IOException, CoreException {
        R rootEnvironment;
        LPGProgressMonitor lpgMonitor = new LPGProgressMonitor(monitor);
        ICSTFileAnalyzer<R> analyzer = this.createAnalyzer(lpgMonitor);
        if (reader == null) {
            reader = new InputStreamReader(file.getContents());
        } else if (!file.exists()) {
            return null;
        }
        analyzer.reset(reader, file.getName());
        AbstractParser parser = this.getParser();
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        parser.getLexer().lexer(parser.getIPrsStream());
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        CSTNode cst = parser.parser((Monitor)lpgMonitor, -1);
        if (cst == null) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        try {
            this.reset();
            rootEnvironment = this.createRootEnvironment(this.ast, cst);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (!analyzer.analyze(rootEnvironment)) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        this.postParse(rootEnvironment);
        return rootEnvironment;
    }

    protected void postParse(R rootEnvironment) {
        rootEnvironment.postParse();
        XMIUtils.assignLinearIds((Resource)this.ast, (String)"ast");
    }

    public void reset() {
        this.ast.unload();
        this.typeResolver = this.createTypeResolver((Resource)this.ast);
        EList eAdapters = this.ast.eAdapters();
        if (!eAdapters.isEmpty()) {
            for (Adapter eAdapter : new ArrayList(eAdapters)) {
                if (!(eAdapter instanceof ICSTEnvironment)) continue;
                eAdapters.remove(eAdapter);
            }
        }
    }
}

