/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.qvt.declarative.ecore.adapters.AdapterNotFoundException;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingEObject;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingInternalEList;
import org.eclipse.qvt.declarative.ecore.adapters.NotAdapterException;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.MappingUtils;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptingXMIResource
extends XMIResourceImpl
implements Adapter {
    protected final Resource target;
    protected final IMappingMetaDataRegistry mappingMetaDataRegistry;
    protected boolean hasDistinctIDs = false;
    protected boolean loadInProgress = false;
    protected boolean saveInProgress = false;

    public static AdaptingXMIResource findAdapter(Resource resource) {
        for (Adapter eAdapter : resource.eAdapters()) {
            if (!(eAdapter instanceof AdaptingXMIResource)) continue;
            return (AdaptingXMIResource)eAdapter;
        }
        return null;
    }

    public static boolean isLoading(EObject ecoreObject) {
        Resource resource = ecoreObject.eResource();
        if (resource != null && resource.isLoaded()) {
            for (Adapter eAdapter : resource.eAdapters()) {
                if (!(eAdapter instanceof AdaptingXMIResource) || !((AdaptingXMIResource)eAdapter).isLoading()) continue;
                return true;
            }
        }
        return false;
    }

    public AdaptingXMIResource(Resource target, URI uri, IMappingMetaDataRegistry mappingMetaDataRegistry) {
        super(uri);
        this.target = target;
        this.mappingMetaDataRegistry = mappingMetaDataRegistry;
        Boolean useDeprecatedLoadMethods = Boolean.TRUE;
        this.setEncoding("UTF-8");
        this.getDefaultLoadOptions().put("EXTENDED_META_DATA", mappingMetaDataRegistry);
        this.getDefaultLoadOptions().put("USE_DEPRECATED_METHODS", useDeprecatedLoadMethods);
        this.getDefaultSaveOptions().put("USE_XMI_TYPE", Boolean.TRUE);
        this.getDefaultSaveOptions().put("LINE_WIDTH", new Integer(80));
    }

    protected XMLHelper createXMLHelper() {
        return new XMIHelperImpl((XMLResource)this){

            public EObject createObject(EFactory factory, EClassifier type) {
                MappingMetaData mappingMetaData = AdaptingXMIResource.this.mappingMetaDataRegistry.getMappingMetaData((EClass)type);
                if (mappingMetaData != null) {
                    factory = AdaptingXMIResource.this.mappingMetaDataRegistry.getMappingMetaDataFactory(mappingMetaData);
                }
                return super.createObject(factory, type);
            }

            public EClassifier getType(EFactory factory, String typeName) {
                EClassifier eClassifier = super.getType(factory, typeName);
                if (eClassifier == null && factory instanceof IMappingMetaData.Factory) {
                    List<IMappingMetaData> merges = ((IMappingMetaData.Factory)factory).getMappingMetaData().getMerges();
                    for (IMappingMetaData merge : merges) {
                        EPackage ePackage = merge.getAdaptingEPackage();
                        eClassifier = AdaptingXMIResource.this.getMappingMetaDataRegistry().getType(ePackage, typeName);
                        if (eClassifier == null) continue;
                        return eClassifier;
                    }
                }
                return eClassifier;
            }

            public Object getValue(EObject obj, EStructuralFeature f) {
                Object value = super.getValue(obj, f);
                if (value instanceof AdaptingInternalEList) {
                    boolean hasXmiExtension = false;
                    for (Object v : ((AdaptingInternalEList)value).basicList()) {
                        if (!((AdaptingEObject)v).isXmiExtension()) continue;
                        hasXmiExtension = true;
                        break;
                    }
                    if (hasXmiExtension) {
                        BasicInternalEList newList = new BasicInternalEList(EObject.class);
                        for (Object v : ((AdaptingInternalEList)value).basicList()) {
                            if (((AdaptingEObject)v).isXmiExtension()) continue;
                            newList.add(v);
                        }
                        value = newList;
                    }
                }
                return value;
            }
        };
    }

    protected XMLLoad createXMLLoad() {
        return new XMILoadImpl(this.createXMLHelper()){

            protected DefaultHandler makeDefaultHandler() {
                return new SAXXMIHandler(this.resource, this.helper, this.options){

                    protected void processElement(String name, String prefix, String localName) {
                        try {
                            super.processElement(name, prefix, localName);
                        }
                        catch (NotAdapterException e) {
                            this.error(new AdapterNotFoundException(e.getMessage(), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                        }
                    }
                };
            }
        };
    }

    protected XMLSave createXMLSave() {
        return new XMISaveImpl(this.createXMLHelper()){

            protected Object writeTopObject(EObject top) {
                return super.writeTopObjects(AdaptingXMIResource.this.getContents());
            }
        };
    }

    public void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        assert (!this.loadInProgress && !this.saveInProgress);
        this.loadInProgress = true;
        try {
            this.preLoad();
            super.doLoad(inputSource, options);
            this.postLoad();
        }
        finally {
            this.loadInProgress = false;
        }
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        assert (!this.loadInProgress && !this.saveInProgress);
        this.loadInProgress = true;
        try {
            this.preLoad();
            super.doLoad(inputStream, options);
            this.postLoad();
        }
        finally {
            this.loadInProgress = false;
        }
    }

    public void doLoad(Node node, Map<?, ?> options) throws IOException {
        assert (!this.loadInProgress && !this.saveInProgress);
        this.loadInProgress = true;
        try {
            this.preLoad();
            super.doLoad(node, options);
            this.postLoad();
        }
        finally {
            this.loadInProgress = false;
        }
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        assert (!this.loadInProgress && !this.saveInProgress);
        this.saveInProgress = true;
        try {
            this.preSave();
            super.doSave(outputStream, options);
            this.postSave();
        }
        finally {
            this.saveInProgress = false;
        }
    }

    public void doSave(Writer writer, Map<?, ?> options) throws IOException {
        assert (!this.loadInProgress && !this.saveInProgress);
        this.saveInProgress = true;
        try {
            this.preSave();
            super.doSave(writer, options);
            this.postSave();
        }
        finally {
            this.saveInProgress = false;
        }
    }

    protected List<EObject> getAllTargetContents() {
        ArrayList<EObject> allContents = new ArrayList<EObject>(1024);
        TreeIterator iterator = this.target.getAllContents();
        while (iterator.hasNext()) {
            allContents.add((EObject)iterator.next());
        }
        return allContents;
    }

    public EList<EObject> getContents() {
        return this.mappingMetaDataRegistry.getAdapters(this.target.getContents());
    }

    public EObject getEObject(String uriFragment) {
        if (this.hasDistinctIDs) {
            return super.getEObject(uriFragment);
        }
        EObject eObject = null;
        if (this.target instanceof XMIResourceImpl) {
            eObject = (EObject)((XMIResourceImpl)this.target).getIDToEObjectMap().get(uriFragment);
        }
        if (eObject == null) {
            eObject = this.target.getEObject(uriFragment);
        }
        if (eObject == null) {
            return null;
        }
        return this.loadInProgress || this.saveInProgress ? this.mappingMetaDataRegistry.getAdapter(eObject) : eObject;
    }

    @Deprecated
    public Map<EObject, String> getEObjectToIDMap() {
        if (this.hasDistinctIDs) {
            return super.getEObjectToIDMap();
        }
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getEObjectToIDMap");
    }

    public String getID(EObject object) {
        if (this.hasDistinctIDs || !(this.target instanceof XMLResource)) {
            return super.getID(object);
        }
        return object instanceof Adapter ? ((XMLResource)this.target).getID((EObject)((Adapter)object).getTarget()) : null;
    }

    @Deprecated
    public Map<String, EObject> getIDToEObjectMap() {
        if (this.hasDistinctIDs) {
            return super.getIDToEObjectMap();
        }
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getIDToEObjectMap");
    }

    public IMappingMetaDataRegistry getMappingMetaDataRegistry() {
        return this.mappingMetaDataRegistry;
    }

    public ResourceSet getResourceSet() {
        return this.getTarget().getResourceSet();
    }

    public Resource getTarget() {
        return this.target;
    }

    public URI getURI() {
        URI uri = super.getURI();
        return uri != null ? uri : this.target.getURI();
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(((Object)((Object)this)).getClass());
    }

    public void notifyChanged(Notification notification) {
    }

    protected void postLoad() {
        List<EObject> allTargets = this.getAllTargetContents();
        for (EObject aTarget : allTargets) {
            this.mappingMetaDataRegistry.postLoad(aTarget);
        }
        if (this.eObjectToExtensionMap != null) {
            this.eObjectToExtensionMap.clear();
        }
    }

    protected void postSave() {
        List<EObject> allTargets = this.getAllTargetContents();
        for (EObject aTarget : allTargets) {
            this.mappingMetaDataRegistry.postSave(aTarget);
        }
        if (this.eObjectToExtensionMap != null) {
            this.eObjectToExtensionMap.clear();
        }
    }

    protected void preLoad() {
        List<EObject> allTargets = this.getAllTargetContents();
        for (EObject aTarget : allTargets) {
            this.mappingMetaDataRegistry.preLoad(aTarget);
        }
        if (this.eObjectToExtensionMap != null) {
            this.eObjectToExtensionMap.clear();
        }
    }

    protected void preSave() {
        if (this.eObjectToExtensionMap != null) {
            this.getEObjectToExtensionMap().clear();
        }
        List<EObject> allTargets = this.getAllTargetContents();
        for (EObject aTarget : allTargets) {
            this.mappingMetaDataRegistry.preSave(aTarget);
        }
    }

    public void setID(EObject object, String id) {
        if (this.hasDistinctIDs || !(this.target instanceof XMLResource)) {
            super.setID(object, id);
        } else if (object instanceof Adapter) {
            ((XMLResource)this.target).setID((EObject)((Adapter)object).getTarget(), id);
        }
    }

    public void setTarget(Notifier newTarget) {
        if (this.target != newTarget) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".setTarget");
        }
    }

    public String toString() {
        return "Adapter(" + MappingUtils.formatLocalName(this.target) + ")";
    }
}

