/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.standalone.ProjectHandle;

public class FileHandle
extends PlatformObject
implements AbstractFileHandle {
    protected final ProjectHandle projectHandle;
    protected final File file;

    public static String createCanonicalFileName(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return file.getCanonicalPath();
    }

    protected FileHandle(File projectFile) throws IOException {
        this.projectHandle = (ProjectHandle)this;
        this.file = projectFile != null ? new File(FileHandle.createCanonicalFileName(projectFile)) : null;
    }

    public FileHandle(ProjectHandle projectHandle, File file) throws IOException {
        this.projectHandle = projectHandle;
        this.file = file != null ? new File(FileHandle.createCanonicalFileName(file)) : null;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getAbsoluteName() {
        return this.file.getAbsolutePath();
    }

    public InputStream getContents() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public FileHandle getParentFileHandle() {
        String parent = this.file.getParent();
        File file = parent != null ? new File(parent) : null;
        try {
            return file != null ? this.projectHandle.getFileHandle(file) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public AbstractProjectHandle getProjectHandle() {
        return this.projectHandle;
    }

    public String getProjectRelativeName() {
        return this.getProjectRelativePath().toString();
    }

    public IPath getProjectRelativePath() {
        Path filePath = new Path(this.getAbsoluteName());
        Path projectPath = new Path(this.getProjectHandle().getAbsoluteName());
        int matchingSegements = filePath.matchingFirstSegments((IPath)projectPath);
        return filePath.removeFirstSegments(matchingSegements).setDevice(null);
    }

    public URI getURI() {
        return URI.createFileURI((String)this.getFile().toString());
    }

    public File isFile() {
        return this.file.isFile() ? this.file : null;
    }

    public File isFolder() {
        return this.file.isDirectory() ? this.file : null;
    }

    public File isProject() {
        return this.projectHandle == this ? this.file : null;
    }

    public String toString() {
        return this.getAbsoluteName();
    }
}

