/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.model;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.model.Accessor;
import org.eclipse.qvt.declarative.modelregistry.model.AccessorRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.ModelSerialization;
import org.eclipse.qvt.declarative.modelregistry.model.ProjectRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.Registration;
import org.eclipse.qvt.declarative.modelregistry.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandleRegistry
implements Comparable<FileHandleRegistry> {
    private final ProjectRegistry parent;
    private final AbstractFileHandle fileHandle;
    private final AccessorClassToAccessorRegistryMap map = new AccessorClassToAccessorRegistryMap();

    public FileHandleRegistry(ProjectRegistry parent, AbstractFileHandle fileHandle) {
        this.parent = parent;
        this.fileHandle = fileHandle;
    }

    public <A extends Accessor> void add(A accessor, URI ecoreURI, ModelSerialization modelSerialisation) {
        AccessorRegistry<A> registry = this.getOrCreate(ClassUtils.getClass(accessor));
        registry.add(accessor, ecoreURI, modelSerialisation);
    }

    public <A extends Accessor> Registration<A> add(Registration<A> registration) {
        Class<A> accessorClass = registration.getAccessorClass();
        AccessorRegistry<A> registry = this.getOrCreate(accessorClass);
        return registry.add(registration);
    }

    @Override
    public int compareTo(FileHandleRegistry fileHandleRegistry) {
        String name1 = this.getFileHandle().getProjectRelativeName();
        if (name1 == null) {
            return -1;
        }
        String name2 = fileHandleRegistry.getFileHandle().getProjectRelativeName();
        if (name2 == null) {
            return 1;
        }
        Path path1 = new Path(name1);
        Path path2 = new Path(name2);
        int segmentCount1 = path1.segmentCount();
        int segmentCount2 = path2.segmentCount();
        int segmentCount = Math.min(segmentCount1, segmentCount2);
        int i = 0;
        while (i < segmentCount) {
            int comparison = path1.segment(i).compareTo(path2.segment(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        return segmentCount1 - segmentCount2;
    }

    public <A extends Accessor> AccessorRegistry<A> get(Class<A> accessorClass) {
        return this.map.get(accessorClass);
    }

    public <A extends Accessor> AccessorRegistry<A> getOrCreate(Class<A> accessorClass) {
        AccessorRegistry<A> accessorRegistry = this.map.get(accessorClass);
        if (accessorRegistry == null) {
            accessorRegistry = new AccessorRegistry<A>(this, accessorClass);
            this.map.put(accessorClass, accessorRegistry);
        }
        return accessorRegistry;
    }

    public Collection<Class<? extends Accessor>> getAccessorKeys() {
        return this.map.keySet();
    }

    public int getDepth() {
        int depth = 0;
        AbstractFileHandle ancestorHandle = this.fileHandle.getParentFileHandle();
        while (ancestorHandle != null) {
            ++depth;
            ancestorHandle = ancestorHandle.getParentFileHandle();
        }
        return depth;
    }

    public AbstractFileHandle getFileHandle() {
        return this.fileHandle;
    }

    public ProjectRegistry getProjectRegistry() {
        return this.parent;
    }

    public <A extends Accessor> Registration<A> getRegistration(A accessor) {
        AccessorRegistry<A> accessorRegistry = this.get(ClassUtils.getClass(accessor));
        return accessorRegistry != null ? accessorRegistry.get(accessor) : null;
    }

    public Collection<AccessorRegistry<?>> getRegistries() {
        return this.map.values();
    }

    public URI getURI(Accessor accessor) {
        Registration<Accessor> registration = this.getRegistration(accessor);
        return registration != null ? registration.getURI() : null;
    }

    public <A extends Accessor> Registration<A> remove(Registration<A> registration) {
        Class<A> accessorClass = registration.getAccessorClass();
        AccessorRegistry<A> registry = this.getOrCreate(accessorClass);
        return registry.remove(registration);
    }

    public String toString() {
        return this.getFileHandle().getAbsoluteName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessorClassToAccessorRegistryMap {
        private HashMap<Class<? extends Accessor>, AccessorRegistry<? extends Accessor>> map = new HashMap();

        private AccessorClassToAccessorRegistryMap() {
        }

        public <A extends Accessor> AccessorRegistry<A> get(Class<A> key) {
            return this.map.get(key);
        }

        public <A extends Accessor> AccessorRegistry<A> put(Class<A> key, AccessorRegistry<A> value) {
            return this.map.put(key, value);
        }

        public Collection<Class<? extends Accessor>> keySet() {
            return this.map.keySet();
        }

        public Collection<AccessorRegistry<? extends Accessor>> values() {
            return this.map.values();
        }
    }
}

