/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.environment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.qvt.declarative.modelregistry.environment.ClassDelegate;
import org.eclipse.qvt.declarative.modelregistry.model.ModelSerialization;
import org.eclipse.qvt.declarative.modelregistry.model.NamedSerialization;
import org.eclipse.qvt.declarative.modelregistry.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSerializationRegistry {
    private final Map<String, ModelSerialization> serializations = new HashMap<String, ModelSerialization>();

    public void addSerializationFactory(String name, Resource.Factory instance) {
        this.serializations.put(name, new SerializationFactory(name, instance));
    }

    public void addSerializationFactoryDelegate(String name, ModelSerialization modelSerialization) {
        this.serializations.put(name, modelSerialization);
    }

    public FactorySerializationDelegate getSerialization(String name) {
        ModelSerialization modelSerialisation = this.serializations.get(name);
        return ClassUtils.asClass(modelSerialisation, FactorySerializationDelegate.class);
    }

    public ModelSerialization getSerializationOrCreate(String name) {
        ModelSerialization modelSerialization = this.serializations.get(name);
        if (modelSerialization == null) {
            modelSerialization = new NamedSerialization(name);
            this.serializations.put(name, modelSerialization);
        }
        return modelSerialization;
    }

    public Collection<String> getSerializations() {
        return this.serializations.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FactorySerializationDelegate
    extends ClassDelegate<Resource.Factory>
    implements ModelSerialization {
        protected final String serializationName;

        public FactorySerializationDelegate(String serializationName, String className) {
            super(className, Resource.Factory.class);
            this.serializationName = serializationName;
        }

        public FactorySerializationDelegate(String serializationName, Resource.Factory instance) {
            super(instance);
            this.serializationName = serializationName;
        }

        @Override
        public String getFactoryClassName() {
            return this.className;
        }

        @Override
        public String getName() {
            return this.serializationName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializationFactory
    extends FactorySerializationDelegate {
        public SerializationFactory(String serializationName, Resource.Factory instance) {
            super(serializationName, instance);
        }

        @Override
        protected Class<?> loadClass(String className) {
            return null;
        }
    }
}

