/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.eclipse;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;

public class EclipseProjectHandle
extends EclipseFileHandle
implements AbstractProjectHandle {
    private Map<IResource, EclipseFileHandle> handles = new HashMap<IResource, EclipseFileHandle>();
    private String registryName = ".settings/org.eclipse.qvt.declarative.modelregistry";

    public EclipseProjectHandle(IProject project) {
        super(project);
        this.handles.put((IResource)project, this);
    }

    public EclipseFileHandle getFileHandle(String name) {
        IResource memberResource;
        Path path = new Path(name);
        IProject referenceResource = this.getProjectResource();
        if (path.isAbsolute()) {
            path = path.makeRelative();
            referenceResource = referenceResource.getParent();
        }
        if ((memberResource = referenceResource.findMember((IPath)path)) != null) {
            return this.getFileHandle(memberResource);
        }
        IFile fileResource = referenceResource.getFile((IPath)path);
        if (fileResource != null) {
            return this.getFileHandle((IResource)fileResource);
        }
        return null;
    }

    public EclipseFileHandle getFileHandle(IResource resource) {
        if (resource == null) {
            return null;
        }
        EclipseFileHandle handle = this.handles.get(resource);
        if (handle == null) {
            handle = new EclipseFileHandle(this, resource);
            this.handles.put(resource, handle);
        }
        return handle;
    }

    public IProject getProjectResource() {
        return (IProject)this.getResource();
    }

    public IFile getRegistryResource() {
        return this.getProjectResource().getFile((IPath)new Path(this.getRegistryName()));
    }

    public URI getRegistryURI() {
        URI registryURI = URI.createURI((String)this.registryName);
        URI projectURI = this.getURI();
        URI resolvedURI = registryURI.resolve(projectURI);
        return resolvedURI;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public URI getURI() {
        return URI.createURI((String)(String.valueOf(this.resource.getLocationURI().toString()) + "/"));
    }

    public void refreshRegistry() {
        IFile registryResource = this.getRegistryResource();
        try {
            registryResource.refreshLocal(0, null);
        }
        catch (CoreException e) {
            ModelRegistryEnvironment.logError("Failed to refresh registry", e);
        }
    }

    public void setRegistryName(String name) {
        this.registryName = name;
    }
}

