/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.mappings;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingEList;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingEObject;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingEPackage;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingInternalEList;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingXMIResource;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingXMIResourceFactory;
import org.eclipse.qvt.declarative.ecore.mappings.AbstractFeatureElement;
import org.eclipse.qvt.declarative.ecore.mappings.EAttributeMap;
import org.eclipse.qvt.declarative.ecore.mappings.EClassMap;
import org.eclipse.qvt.declarative.ecore.mappings.EReferenceMap;
import org.eclipse.qvt.declarative.ecore.mappings.EStructuralFeatureMap;
import org.eclipse.qvt.declarative.ecore.mappings.EcoreDetailElement;
import org.eclipse.qvt.declarative.ecore.mappings.EcoreFeatureElement;
import org.eclipse.qvt.declarative.ecore.mappings.ExtensionFeatureElement;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingConfigurationException;
import org.eclipse.qvt.declarative.ecore.mappings.MappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMetaDataRegistry
extends BasicExtendedMetaData
implements IMappingMetaDataRegistry.Install {
    public static ConsistencyValidator consistencyValidator = null;
    protected final EPackage rootAdaptingEPackage;
    protected final AdaptingXMIResourceFactory resourceAdapterFactory;
    private Map<IMappingMetaData, IMappingMetaData.Factory> mappingMetaDatas = new HashMap<IMappingMetaData, IMappingMetaData.Factory>();
    private List<IMappingMetaData> uninitializedMappingMetaDatas = new ArrayList<IMappingMetaData>();
    protected final Set<EPackage> ecorePackages = new HashSet<EPackage>();
    protected final Map<String, EPackage> adaptingPackages = new HashMap<String, EPackage>();
    protected final Map<EClass, EClassMap> adaptingEClassMaps = new HashMap<EClass, EClassMap>();
    protected final Map<String, EDataType> adaptingEDataTypeMaps = new HashMap<String, EDataType>();
    protected final Map<EClass, EClassMap> ecoreEClassMaps = new HashMap<EClass, EClassMap>();
    protected final Map<String, EDataType> ecoreEDataTypeMaps = new HashMap<String, EDataType>();
    protected final EStructuralFeature xmiExtensionFeature;
    protected final EStructuralFeature extenderFeature;
    protected final Map<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>> ecoreEStructuralFeatureMaps = new HashMap<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>>();
    protected final Map<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>> adaptingEStructuralFeatureMaps = new HashMap<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>>();

    public MappingMetaDataRegistry(EPackage rootAdaptingEPackage, AdaptingXMIResourceFactory resourceAdapterFactory) {
        assert (rootAdaptingEPackage != EcorePackage.eINSTANCE);
        this.rootAdaptingEPackage = rootAdaptingEPackage;
        this.resourceAdapterFactory = resourceAdapterFactory != null ? resourceAdapterFactory : new AdaptingXMIResourceFactory(this, new MappingMetaData[0]);
        this.xmiExtensionFeature = this.demandFeature("http://www.omg.org/XMI", "Extension", true);
        this.extenderFeature = this.demandFeature(null, "extender", false);
    }

    @Override
    public void addMappingMetaData(IMappingMetaData.Factory mappingMetaDataFactory) {
        IMappingMetaData mappingMetaData = mappingMetaDataFactory.getMappingMetaData();
        if (this.mappingMetaDatas.containsKey(mappingMetaData)) {
            return;
        }
        this.mappingMetaDatas.put(mappingMetaData, mappingMetaDataFactory);
        if (this.uninitializedMappingMetaDatas.contains(mappingMetaData)) {
            return;
        }
        boolean wasInitialized = !this.mappingMetaDatas.isEmpty() && this.uninitializedMappingMetaDatas.isEmpty();
        this.uninitializedMappingMetaDatas.add(mappingMetaData);
        for (IMappingMetaData importedMappingMetaData : mappingMetaData.getImports()) {
            if (this.mappingMetaDatas.containsKey(importedMappingMetaData)) continue;
            this.uninitializedMappingMetaDatas.add(importedMappingMetaData);
        }
        if (wasInitialized) {
            this.initialize();
        }
    }

    @Override
    public void configure(ResourceSet resourceSet) {
        for (IMappingMetaData mappingMetaData : this.mappingMetaDatas.keySet()) {
            mappingMetaData.configure(resourceSet, this);
        }
    }

    public AdaptingEObject createAdapter(EObject ecoreObject) {
        EClass ecoreEClass = ecoreObject.eClass();
        EClassMap eClassMap = this.getEcoreEClassMap(ecoreEClass);
        if (eClassMap == null) {
            throw new MappingConfigurationException("No adapting class adapter configured", (EObject)ecoreEClass, null);
        }
        return eClassMap.createAdapter(this, ecoreObject);
    }

    protected AdaptingXMIResource createAdapter(Resource resource, URI uri) {
        ResourceSet resourceSet;
        AdaptingXMIResource adapter = new AdaptingXMIResource(resource, uri, this);
        if (uri != null && !uri.equals((Object)resource.getURI()) && (resourceSet = resource.getResourceSet()) != null) {
            resourceSet.getResources().add((Object)adapter);
        }
        return adapter;
    }

    @Override
    public EStructuralFeature createDemandEcoreFeature(EStructuralFeature ecoreFeature) {
        boolean isReference = ecoreFeature instanceof EReference;
        boolean isElement = isReference ? ((EReference)ecoreFeature).isContainment() : false;
        return this.demandFeature(null, ecoreFeature.getName(), isElement, isReference);
    }

    @Override
    public EAttribute createDemandExtensionAttributeAsAttributeFeature(EAttribute ecoreFeature) {
        return (EAttribute)this.demandFeature(null, ecoreFeature.getName(), false, false);
    }

    @Override
    public EReference createDemandExtensionAttributeAsReferenceFeature(EAttribute ecoreFeature) {
        return (EReference)this.demandFeature(null, ecoreFeature.getName(), true, true);
    }

    @Override
    public EReference createDemandExtensionReferenceFeature(EReference ecoreFeature, boolean isElement) {
        return (EReference)this.demandFeature(null, ecoreFeature.getName(), isElement, true);
    }

    public EPackage demandPackage(String namespace) {
        EPackage ePackage = this.adaptingPackages.get(namespace);
        if (ePackage == null) {
            ePackage = super.demandPackage(namespace);
        }
        return ePackage;
    }

    protected <K, T> void diagnosedPut(Map<K, T> map, K key, T newValue) {
        T oldValue = map.put(key, newValue);
        if (oldValue != newValue) assert (oldValue == null) : oldValue + " displaced by " + newValue;
    }

    @Override
    public EDataType exportEDataType(EDataType ecoreEDataType) {
        URI uri = EcoreUtil.getURI((EObject)ecoreEDataType);
        EDataType adaptingEDataType = this.ecoreEDataTypeMaps.get(uri.toString());
        return adaptingEDataType != null ? adaptingEDataType : ecoreEDataType;
    }

    @Override
    public EObject getAdapter(EObject ecoreObject) {
        AdaptingEObject eAdapter2;
        if (ecoreObject == null) {
            return null;
        }
        this.initialize();
        EList eAdapters = ecoreObject.eAdapters();
        for (AdaptingEObject eAdapter2 : eAdapters) {
            if (!(eAdapter2 instanceof AdaptingEObject) || eAdapter2.getMappingMetaDataRegistry() != this) continue;
            return MappingUtils.asClassUnchecked(eAdapter2, null);
        }
        eAdapter2 = this.createAdapter(ecoreObject);
        if (eAdapter2 != null) {
            eAdapters.add(eAdapter2);
        }
        return eAdapter2;
    }

    @Override
    public AdaptingXMIResource getAdapter(Resource resource, URI uri) {
        Adapter eAdapter2;
        if (resource == null) {
            return null;
        }
        this.initialize();
        EList eAdapters = resource.eAdapters();
        for (Adapter eAdapter2 : eAdapters) {
            if (!(eAdapter2 instanceof AdaptingXMIResource) || ((AdaptingXMIResource)eAdapter2).getMappingMetaDataRegistry() != this) continue;
            return (AdaptingXMIResource)eAdapter2;
        }
        eAdapter2 = this.createAdapter(resource, uri);
        eAdapters.add(eAdapter2);
        return eAdapter2;
    }

    @Override
    public <E extends EObject, A extends EObject> EList<A> getAdapters(EList<E> ecoreObjects) {
        if (ecoreObjects instanceof InternalEList) {
            return new AdaptingInternalEList(this, (InternalEList)ecoreObjects);
        }
        return new AdaptingEList(this, ecoreObjects);
    }

    @Override
    public EClassMap getAdaptingEClassMap(EClass adaptingEClass) {
        return this.adaptingEClassMaps.get(adaptingEClass);
    }

    @Override
    public EStructuralFeatureMap<? extends EStructuralFeature> getAdaptingEStructuralFeatureMap(EStructuralFeature adaptingFeature) {
        return this.adaptingEStructuralFeatureMaps.get(adaptingFeature);
    }

    @Override
    public EClassMap getEcoreEClassMap(EClass ecoreEClass) {
        return this.ecoreEClassMaps.get(ecoreEClass);
    }

    @Override
    public EStructuralFeatureMap<? extends EStructuralFeature> getEcoreEStructuralFeatureMap(EStructuralFeature ecoreFeature) {
        return this.ecoreEStructuralFeatureMaps.get(ecoreFeature);
    }

    @Override
    public MappingMetaData getMappingMetaData(EClass adaptingEClass) {
        EClassMap classMap = this.getAdaptingEClassMap(adaptingEClass);
        return classMap != null ? classMap.getMappingMetaData() : null;
    }

    @Override
    public IMappingMetaData.Factory getMappingMetaDataFactory(IMappingMetaData mappingMetaData) {
        IMappingMetaData.Factory mappingMetaDataFactory = this.mappingMetaDatas.get(mappingMetaData);
        if (mappingMetaDataFactory == null) {
            mappingMetaDataFactory = mappingMetaData.createFactory(this);
        }
        return mappingMetaDataFactory;
    }

    public String getName() {
        return this.getRootAdaptingEPackage().getName();
    }

    public EPackage getPackage(String namespace) {
        EPackage ePackage = super.getPackage(namespace);
        if (ePackage == null) {
            return null;
        }
        IMappingMetaData mappingMetaData = REGISTRY.getMappingMetaData(ePackage);
        if (mappingMetaData == null) {
            return ePackage;
        }
        IMappingMetaData.Factory factory = mappingMetaData.getFactory(this);
        factory.getMappingMetaDataRegistry().initialize();
        return new AdaptingEPackage(factory, ePackage);
    }

    @Override
    public AdaptingXMIResourceFactory getResourceFactory() {
        return this.resourceAdapterFactory;
    }

    public EPackage getRootAdaptingEPackage() {
        return this.rootAdaptingEPackage;
    }

    @Override
    public List<AnyType> getXMIExtensions(EObject object) {
        boolean createIfAbsent = true;
        List<AnyType> ecoreExtensions = this.getXMIExtensionsOrNull(object);
        if (createIfAbsent && ecoreExtensions == null) {
            XMLResource resource = (XMLResource)object.eResource();
            Map eObjectToExtensionMap = resource.getEObjectToExtensionMap();
            AnyType xmiExtensions = (AnyType)eObjectToExtensionMap.get(object);
            if (xmiExtensions == null) {
                xmiExtensions = XMLTypeFactory.eINSTANCE.createAnyType();
                eObjectToExtensionMap.put(object, xmiExtensions);
            }
            AnyType xmiExtension = XMLTypeFactory.eINSTANCE.createAnyType();
            xmiExtension.getAnyAttribute().add(this.extenderFeature, (Object)"http://www.eclipse.org/emf/2002/Ecore");
            ecoreExtensions = new ArrayList<AnyType>();
            ecoreExtensions.add(xmiExtension);
            xmiExtensions.getMixed().add(this.xmiExtensionFeature, (Object)xmiExtension);
        }
        return ecoreExtensions;
    }

    public List<AnyType> getXMIExtensionsOrNull(EObject object) {
        AnyType xmiExtensions;
        assert (!(object instanceof AnyType));
        XMLResource resource = (XMLResource)object.eResource();
        Map eObjectToExtensionMap = resource != null ? resource.getEObjectToExtensionMap() : null;
        AnyType anyType = xmiExtensions = eObjectToExtensionMap != null ? (AnyType)eObjectToExtensionMap.get(object) : null;
        if (xmiExtensions == null) {
            return null;
        }
        ArrayList<AnyType> ecoreXMIExtensions = null;
        for (FeatureMap.Entry xmiExtensionEntry : xmiExtensions.getMixed()) {
            Object xmiExtensionObject;
            if (xmiExtensionEntry.getEStructuralFeature() != this.xmiExtensionFeature || !((xmiExtensionObject = xmiExtensionEntry.getValue()) instanceof AnyType)) continue;
            AnyType xmiExtension = (AnyType)xmiExtensionObject;
            Object extender = xmiExtension.getAnyAttribute().get(this.extenderFeature, false);
            if (!EcorePackage.eINSTANCE.getNsURI().equals(extender)) continue;
            if (ecoreXMIExtensions == null) {
                ecoreXMIExtensions = new ArrayList<AnyType>();
            }
            ecoreXMIExtensions.add(xmiExtension);
        }
        return ecoreXMIExtensions;
    }

    @Override
    public List<Object> getXMIExtensionValuesOrNull(EObject object, EStructuralFeature eStructuralFeature) {
        AnyType ecoreExtension;
        int iMax;
        String featureName = eStructuralFeature.getName();
        List<AnyType> ecoreExtensions = null;
        if (!(object instanceof AnyType)) {
            ecoreExtensions = this.getXMIExtensionsOrNull(object);
            if (ecoreExtensions == null) {
                return null;
            }
            iMax = ecoreExtensions.size();
            if (iMax <= 0) {
                return null;
            }
            ecoreExtension = ecoreExtensions.get(0);
        } else {
            iMax = 1;
            ecoreExtension = (AnyType)object;
        }
        ArrayList<Object> result = null;
        int i = 0;
        while (true) {
            for (FeatureMap.Entry xmiExtensionChildEntry : ecoreExtension.getMixed()) {
                if (!xmiExtensionChildEntry.getEStructuralFeature().getName().equals(featureName)) continue;
                if (result == null) {
                    result = new ArrayList<Object>();
                }
                result.add(xmiExtensionChildEntry.getValue());
            }
            for (FeatureMap.Entry xmiExtensionChildEntry : ecoreExtension.getAnyAttribute()) {
                if (!xmiExtensionChildEntry.getEStructuralFeature().getName().equals(featureName)) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(xmiExtensionChildEntry.getValue());
            }
            if (ecoreExtensions == null || ++i >= iMax) break;
            ecoreExtension = ecoreExtensions.get(i);
        }
        return result;
    }

    @Override
    public EDataType importEDataType(EDataType adaptingEDataType) {
        URI uri = EcoreUtil.getURI((EObject)adaptingEDataType);
        EDataType ecoreEDataType = this.adaptingEDataTypeMaps.get(uri.toString());
        return ecoreEDataType != null ? ecoreEDataType : adaptingEDataType;
    }

    @Override
    public void initialize() {
        if (!this.uninitializedMappingMetaDatas.isEmpty()) {
            Collections.sort(this.uninitializedMappingMetaDatas, MappingMetaData.ImportComparator.INSTANCE);
            for (IMappingMetaData mappingMetaData : this.uninitializedMappingMetaDatas) {
                mappingMetaData.getFactory(this);
                mappingMetaData.initialize(this);
            }
            this.uninitializedMappingMetaDatas.clear();
            for (EClassMap eClassMap : this.ecoreEClassMaps.values()) {
                eClassMap.compile(this);
            }
        }
    }

    @Override
    public EClassMap install(EClassMap eClassMap) {
        EClass adaptingEClass;
        EClass ecoreEClass = eClassMap.getEcoreEClass();
        if (ecoreEClass != null) {
            this.putEcoreEClassMap(ecoreEClass, eClassMap);
        }
        if ((adaptingEClass = eClassMap.getAdaptingEClass()) != null) {
            this.putAdaptingEClassMap(adaptingEClass, eClassMap);
        }
        return eClassMap;
    }

    @Override
    public void install(EStructuralFeatureMap<? extends EStructuralFeature> eStructuralFeatureMap) {
        eStructuralFeatureMap.install();
    }

    @Override
    public void installAdaptingClassMapFeatures(EClass ecoreClass, EClass adaptingClass) {
        for (EStructuralFeature adaptingFeature : adaptingClass.getEAllStructuralFeatures()) {
            EStructuralFeatureMap<? extends EStructuralFeature> adaptingFeatureMap;
            if (adaptingFeature.isDerived() || adaptingFeature.isTransient() || adaptingFeature.isVolatile() || adaptingFeature instanceof EReference && ((EReference)adaptingFeature).isContainer() || (adaptingFeatureMap = this.getAdaptingEStructuralFeatureMap(adaptingFeature)) != null) continue;
            EStructuralFeature ecoreFeature = ecoreClass.getEStructuralFeature(adaptingFeature.getName());
            if (ecoreFeature == null) {
                if (consistencyValidator == null) continue;
                consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, null, ecoreClass, adaptingClass);
                continue;
            }
            if (ecoreFeature instanceof EAttribute) {
                this.installFeatureToFeatureMap((EAttribute)ecoreFeature, (EAttribute)adaptingFeature);
                continue;
            }
            this.installFeatureToFeatureMap((EReference)ecoreFeature, (EReference)adaptingFeature);
        }
    }

    @Override
    public void installClassPair(MappingMetaData mappingMetaData, EClass ecoreClass, EClass adaptingClass) {
        this.install(new EClassMap.Direct(mappingMetaData, ecoreClass, adaptingClass));
        this.installAdaptingClassMapFeatures(ecoreClass, adaptingClass);
        this.installEcoreClassMapFeatures(ecoreClass, adaptingClass);
    }

    @Override
    public void installClassToExtensionMap(EClassMap.Extension eClassMap) {
        EClass ecoreEClass = eClassMap.getEcoreEClass();
        if (ecoreEClass != null) {
            this.putEcoreEClassMap(ecoreEClass, eClassMap);
        }
    }

    @Override
    public void installDetailToFeatureMap(String detailsKey, EAttribute adaptingFeature) {
        EcoreDetailElement ecoreDetailElement = EcoreDetailElement.create(detailsKey);
        EcoreFeatureElement<EAttribute> adaptingFeatureElement = EcoreFeatureElement.create(adaptingFeature);
        this.install(new EAttributeMap((IMappingMetaDataRegistry.Install)this, ecoreDetailElement, (AbstractFeatureElement<? extends EStructuralFeature>)adaptingFeatureElement));
    }

    @Override
    public void installEcoreClassMapFeatures(EClass ecoreClass, EClass adaptingClass) {
        for (EStructuralFeature ecoreFeature : ecoreClass.getEAllStructuralFeatures()) {
            EStructuralFeatureMap<? extends EStructuralFeature> ecoreFeatureMap;
            if (ecoreFeature.isDerived() || ecoreFeature.isTransient() || ecoreFeature.isVolatile() || ecoreFeature instanceof EReference && ((EReference)ecoreFeature).isContainer() || (ecoreFeatureMap = this.getEcoreEStructuralFeatureMap(ecoreFeature)) != null) continue;
            EStructuralFeature adaptingFeature = adaptingClass.getEStructuralFeature(ecoreFeature.getName());
            if (adaptingFeature == null) {
                if (consistencyValidator == null) continue;
                consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, null, ecoreClass, adaptingClass);
                continue;
            }
            if (ecoreFeature instanceof EAttribute) {
                this.installFeatureToFeatureMap((EAttribute)ecoreFeature, (EAttribute)adaptingFeature);
                continue;
            }
            this.installFeatureToFeatureMap((EReference)ecoreFeature, (EReference)adaptingFeature);
        }
    }

    @Override
    public void installFeatureToExtensionAttributeMap(EAttribute ecoreFeature) {
        EcoreFeatureElement<EAttribute> ecoreFeatureElement = EcoreFeatureElement.create(ecoreFeature);
        EAttribute extensionFeature = this.createDemandExtensionAttributeAsAttributeFeature(ecoreFeature);
        ExtensionFeatureElement<EAttribute, EAttribute> adaptingFeatureElement = ExtensionFeatureElement.create(ecoreFeature, extensionFeature);
        this.install(new EAttributeMap((IMappingMetaDataRegistry.Install)this, (AbstractFeatureElement<EAttribute>)ecoreFeatureElement, (AbstractFeatureElement<? extends EStructuralFeature>)adaptingFeatureElement));
    }

    @Override
    public void installFeatureToExtensionAttributeOrElementMap(EReference ecoreFeature) {
        assert (!ecoreFeature.isContainment());
        EcoreFeatureElement<EReference> ecoreFeatureElement = EcoreFeatureElement.create(ecoreFeature);
        EReference extensionElementFeature = this.createDemandExtensionReferenceFeature(ecoreFeature, true);
        EReference extensionAttributeFeature = this.createDemandExtensionReferenceFeature(ecoreFeature, false);
        if (ecoreFeature.isMany()) {
            extensionAttributeFeature.setUpperBound(-1);
        }
        ExtensionFeatureElement<EReference, EReference> adaptingFeatureElement = ExtensionFeatureElement.create(ecoreFeature, extensionAttributeFeature, extensionElementFeature);
        this.install(new EReferenceMap((IMappingMetaDataRegistry.Install)this, ecoreFeatureElement, (AbstractFeatureElement<EReference>)adaptingFeatureElement));
    }

    @Override
    public void installFeatureToExtensionElementMap(EAttribute ecoreFeature) {
        EcoreFeatureElement<EAttribute> ecoreFeatureElement = EcoreFeatureElement.create(ecoreFeature);
        EReference extensionFeature = this.createDemandExtensionAttributeAsReferenceFeature(ecoreFeature);
        ExtensionFeatureElement<EReference, EAttribute> adaptingFeatureElement = ExtensionFeatureElement.create(ecoreFeature, extensionFeature);
        this.install(new EAttributeMap((IMappingMetaDataRegistry.Install)this, (AbstractFeatureElement<EAttribute>)ecoreFeatureElement, (AbstractFeatureElement<? extends EStructuralFeature>)adaptingFeatureElement));
    }

    @Override
    public void installFeatureToExtensionElementMap(EReference ecoreFeature) {
        assert (ecoreFeature.isContainment());
        EcoreFeatureElement<EReference> ecoreFeatureElement = EcoreFeatureElement.create(ecoreFeature);
        EReference extensionFeature = this.createDemandExtensionReferenceFeature(ecoreFeature, true);
        ExtensionFeatureElement<EReference, EReference> adaptingFeatureElement = ExtensionFeatureElement.create(ecoreFeature, extensionFeature);
        this.install(new EReferenceMap((IMappingMetaDataRegistry.Install)this, ecoreFeatureElement, (AbstractFeatureElement<EReference>)adaptingFeatureElement));
    }

    @Override
    public void installFeatureToFeatureMap(EAttribute ecoreFeature, EAttribute adaptingFeature) {
        EStructuralFeatureMap<? extends EStructuralFeature> ecoreFeatureMap = this.getEcoreEStructuralFeatureMap((EStructuralFeature)ecoreFeature);
        EStructuralFeatureMap<? extends EStructuralFeature> adaptingFeatureMap = this.getAdaptingEStructuralFeatureMap((EStructuralFeature)adaptingFeature);
        if (ecoreFeatureMap != null || adaptingFeatureMap != null) {
            if (ecoreFeatureMap == adaptingFeatureMap) {
                return;
            }
            if (consistencyValidator != null) {
                consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, null, ecoreFeatureMap, adaptingFeatureMap);
            }
        } else {
            EcoreFeatureElement<EAttribute> ecoreFeatureElement = EcoreFeatureElement.create(ecoreFeature);
            EcoreFeatureElement<EAttribute> adaptingFeatureElement = EcoreFeatureElement.create(adaptingFeature);
            this.install(new EAttributeMap((IMappingMetaDataRegistry.Install)this, (AbstractFeatureElement<EAttribute>)ecoreFeatureElement, (AbstractFeatureElement<? extends EStructuralFeature>)adaptingFeatureElement));
        }
    }

    @Override
    public void installFeatureToFeatureMap(EReference ecoreFeature, EReference adaptingFeature) {
        EStructuralFeatureMap<? extends EStructuralFeature> ecoreFeatureMap = this.getEcoreEStructuralFeatureMap((EStructuralFeature)ecoreFeature);
        EStructuralFeatureMap<? extends EStructuralFeature> adaptingFeatureMap = this.getAdaptingEStructuralFeatureMap((EStructuralFeature)adaptingFeature);
        if (consistencyValidator != null && (ecoreFeature != null || adaptingFeature != null)) {
            if (ecoreFeature != null != (adaptingFeature != null)) {
                consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, null, ecoreFeature, adaptingFeature);
            } else if (ecoreFeature != null && adaptingFeature != null) {
                if (ecoreFeature.getLowerBound() != adaptingFeature.getLowerBound()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__LOWER_BOUND, ecoreFeature.getLowerBound(), adaptingFeature.getLowerBound());
                }
                if (ecoreFeature.isOrdered() != adaptingFeature.isOrdered() && ecoreFeature.isMany()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__ORDERED, ecoreFeature.isOrdered(), adaptingFeature.isOrdered());
                }
                if (ecoreFeature.isUnique() != adaptingFeature.isUnique()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__UNIQUE, ecoreFeature.isUnique(), adaptingFeature.isUnique());
                }
                if (ecoreFeature.getUpperBound() != adaptingFeature.getUpperBound()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND, ecoreFeature.getUpperBound(), adaptingFeature.getUpperBound());
                }
                if (ecoreFeature.isChangeable() != adaptingFeature.isChangeable()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__CHANGEABLE, ecoreFeature.isChangeable(), adaptingFeature.isChangeable());
                }
                if (ecoreFeature.isDerived() != adaptingFeature.isDerived()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DERIVED, ecoreFeature.isDerived(), adaptingFeature.isDerived());
                }
                if (ecoreFeature.isTransient() != adaptingFeature.isTransient()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__TRANSIENT, ecoreFeature.isTransient(), adaptingFeature.isTransient());
                }
                if (ecoreFeature.isUnsettable() != adaptingFeature.isUnsettable()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__UNSETTABLE, ecoreFeature.isUnsettable(), adaptingFeature.isUnsettable());
                }
                if (ecoreFeature.isVolatile() != adaptingFeature.isVolatile()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__VOLATILE, ecoreFeature.isVolatile(), adaptingFeature.isVolatile());
                }
                if (ecoreFeature.isContainment() != adaptingFeature.isContainment()) {
                    consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, (EStructuralFeature)EcorePackage.Literals.EREFERENCE__CONTAINMENT, ecoreFeature.isContainment(), adaptingFeature.isContainment());
                }
            }
        }
        if (ecoreFeatureMap != null || adaptingFeatureMap != null) {
            if (ecoreFeatureMap == adaptingFeatureMap) {
                return;
            }
            if (consistencyValidator != null) {
                consistencyValidator.inconsistent((ENamedElement)ecoreFeature, (ENamedElement)adaptingFeature, null, ecoreFeatureMap, adaptingFeatureMap);
            }
        } else {
            EcoreFeatureElement<EReference> ecoreFeatureElement = EcoreFeatureElement.create(ecoreFeature);
            EcoreFeatureElement<EReference> adaptingFeatureElement = EcoreFeatureElement.create(adaptingFeature);
            this.install(new EReferenceMap((IMappingMetaDataRegistry.Install)this, ecoreFeatureElement, (AbstractFeatureElement<EReference>)adaptingFeatureElement));
        }
    }

    @Override
    public void installPackagePair(MappingMetaData mappingMetaData, EPackage ecorePackage, EPackage adaptingPackage) {
        for (EClassifier adaptingClassifier : adaptingPackage.getEClassifiers()) {
            if (!(adaptingClassifier instanceof EClass) || ((EClass)adaptingClassifier).isAbstract() || this.getAdaptingEClassMap((EClass)adaptingClassifier) != null) continue;
            EClassifier ecoreClassifier = ecorePackage.getEClassifier(adaptingClassifier.getName());
            if (ecoreClassifier == null) {
                if (consistencyValidator == null) continue;
                consistencyValidator.inconsistent((ENamedElement)ecoreClassifier, (ENamedElement)adaptingClassifier, null, ecorePackage, adaptingPackage);
                continue;
            }
            if (!(adaptingClassifier instanceof EClass)) continue;
            this.installClassPair(mappingMetaData, (EClass)ecoreClassifier, (EClass)adaptingClassifier);
        }
        for (EClassifier ecoreClassifier : ecorePackage.getEClassifiers()) {
            EClassifier adaptingClassifier;
            if (!(ecoreClassifier instanceof EClass) || ((EClass)ecoreClassifier).isAbstract() || this.getEcoreEClassMap((EClass)ecoreClassifier) != null || (adaptingClassifier = adaptingPackage.getEClassifier(ecoreClassifier.getName())) != null || consistencyValidator == null) continue;
            consistencyValidator.inconsistent((ENamedElement)ecoreClassifier, (ENamedElement)adaptingClassifier, null, ecorePackage, adaptingPackage);
        }
    }

    @Override
    public void postLoad(EObject ecoreObject) {
        EClass ecoreClass = ecoreObject.eClass();
        EClassMap eClassMap = this.getEcoreEClassMap(ecoreClass);
        if (eClassMap != null) {
            eClassMap.postLoad(this, ecoreObject);
        }
    }

    @Override
    public void postSave(EObject ecoreObject) {
        EClass ecoreClass = ecoreObject.eClass();
        EClassMap eClassMap = this.getEcoreEClassMap(ecoreClass);
        if (eClassMap != null) {
            eClassMap.postSave(this, ecoreObject);
        }
    }

    @Override
    public void preLoad(EObject ecoreObject) {
        EClass ecoreClass = ecoreObject.eClass();
        EClassMap eClassMap = this.getEcoreEClassMap(ecoreClass);
        if (eClassMap != null) {
            eClassMap.preLoad(this, ecoreObject);
        }
    }

    @Override
    public void preSave(EObject ecoreObject) {
        EClass ecoreClass = ecoreObject.eClass();
        EClassMap eClassMap = this.getEcoreEClassMap(ecoreClass);
        if (eClassMap != null) {
            eClassMap.preSave(this, ecoreObject);
        }
    }

    @Override
    public void putAdaptingEClassMap(EClass adaptingEClass, EClassMap classMap) {
        assert (adaptingEClass != null) : "null adaptingEClass in putAdaptingClassMap";
        assert (classMap != null) : "null classMap in putAdaptingClassMap";
        this.diagnosedPut(this.adaptingEClassMaps, adaptingEClass, classMap);
        EPackage adaptingPackage = adaptingEClass.getEPackage();
        String adaptingURI = adaptingPackage.getNsURI();
        this.putAdaptingPackage(adaptingURI, adaptingPackage);
    }

    @Override
    public void putAdaptingFeatureMap(EStructuralFeature adaptingEStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature> structuralFeatureMap) {
        this.diagnosedPut(this.adaptingEStructuralFeatureMaps, adaptingEStructuralFeature, structuralFeatureMap);
    }

    protected void putAdaptingPackage(String adaptingURI, EPackage adaptingPackage) {
        if (!this.adaptingPackages.containsKey(adaptingURI)) {
            this.adaptingPackages.put(adaptingURI, adaptingPackage);
        }
    }

    @Override
    public void putEDataTypeMap(EDataType ecoreEDataType, EDataType adaptingEDataType) {
        URI adaptingURI = EcoreUtil.getURI((EObject)adaptingEDataType);
        URI ecoreURI = EcoreUtil.getURI((EObject)ecoreEDataType);
        this.diagnosedPut(this.adaptingEDataTypeMaps, adaptingURI.toString(), ecoreEDataType);
        this.diagnosedPut(this.ecoreEDataTypeMaps, ecoreURI.toString(), adaptingEDataType);
    }

    @Override
    public void putEcoreEClassMap(EClass ecoreEClass, EClassMap classMap) {
        assert (ecoreEClass != null) : "null ecoreEClass in putEcoreClassMap";
        assert (classMap != null) : "null classMap in putEcoreClassMap";
        this.diagnosedPut(this.ecoreEClassMaps, ecoreEClass, classMap);
        EPackage ecorePackage = ecoreEClass.getEPackage();
        if (!this.ecorePackages.contains(ecorePackage)) {
            this.ecorePackages.add(ecorePackage);
        }
    }

    @Override
    public void putEcoreFeatureMap(EStructuralFeature ecoreEStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature> structuralFeatureMap) {
        this.diagnosedPut(this.ecoreEStructuralFeatureMaps, ecoreEStructuralFeature, structuralFeatureMap);
    }

    @Override
    public EClassMap removeAdaptingEClassMap(EClass adaptingEClass) {
        EClassMap removedClassMap = this.adaptingEClassMaps.remove(adaptingEClass);
        assert (removedClassMap != null) : "No class map to remove for " + adaptingEClass;
        return removedClassMap;
    }

    @Override
    public EClassMap removeEcoreEClassMap(EClass ecoreEClass) {
        EClassMap removedClassMap = this.ecoreEClassMaps.remove(ecoreEClass);
        assert (removedClassMap != null) : "No class map to remove for " + ecoreEClass;
        return removedClassMap;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " <-> Ecore";
    }

    @Override
    public EObject validate(PrintWriter writer) {
        EClassifier badObject = null;
        for (EPackage ecorePackage : this.ecorePackages) {
            for (EClassifier ecoreClassifier : ecorePackage.getEClassifiers()) {
                if (!(ecoreClassifier instanceof EClass)) continue;
                EClassMap classMap = this.ecoreEClassMaps.get(ecoreClassifier);
                if (classMap == null) {
                    if (((EClass)ecoreClassifier).isAbstract()) continue;
                    if (writer != null) {
                        writer.println("Missing class: " + MappingUtils.formatFullName(ecoreClassifier));
                    }
                    badObject = ecoreClassifier;
                    continue;
                }
                EStructuralFeature badFeature = classMap.validate(this, writer);
                if (badFeature == null) continue;
                badObject = badFeature;
            }
        }
        return badObject;
    }

    public static interface ConsistencyValidator {
        public void inconsistent(ENamedElement var1, ENamedElement var2, EStructuralFeature var3, Object var4, Object var5);
    }
}

