/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class LineNumberTableReader
extends AttributeReader {
    public LineNumberTableReader(ClassReader.AttrIterator iter) throws InvalidClassFileException {
        super(iter, "LineNumberTable");
        int offset = this.attr + 6;
        this.checkSize(offset, 2);
        int count = this.cr.getUShort(offset);
        this.checkSize(offset += 2, count * 4);
    }

    public int[] getRawTable() {
        int count = this.cr.getUShort(this.attr + 6);
        int[] r = new int[count * 2];
        int offset = this.attr + 8;
        int i = 0;
        while (i < r.length) {
            r[i] = this.cr.getUShort(offset);
            offset += 2;
            ++i;
        }
        return r;
    }

    public static int[] makeBytecodeToSourceMap(CodeReader code) throws InvalidClassFileException, IllegalArgumentException {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        int[] r = null;
        ClassReader cr = code.getClassReader();
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        code.initAttributeIterator(iter);
        while (iter.isValid()) {
            if (iter.getName().equals("LineNumberTable")) {
                if (r == null) {
                    r = new int[code.getBytecodeLength()];
                }
                new LineNumberTableReader(iter);
                int attr = iter.getRawOffset();
                int count = cr.getUShort(attr + 6);
                int offset = attr + 8;
                int j = 0;
                while (j < count) {
                    int startPC = cr.getUShort(offset);
                    int lineNum = cr.getUShort(offset + 2);
                    offset += 4;
                    if (startPC < 0 || startPC >= r.length) {
                        throw new InvalidClassFileException(offset, "Invalid bytecode offset " + startPC + " in LineNumberTable");
                    }
                    r[startPC] = lineNum;
                    ++j;
                }
            }
            iter.advance();
        }
        if (r != null) {
            int last = 0;
            int i = 0;
            while (i < r.length) {
                int cur = r[i];
                if (cur == 0) {
                    r[i] = last;
                } else {
                    last = cur;
                }
                ++i;
            }
        }
        return r;
    }
}

