/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class CTDecoder
extends Decoder {
    public CTDecoder(CodeReader r) throws NullPointerException {
        this(r, CTDecoder.makeConstantPoolReader(r.getClassReader()));
    }

    public CTDecoder(CodeReader r, ConstantPoolReader cpr) throws NullPointerException {
        super(r.getBytecode(), r.getRawHandlers(), cpr);
    }

    public static String convertClassToType(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s.length() > 0 && s.charAt(0) != '[') {
            return "L" + s + ";";
        }
        return s;
    }

    public static ConstantPoolReader makeConstantPoolReader(ClassReader cr) throws IllegalArgumentException {
        if (cr == null) {
            throw new IllegalArgumentException("illegal null cr");
        }
        return new CPReader(cr.getCP());
    }

    static final class CPReader
    extends ConstantPoolReader {
        private final ConstantPoolParser cp;

        CPReader(ConstantPoolParser cp) {
            this.cp = cp;
        }

        public int getConstantPoolItemType(int index) {
            return this.cp.getItemType(index);
        }

        private Error convertToError(InvalidClassFileException e) {
            e.printStackTrace();
            return new Error("Invalid class file: " + e.getMessage());
        }

        public int getConstantPoolInteger(int index) {
            try {
                return this.cp.getCPInt(index);
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public float getConstantPoolFloat(int index) {
            try {
                return this.cp.getCPFloat(index);
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public long getConstantPoolLong(int index) {
            try {
                return this.cp.getCPLong(index);
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public double getConstantPoolDouble(int index) {
            try {
                return this.cp.getCPDouble(index);
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public String getConstantPoolString(int index) {
            try {
                return this.cp.getCPString(index);
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public String getConstantPoolClassType(int index) {
            try {
                return CTDecoder.convertClassToType(this.cp.getCPClass(index));
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public String getConstantPoolMemberClassType(int index) {
            try {
                return CTDecoder.convertClassToType(this.cp.getCPRefClass(index));
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public String getConstantPoolMemberName(int index) {
            try {
                return this.cp.getCPRefName(index);
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }

        public String getConstantPoolMemberType(int index) {
            try {
                return this.cp.getCPRefType(index);
            }
            catch (InvalidClassFileException e) {
                throw this.convertToError(e);
            }
        }
    }
}

