/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import java.io.IOException;
import java.io.Writer;

public class Disassembler {
    private final Instruction[] instructions;
    private final ExceptionHandler[][] handlers;
    private final int[] instructionsToBytecodes;

    public Disassembler(Instruction[] instructions, ExceptionHandler[][] handlers, int[] instructionsToBytecodes) {
        this.instructions = instructions;
        this.handlers = handlers;
        this.instructionsToBytecodes = instructionsToBytecodes;
    }

    public Disassembler(MethodData data) throws NullPointerException {
        this(data.getInstructions(), data.getHandlers(), data.getInstructionsToBytecodes());
    }

    public void disassembleTo(String prefix, Writer w) throws IOException {
        int j = 0;
        while (j < this.instructions.length) {
            w.write(String.valueOf(prefix) + j + ": " + this.instructions[j] + " (" + this.instructionsToBytecodes[j] + ")\n");
            int k = 0;
            while (k < this.handlers[j].length) {
                w.write(String.valueOf(prefix) + "    Handles " + this.handlers[j][k].catchClass + " at " + this.handlers[j][k].handler + "\n");
                ++k;
            }
            ++j;
        }
    }

    public void disassembleTo(Writer w) throws IOException {
        this.disassembleTo("", w);
    }
}

