/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;

public class InterfaceAnalyzer {
    static final HashMap<String, TypeStats> typeStats = new HashMap();
    static int methodUID = 0;

    public static void main(String[] args) throws Exception {
        ClassInstrumenter ci;
        OfflineInstrumenter instrumenter = new OfflineInstrumenter();
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(System.out));
        args = instrumenter.parseStandardArgs(args);
        instrumenter.beginTraversal();
        while ((ci = instrumenter.nextClass()) != null) {
            InterfaceAnalyzer.doClass(ci.getReader());
        }
        instrumenter.close();
        w.write("Type\t# Total\t# Method\t# Public Method\t# Public Method as Foreign\n");
        for (String k : typeStats.keySet()) {
            TypeStats t = typeStats.get(k);
            w.write(String.valueOf(k) + "\t" + t.totalOccurrences + "\t" + t.methodOccurrences + "\t" + t.publicMethodOccurrences + "\t" + t.foreignPublicMethodOccurrences + "\n");
        }
        ((Writer)w).close();
    }

    private static void doClass(ClassReader reader) throws Exception {
        if ((reader.getAccessFlags() & 0x200) != 0 && (reader.getAccessFlags() & 1) != 0) {
            String cType = Util.makeType(reader.getName());
            int m = 0;
            while (m < reader.getMethodCount()) {
                int mUID;
                String sig = reader.getMethodType(m);
                String[] params = Util.getParamsTypes(null, sig);
                int flags = reader.getMethodAccessFlags(m);
                ++methodUID;
                int p = 0;
                while (p < params.length) {
                    InterfaceAnalyzer.doType(flags, params[p], cType, mUID);
                    ++p;
                }
                InterfaceAnalyzer.doType(flags, Util.getReturnType(sig), cType, mUID);
                ++m;
            }
        }
    }

    private static void doType(int flags, String type, String containerType, int mUID) {
        TypeStats t = typeStats.get(type);
        if (t == null) {
            t = new TypeStats();
            typeStats.put(type, t);
        }
        ++t.totalOccurrences;
        if (t.lastMUID != mUID) {
            ++t.methodOccurrences;
            if ((flags & 1) != 0) {
                ++t.publicMethodOccurrences;
                String elemType = type;
                while (Util.isArrayType(elemType)) {
                    elemType = elemType.substring(1);
                }
                if (!Util.isPrimitiveType(elemType) && !InterfaceAnalyzer.packagePart(elemType, 2).equals(InterfaceAnalyzer.packagePart(containerType, 2))) {
                    ++t.foreignPublicMethodOccurrences;
                }
            }
        }
        t.lastMUID = mUID;
    }

    private static String packagePart(String t, int count) {
        String c = Util.makeClass(t);
        int lastDot = -1;
        int i = 0;
        while (i < count) {
            int dot = c.indexOf(46, lastDot + 1);
            if (dot < 0) {
                return c;
            }
            lastDot = dot;
            ++i;
        }
        return c.substring(0, lastDot);
    }

    static final class TypeStats {
        int totalOccurrences;
        int methodOccurrences;
        int publicMethodOccurrences;
        int foreignPublicMethodOccurrences;
        int lastMUID;

        TypeStats() {
        }
    }
}

