/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.emfvm.ASM;
import org.eclipse.m2m.atl.engine.emfvm.Bytecode;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.HasFields;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMOperation
extends Operation {
    public static final int MAX_STACK = 100;
    private static WeakHashMap<Class<?>, Map<String, Method>> methodCache = new WeakHashMap();
    private String name;
    private String context;
    private List<String> parameters = new ArrayList<String>();
    private Bytecode[] bytecodes;
    private int nbBytecodes;
    private int nbNestedIterates;
    private List<LineNumberEntry> lineNumberTable = new ArrayList<LineNumberEntry>();
    private List<LocalVariableEntry> localVariableTable = new ArrayList<LocalVariableEntry>();
    private ASM asm;

    public ASMOperation(ASM asm, String name) {
        super(1);
        this.name = name;
        this.asm = asm;
    }

    @Override
    public int getMaxLocals() {
        return this.maxLocals;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public void addParameter(String parameterName, String type) {
        this.parameters.add(parameterName);
    }

    public void addLineNumberEntry(String id, int begin, int end) {
        this.lineNumberTable.add(new LineNumberEntry(id, begin, end));
    }

    public List<LineNumberEntry> getLineNumberTable() {
        return this.lineNumberTable;
    }

    public String resolveLineNumber(int l) {
        String ret = null;
        Iterator<LineNumberEntry> i = this.lineNumberTable.iterator();
        while (i.hasNext() && ret == null) {
            LineNumberEntry lne = i.next();
            if (l < lne.begin || l > lne.end) continue;
            ret = lne.id;
        }
        return ret;
    }

    public void addLocalVariableEntry(int slot, String variableName, int begin, int end) {
        this.localVariableTable.add(new LocalVariableEntry(slot, variableName, begin, end));
    }

    public List<LocalVariableEntry> getLocalVariableTable() {
        return this.localVariableTable;
    }

    public String resolveVariableName(int slot, int l) {
        String ret = null;
        Iterator<LocalVariableEntry> i = this.localVariableTable.iterator();
        while (i.hasNext() & ret == null) {
            LocalVariableEntry lve = i.next();
            if (slot != lve.slot || l < lve.begin || l > lve.end) continue;
            ret = lve.name;
        }
        return ret;
    }

    public void setBytecodes(Bytecode[] bytecodes) {
        this.bytecodes = bytecodes;
        this.nbBytecodes = bytecodes.length;
        this.maxLocals = this.parameters.size();
        Stack<Integer> stack = new Stack<Integer>();
        int i = 0;
        while (i < this.nbBytecodes) {
            Bytecode bytecode = bytecodes[i];
            if (bytecode.getOpcode() == 9) {
                bytecode.setValue2(stack.size());
                stack.push(new Integer(i));
                if (bytecode.getValue2() > this.nbNestedIterates) {
                    this.nbNestedIterates = bytecode.getValue2();
                }
            } else if (bytecode.getOpcode() == 10) {
                int iterateIndex = (Integer)stack.pop();
                bytecode.setValue(iterateIndex + 1);
                bytecode.setValue2(stack.size());
                bytecodes[iterateIndex].setValue(i + 1);
            } else if ((bytecode.getOpcode() == 6 || bytecode.getOpcode() == 7) && bytecode.getValue() > this.maxLocals) {
                this.maxLocals = bytecode.getValue();
            }
            ++i;
        }
        ++this.maxLocals;
        ++this.nbNestedIterates;
    }

    public Bytecode[] getBytecodes() {
        return this.bytecodes;
    }

    public String getName() {
        return this.name;
    }

    public Object exec(AbstractStackFrame frame, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new VMException(null, Messages.getString("ASMOperation.EXECUTION_CANCELED"));
        }
        ExecEnv execEnv = frame.getExecEnv();
        boolean debug = execEnv.isStep();
        Object[] localVars = frame.getLocalVars();
        int pc = 0;
        int fp = 0;
        Object[] stack = new Object[100];
        Iterator[] nestedIterate = new Iterator[this.nbNestedIterates];
        StringBuffer log = new StringBuffer();
        try {
            while (pc < this.nbBytecodes) {
                Bytecode bytecode = this.bytecodes[pc++];
                execEnv.incNbExecutedBytecodes();
                if (debug) {
                    ATLLogger.info((String)(String.valueOf(this.name) + ":" + (pc - 1) + "\t" + bytecode));
                }
                switch (bytecode.getOpcode()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        stack[fp++] = bytecode.getOperand();
                        break;
                    }
                    case 3: {
                        stack[fp++] = Boolean.TRUE;
                        break;
                    }
                    case 4: {
                        stack[fp++] = Boolean.FALSE;
                        break;
                    }
                    case 5: {
                        Object s;
                        Object self = stack[fp - bytecode.getValue() - 1];
                        if (debug) {
                            log.append("\tCalling ");
                            log.append(frame.getExecEnv().toPrettyPrintedString(self));
                            log.append(".");
                            log.append(bytecode.getOperand());
                            log.append("(");
                        }
                        Object type = execEnv.getModelAdapter().getType(self);
                        int nbCalleeArgs = bytecode.getValue();
                        Operation operation = execEnv.getOperation(type, bytecode.getOperand());
                        if (operation != null) {
                            StackFrame calleeFrame = (StackFrame)frame.newFrame(operation);
                            Object[] arguments = calleeFrame.getLocalVars();
                            if (nbCalleeArgs >= 1 && arguments.length < nbCalleeArgs + 1) {
                                throw new VMException(frame, Messages.getString("ASMOperation.WRONGNUMBERARGS", bytecode.getOperand()));
                            }
                            boolean first = true;
                            int i = nbCalleeArgs;
                            while (i >= 1) {
                                arguments[i] = stack[--fp];
                                if (debug) {
                                    if (!first) {
                                        log.append(", ");
                                    }
                                    first = false;
                                    log.append(execEnv.toPrettyPrintedString(arguments[i]));
                                }
                                --i;
                            }
                            if (debug) {
                                log.append(")");
                                ATLLogger.info((String)log.toString());
                            }
                            --fp;
                            arguments[0] = self;
                            s = operation instanceof ASMOperation ? ((ASMOperation)operation).exec(calleeFrame, monitor) : operation.exec(calleeFrame);
                        } else {
                            Assert.isTrue((boolean)(bytecode.getOperand() instanceof String));
                            Object[] arguments = new Object[nbCalleeArgs];
                            boolean first = true;
                            int i = nbCalleeArgs - 1;
                            while (i >= 0) {
                                arguments[i] = stack[--fp];
                                if (debug) {
                                    if (!first) {
                                        log.append(", ");
                                    }
                                    first = false;
                                    log.append(execEnv.toPrettyPrintedString(arguments[i]));
                                }
                                --i;
                            }
                            if (debug) {
                                log.append(")");
                                ATLLogger.info((String)log.toString());
                            }
                            --fp;
                            Method m = ASMOperation.findMethod(self.getClass(), (String)bytecode.getOperand(), ASMOperation.getTypesOf(arguments));
                            if (m == null) {
                                throw new VMException(frame, Messages.getString("ASMOperation.OPERATIONNOTFOUND", execEnv.toPrettyPrintedString(self), ASMOperation.getMethodSignature(bytecode.getOperand().toString(), ASMOperation.getTypesOf(arguments))));
                            }
                            s = execEnv.getModelAdapter().invoke(m, self, arguments);
                        }
                        if (s == null) break;
                        stack[fp++] = s;
                        break;
                    }
                    case 6: {
                        stack[fp++] = localVars[bytecode.getValue()];
                        break;
                    }
                    case 7: {
                        localVars[bytecode.getValue()] = stack[--fp];
                        break;
                    }
                    case 12: {
                        Object value = stack[--fp];
                        Object s = stack[--fp];
                        if (s instanceof HasFields) {
                            ((HasFields)s).set(frame, bytecode.getOperand(), value);
                            break;
                        }
                        if (value instanceof Collection) {
                            Collection c = (Collection)value;
                            boolean temp = true;
                            while (temp) {
                                temp = c.remove(OclUndefined.SINGLETON);
                            }
                        } else if (value instanceof OclUndefined) {
                            value = null;
                        }
                        execEnv.getModelAdapter().set(frame, s, (String)bytecode.getOperand(), value);
                        break;
                    }
                    case 13: {
                        Object s = stack[--fp];
                        Object type = execEnv.getModelAdapter().getType(s);
                        String propName = (String)bytecode.getOperand();
                        Operation ai = execEnv.getAttributeInitializer(type, propName);
                        if (ai != null) {
                            stack[fp++] = execEnv.getHelperValue(frame, type, s, propName);
                            break;
                        }
                        if (s instanceof HasFields) {
                            stack[fp++] = ((HasFields)s).get(frame, propName);
                            break;
                        }
                        stack[fp++] = execEnv.getModelAdapter().get(frame, s, propName);
                        break;
                    }
                    case 11: {
                        Object s = stack[fp - 1];
                        stack[fp++] = s;
                        break;
                    }
                    case 20: {
                        Object s = stack[fp - 1];
                        stack[fp++] = s;
                        stack[fp - 2] = stack[fp - 3];
                        stack[fp - 3] = stack[fp - 1];
                        break;
                    }
                    case 21: {
                        Object s = stack[--fp];
                        execEnv.getModelAdapter().delete(frame, s);
                        break;
                    }
                    case 15: {
                        stack[fp++] = frame.getAsmModule();
                        break;
                    }
                    case 8: {
                        Class<? extends Object> c;
                        Object mname = stack[--fp];
                        Object me = stack[--fp];
                        if (mname.equals("#native")) {
                            c = OclType.getNativeClassfromOclTypeName(me.toString());
                            if (c != null) {
                                stack[fp++] = c.newInstance();
                                break;
                            }
                            throw new VMException(frame, Messages.getString("ASMOperation.CANNOTCREATE", mname, me));
                        }
                        Object ec = ExecEnv.findMetaElement(frame, mname, me);
                        stack[fp++] = execEnv.newElement(frame, ec, mname.toString());
                        break;
                    }
                    case 19: {
                        Class<? extends Object> c;
                        Object mname = stack[--fp];
                        Object me = stack[--fp];
                        if (mname.equals("#native")) {
                            c = OclType.getNativeClassfromOclTypeName(me.toString());
                            if (c != null) {
                                stack[fp++] = c;
                                break;
                            }
                            throw new VMException(frame, Messages.getString("ASMOperation.CANNOTFIND", mname, me));
                        }
                        Object ec = ExecEnv.findMetaElement(frame, mname, me);
                        stack[fp++] = ec;
                        break;
                    }
                    case 9: {
                        Class<? extends Object> c = (Collection)stack[--fp];
                        Iterator it = c.iterator();
                        if (it.hasNext()) {
                            nestedIterate[bytecode.getValue2()] = it;
                            stack[fp++] = it.next();
                            break;
                        }
                        pc = bytecode.getValue();
                        break;
                    }
                    case 10: {
                        Iterator it = nestedIterate[bytecode.getValue2()];
                        if (!it.hasNext()) break;
                        stack[fp++] = it.next();
                        pc = bytecode.getValue();
                        break;
                    }
                    case 14: {
                        --fp;
                        break;
                    }
                    case 18: {
                        Object s = stack[fp - 1];
                        stack[fp - 1] = stack[fp - 2];
                        stack[fp - 2] = s;
                        break;
                    }
                    case 16: {
                        if (!Boolean.TRUE.equals(stack[--fp])) break;
                        pc = bytecode.getValue();
                        break;
                    }
                    case 17: {
                        pc = bytecode.getValue();
                        break;
                    }
                    default: {
                        throw new VMException(frame, Messages.getString("ASMOperation.UNKNOWNBYTECODE", new Integer(bytecode.getOpcode())));
                    }
                }
                if (!debug) continue;
                log = new StringBuffer();
                log.append("\tstack: ");
                int i = 0;
                while (i < fp) {
                    if (i > 0) {
                        log.append(", ");
                    }
                    log.append(frame.getExecEnv().toPrettyPrintedString(stack[i]));
                    ++i;
                }
                ATLLogger.info((String)log.toString());
                log = new StringBuffer();
                log.append("\tlocals: ");
                boolean first = true;
                int i2 = 0;
                while (i2 < localVars.length) {
                    String vname = this.resolveVariableName(i2, pc);
                    if (vname != null) {
                        if (!first) {
                            log.append(", ");
                        }
                        first = false;
                        log.append(String.valueOf(vname) + "=");
                        log.append(frame.getExecEnv().toPrettyPrintedString(localVars[i2]));
                    }
                    ++i2;
                }
                ATLLogger.info((String)log.toString());
            }
        }
        catch (VMException e) {
            ((StackFrame)frame).setPc(pc - 1);
            throw e;
        }
        catch (InstantiationException e) {
            ((StackFrame)frame).setPc(pc - 1);
            throw new VMException(frame, e.getLocalizedMessage(), e);
        }
        catch (IllegalAccessException e) {
            ((StackFrame)frame).setPc(pc - 1);
            throw new VMException(frame, e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException e) {
            ((StackFrame)frame).setPc(pc - 1);
            throw new VMException(frame, e.getLocalizedMessage(), e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ((StackFrame)frame).setPc(pc - 1);
            throw new VMException(frame, e.getLocalizedMessage(), e);
        }
        return fp > 0 ? stack[--fp] : null;
    }

    @Override
    public Object exec(AbstractStackFrame frame) {
        return this.exec(frame, null);
    }

    public ASM getAsm() {
        return this.asm;
    }

    private static Class<?>[] getTypesOf(Object[] arguments) {
        Class[] argumentTypes = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argumentTypes[i] = arguments[i].getClass();
            ++i;
        }
        return argumentTypes;
    }

    protected static Method findMethod(Class<?> caller, String name, Class<?>[] argumentTypes) {
        String sig = ASMOperation.getMethodSignature(name, argumentTypes);
        Method ret = ASMOperation.findCachedMethod(caller, sig);
        if (ret != null) {
            return ret;
        }
        Method[] methods = caller.getDeclaredMethods();
        int i = 0;
        while (i < methods.length && ret == null) {
            Class<?>[] pts;
            Method method = methods[i];
            if (method.getName().equals(name) && (pts = method.getParameterTypes()).length == argumentTypes.length) {
                boolean ok = true;
                int j = 0;
                while (j < pts.length && ok) {
                    if (!(pts[j].isAssignableFrom(argumentTypes[j]) || pts[j] == Boolean.TYPE && argumentTypes[j] == Boolean.class || pts[j] == Integer.TYPE && argumentTypes[j] == Integer.class || pts[j] == Character.TYPE && argumentTypes[j] == Character.class || pts[j] == Long.TYPE && argumentTypes[j] == Long.class || pts[j] == Float.TYPE && argumentTypes[j] == Float.class || pts[j] == Double.TYPE && argumentTypes[j] == Double.class)) {
                        ok = false;
                    }
                    ++j;
                }
                if (ok) {
                    ret = method;
                }
            }
            ++i;
        }
        if (ret == null && caller.getSuperclass() != null) {
            ret = ASMOperation.findMethod(caller.getSuperclass(), name, argumentTypes);
        }
        ASMOperation.cacheMethod(caller, sig, ret);
        return ret;
    }

    private static Method findCachedMethod(Class<?> caller, String signature) {
        Method ret = null;
        Map<String, Method> sigMap = methodCache.get(caller);
        if (sigMap != null) {
            ret = sigMap.get(signature);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheMethod(Class<?> caller, String signature, Method method) {
        WeakHashMap<Class<?>, Map<String, Method>> weakHashMap = methodCache;
        synchronized (weakHashMap) {
            Map<String, Method> sigMap = methodCache.get(caller);
            if (sigMap == null) {
                sigMap = new HashMap<String, Method>();
                methodCache.put(caller, sigMap);
            }
            sigMap.put(signature, method);
        }
    }

    private static String getMethodSignature(String name, Class<?>[] argumentTypes) {
        StringBuffer sig = new StringBuffer();
        sig.append(name);
        sig.append('(');
        int i = 0;
        while (i < argumentTypes.length) {
            if (i > 0) {
                sig.append(',');
            }
            sig.append(argumentTypes[i].getName());
            ++i;
        }
        sig.append(')');
        return sig.toString();
    }

    public String toString() {
        return String.valueOf(this.context) + "." + this.name;
    }

    private final class LineNumberEntry {
        private String id;
        private int begin;
        private int end;

        private LineNumberEntry(String id, int begin, int end) {
            this.id = id;
            this.begin = begin;
            this.end = end;
        }
    }

    private final class LocalVariableEntry {
        private int slot;
        private String name;
        private int begin;
        private int end;

        private LocalVariableEntry(int slot, String name, int begin, int end) {
            this.slot = slot;
            this.name = name;
            this.begin = begin;
            this.end = end;
        }
    }
}

