/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.service.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.tcs.extractor.TCSExtractor;
import org.eclipse.gmt.tcs.injector.TCSInjector;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModelElement;
import org.eclipse.m2m.atl.engine.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.MarkerMaker;
import org.eclipse.m2m.atl.engine.extractors.xml.XMLExtractor;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.service.core.JarClassLoader;
import org.eclipse.m2m.atl.service.core.ServiceMessages;
import org.eclipse.m2m.atl.service.core.exception.ServiceException;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ServiceTransformationUtil {
    public static final String XMLExtractor = "XML";
    public static final String XMIExtractor = "XMI";
    public static final String EBNFExtractor = "EBNF";

    public static URL getURLFromASMFile(String filePath, String pluginId) throws ServiceException {
        URL tPlatform = Platform.getBundle((String)pluginId).getEntry(filePath);
        try {
            return FileLocator.toFileURL((URL)tPlatform);
        }
        catch (IOException e) {
            throw new ServiceException(8, e);
        }
    }

    public static ASMModel loadModel(AtlModelHandler amh, String modelName, ASMModel metamodel, String path, String nsUri, boolean isM3, boolean inWorkspace, String pluginId) throws ServiceException {
        ASMModel ret = null;
        if (amh instanceof AtlEMFModelHandler) {
            if (isM3) {
                ret = amh.getMof();
            } else if (nsUri != null && !nsUri.equals("")) {
                ret = ((AtlEMFModelHandler)amh).loadModel(modelName, metamodel, "uri:" + nsUri);
            } else if (inWorkspace) {
                ret = ((AtlEMFModelHandler)amh).loadModel(modelName, metamodel, URI.createPlatformResourceURI((String)path));
            } else {
                try {
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    if (bundle == null) {
                        throw new ServiceException(4, ServiceMessages.getString("ServiceTransformationUtil.0", new Object[]{pluginId}));
                    }
                    URL urlFile = bundle.getEntry(path);
                    if (urlFile == null) {
                        throw new ServiceException(4, ServiceMessages.getString("ServiceTransformationUtil.1", new Object[]{path, pluginId}));
                    }
                    InputStream in = urlFile.openStream();
                    ret = ((AtlEMFModelHandler)amh).loadModel(modelName, metamodel, in);
                }
                catch (IOException e) {
                    throw new ServiceException(4, e);
                }
            }
        } else {
            throw new ServiceException(8, ServiceMessages.getString("ServiceTransformationUtil.2"));
        }
        return ret;
    }

    public static void xmlExtraction(final ASMModel model, String path, AtlModelHandler amh) {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            PipedInputStream in = new PipedInputStream();
            final PipedOutputStream out = new PipedOutputStream(in);
            final Map parameters = Collections.EMPTY_MAP;
            final XMLExtractor xmle = new XMLExtractor();
            new Thread(){

                public void run() {
                    block11: {
                        try {
                            try {
                                xmle.extract(model, out, parameters);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }.start();
            if (file.exists()) {
                file.setContents((InputStream)in, 1, null);
            } else {
                file.create((InputStream)in, 1, null);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void ebnfExtraction(final ASMModel model, String path, AtlModelHandler amh, Map params) {
        try {
            PipedInputStream in = new PipedInputStream();
            final PipedOutputStream out = new PipedOutputStream(in);
            final TCSExtractor ebnfe = new TCSExtractor();
            ASMModel TCS = ServiceTransformationUtil.loadModel(AtlModelHandler.getDefault((String)"EMF"), "TCS", AtlModelHandler.getDefault((String)"EMF").getMof(), "resources/TCS.ecore", null, false, false, "org.eclipse.m2m.atl.service.core");
            HashMap<String, Object> tempParam = new HashMap<String, Object>();
            tempParam.put("format", ServiceTransformationUtil.loadModel(amh, "model.tcs", TCS, (String)params.get("path"), null, false, false, (String)params.get("pluginId")));
            for (String paramName : params.keySet()) {
                String paramType = (String)ebnfe.getParameterTypes().get(paramName);
                if (paramType == null || !paramType.equals("String")) continue;
                tempParam.put(paramName, params.get(paramName));
            }
            final HashMap<String, Object> parameters = tempParam;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            new Thread(){

                public void run() {
                    block11: {
                        try {
                            try {
                                ebnfe.extract(model, out, parameters);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }.start();
            if (file.exists()) {
                file.setContents((InputStream)in, 1, null);
            } else {
                file.create((InputStream)in, 1, null);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static ASMModel ebnfInjection(String name, String filePath, AtlModelHandler amh, ASMModel metamodel, Map params, String parserPath, String metamodelName, String pluginId) {
        try {
            InputStream in = Platform.getBundle((String)pluginId).getEntry(filePath).openStream();
            ASMModel model = amh.newModel(name, metamodel);
            TCSInjector ebnfi = new TCSInjector();
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            JarClassLoader loader = ServiceTransformationUtil.createLoader(pluginId, parserPath, oldCl);
            Class lexer = loader.loadClass2("org.eclipse.gmt.tcs.injector." + metamodelName + "Lexer", true);
            Class parser = loader.loadClass2("org.eclipse.gmt.tcs.injector." + metamodelName + "Parser", true);
            ebnfi.performImportation(metamodel, model, in, metamodelName, lexer, parser);
            in.close();
            return model;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            System.err.println(e1);
        }
        return null;
    }

    private static JarClassLoader createLoader(String pluginId, String parserPath, ClassLoader parent) {
        try {
            URL url = Platform.getBundle((String)pluginId).getEntry("/");
            String urlString = url.toString();
            LinkedList<URL> list = new LinkedList<URL>();
            String requires = (String)Platform.getBundle((String)pluginId).getHeaders().get("Bundle-ClassPath");
            if (requires == null) {
                requires = parserPath;
            } else if (requires.indexOf(parserPath) == -1) {
                requires = String.valueOf(requires) + "," + parserPath;
            }
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires);
            int i = 0;
            while (i < elements.length) {
                ManifestElement element = elements[i];
                String libPathStr = element.getValue();
                String libUrlStr = String.valueOf(urlString) + libPathStr;
                URL libUrl = new URL(libUrlStr);
                list.add(libUrl);
                ++i;
            }
            URL[] libUrls = list.toArray(new URL[list.size()]);
            return new JarClassLoader(libUrls, parent);
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        return null;
    }

    public static int applyMarkers(String path, ASMModel pbs) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        MarkerMaker markerMaker = new MarkerMaker();
        int nbErrors = 0;
        Set pbsc = pbs.getElementsByType("Problem");
        EObject[] pbsa = new EObject[pbsc.size()];
        int k = 0;
        for (ASMEMFModelElement ame : pbsc) {
            pbsa[k] = ame.getObject();
            if ("error".equals(((ASMEnumLiteral)ame.get(null, "severity")).getName())) {
                ++nbErrors;
            }
            ++k;
        }
        markerMaker.resetPbmMarkers((IResource)file, pbsa);
        return nbErrors;
    }
}

