/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.engine.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.emfvm.lib.Model;

public class ReferenceModel
extends Model {
    private Map metaElementByName = null;
    private static ReferenceModel metametamodel;

    public void dispose() {
        this.metaElementByName = null;
        super.dispose();
    }

    public ReferenceModel(ReferenceModel referenceModel, URL url) throws IOException {
        super(referenceModel, url);
        this.adapt();
    }

    public ReferenceModel(ReferenceModel referenceModel, URI uri) throws IOException {
        super(referenceModel, uri, false);
        this.adapt();
    }

    public ReferenceModel(ReferenceModel referenceModel, Resource resource) {
        super(referenceModel, resource);
        this.registerPackages();
    }

    public ReferenceModel(ReferenceModel referenceModel, String uri) {
        super(referenceModel, AtlEMFModelHandler.getResourceSet().getPackageRegistry().getEPackage(uri).eResource());
        this.registerPackages();
    }

    private void registerPackages() {
        for (EPackage p : this.getElementsByType(EcorePackage.eINSTANCE.getEPackage())) {
            String nsURI = p.getNsURI();
            resourceSet.getPackageRegistry().put((Object)nsURI, (Object)p);
        }
    }

    private void adapt() {
        for (EPackage p : this.getElementsByType(EcorePackage.eINSTANCE.getEPackage())) {
            String nsURI = p.getNsURI();
            if (nsURI == null) {
                nsURI = p.getName();
                p.setNsURI(nsURI);
            }
            if (resourceSet.getPackageRegistry().containsKey((Object)nsURI)) {
                p.equals(resourceSet.getPackageRegistry().getEPackage(nsURI));
            }
            resourceSet.getPackageRegistry().put((Object)nsURI, (Object)p);
        }
        for (EDataType dt : this.getElementsByType(EcorePackage.eINSTANCE.getEDataType())) {
            String tname = dt.getName();
            String icn = null;
            if (tname.equals("Boolean")) {
                icn = "boolean";
            } else if (tname.equals("Double")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            dt.setInstanceClassName(icn);
        }
    }

    private ReferenceModel(Resource resource) {
        super(resource);
    }

    public EClass getMetaElementByName(String name) {
        if (this.metaElementByName == null) {
            this.metaElementByName = new HashMap();
            for (EClass metaElement : this.getElementsByType(EcorePackage.eINSTANCE.getEClass())) {
                this.metaElementByName.put(metaElement.getName(), metaElement);
                String completeName = String.valueOf(this.getCompletePackageName(metaElement.getEPackage())) + "::" + metaElement.getName();
                this.metaElementByName.put(completeName, metaElement);
            }
        }
        return (EClass)this.metaElementByName.get(name);
    }

    private String getCompletePackageName(EPackage p) {
        String fullPackageName = "";
        EPackage parent = p.getESuperPackage();
        fullPackageName = parent != null ? String.valueOf(fullPackageName) + this.getCompletePackageName(parent) + "::" + p.getName() : p.getName();
        return fullPackageName;
    }

    public static ReferenceModel getMetametamodel() {
        if (metametamodel == null) {
            metametamodel = new ReferenceModel(EcorePackage.eINSTANCE.eResource());
        }
        return metametamodel;
    }
}

