/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.adt.debug.core.AtlRunTarget;
import org.eclipse.m2m.atl.adt.launching.AtlLauncherTools;
import org.eclipse.m2m.atl.adt.launching.AtlVM;
import org.eclipse.m2m.atl.adt.launching.sourcelookup.AtlSourceLocator;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.emfvm.ASM;
import org.eclipse.m2m.atl.engine.emfvm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.emfvm.lib.Model;
import org.eclipse.m2m.atl.engine.emfvm.lib.ReferenceModel;
import org.eclipse.m2m.atl.engine.emfvm.lib.VMException;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlEMFSpecificVM
extends AtlVM {
    public Object launch(URL asmUrl, Map libs, Map models, Map params, List superimps, Map options) {
        ASMModel m;
        Object ret = null;
        HashMap<String, Model> actualModels = new HashMap<String, Model>();
        ArrayList<Model> targetModels = new ArrayList<Model>();
        HashMap<ASMModel, ReferenceModel> referenceModelOfASMModel = new HashMap<ASMModel, ReferenceModel>();
        for (String mName : models.keySet()) {
            ReferenceModel rm;
            m = (ASMModel)models.get(mName);
            if (m.equals(ASMEMFModel.getMOF())) {
                rm = ReferenceModel.getMetametamodel();
            } else {
                if (!m.getMetamodel().equals(ASMEMFModel.getMOF())) continue;
                rm = new ReferenceModel(ReferenceModel.getMetametamodel(), ((ASMEMFModel)m).getExtent());
                referenceModelOfASMModel.put(m, rm);
            }
            actualModels.put(mName, rm);
            if (!m.isTarget()) continue;
            targetModels.add(rm);
        }
        for (String mName : models.keySet()) {
            m = (ASMModel)models.get(mName);
            if (m.getMetamodel().equals(ASMEMFModel.getMOF())) continue;
            ASMModel mm = m.getMetamodel();
            ReferenceModel rm = (ReferenceModel)referenceModelOfASMModel.get(mm);
            Model actualM = new Model(rm, ((ASMEMFModel)m).getExtent());
            actualModels.put(mName, actualM);
            if (!m.isTarget()) continue;
            targetModels.add(actualM);
            actualM.isTarget = true;
        }
        try {
            ASM asm = new ASMXMLReader().read(asmUrl.openStream());
            for (String libName : libs.keySet()) {
                URL libUrl = (URL)libs.get(libName);
                ASM lib = new ASMXMLReader().read(libUrl.openStream());
                libs.put(libName, lib);
            }
            try {
                ret = asm.run(actualModels, libs, options);
            }
            catch (VMException vme) {
                vme.printStackTrace(System.out);
                throw vme;
            }
            for (Model model : targetModels) {
                model.commitToResource();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ret;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        launch.setSourceLocator((ISourceLocator)new AtlSourceLocator());
        AtlRunTarget mTarget = new AtlRunTarget(launch);
        launch.addDebugTarget((IDebugTarget)mTarget);
        this.actualLaunch(configuration, mode, launch, monitor);
        mTarget.terminate();
    }

    /*
     * Unable to fully structure code
     */
    private void actualLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        fileName = configuration.getAttribute("ATL File Name", "<null>");
        currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fileName));
        extension = currentAtlFile.getFileExtension().toLowerCase();
        if (AtlLauncherTools.EXTENSIONS.contains(extension)) {
            currentAsmPath = String.valueOf(currentAtlFile.getFullPath().toString().substring(0, currentAtlFile.getFullPath().toString().length() - extension.length())) + "asm";
            currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(currentAsmPath));
        } else {
            currentAtlFile = null;
        }
        asm = new ASMXMLReader().read(currentAtlFile.getContents());
        models = new HashMap<String, Model>();
        sourceModels = configuration.getAttribute("Input", new HashMap<K, V>());
        targetModels = configuration.getAttribute("Output", new HashMap<K, V>());
        modelPaths = configuration.getAttribute("Path", new HashMap<K, V>());
        libs = configuration.getAttribute("Libs", new HashMap<K, V>());
        try {
            for (String mName : sourceModels.keySet()) {
                mmName = (String)sourceModels.get(mName);
                mm = (ReferenceModel)models.get(mmName);
                if (mm == null) {
                    mm = this.loadReferenceModel(mmName, modelPaths);
                    models.put(mmName, mm);
                }
                m = new Model(mm, URI.createPlatformResourceURI((String)((String)modelPaths.get(mName)), (boolean)true), false);
                models.put(mName, m);
            }
            for (String mName : targetModels.keySet()) {
                mmName = (String)targetModels.get(mName);
                mm = (ReferenceModel)models.get(mmName);
                if (mm == null) {
                    mm = this.loadReferenceModel(mmName, modelPaths);
                    models.put(mmName, mm);
                }
                m = new Model(mm, URI.createPlatformResourceURI((String)((String)modelPaths.get(mName)), (boolean)true), true);
                models.put(mName, m);
                m.isTarget = true;
            }
            try {
                try {
                    options = new HashMap<String, String>();
                    i = 0;
                    while (i < AtlLauncherTools.additionalParamIds.length) {
                        value = configuration.getAttribute(AtlLauncherTools.additionalParamIds[i], false);
                        options.put(AtlLauncherTools.additionalParamIds[i], value != false ? "true" : "false");
                        ++i;
                    }
                    libraries = new HashMap<String, ASM>();
                    for (String libName : libs.keySet()) {
                        libFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)((String)libs.get(libName))));
                        lib = new ASMXMLReader().read(libFile.getContents());
                        libraries.put(libName, lib);
                    }
                    asm.run(models, libraries, options);
                    for (String mName : targetModels.keySet()) {
                        m = (Model)models.get(mName);
                        m.save(URI.createPlatformResourceURI((String)((String)modelPaths.get(mName)), (boolean)true));
                    }
                }
                catch (VMException vme) {
                    vme.printStackTrace(System.out);
                    throw vme;
                }
            }
            finally {
                ** for (model : models.values())
            }
lbl-1000:
            // 1 sources

            {
                model.dispose();
                continue;
lbl70:
                // 1 sources

            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    private ReferenceModel loadReferenceModel(String mmName, Map modelPaths) throws IOException {
        ReferenceModel ret = null;
        String path = (String)modelPaths.get(mmName);
        ret = path.startsWith("#") ? ReferenceModel.getMetametamodel() : (path.startsWith("uri:") ? new ReferenceModel(ReferenceModel.getMetametamodel(), path.substring(4)) : new ReferenceModel(ReferenceModel.getMetametamodel(), URI.createPlatformResourceURI((String)path, (boolean)true)));
        return ret;
    }
}

