/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.exception;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lyo.client.exception.FixMessageFormat;

public class MessageExtractor {
    private static final String CLASS = MessageExtractor.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final String BUNDLE_NAME = "oslc4jclient";
    private static ResourceBundle bundle = null;

    private MessageExtractor() {
    }

    private static synchronized ResourceBundle getMessageBundle(Locale locale) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }
        return bundle;
    }

    private static String getString(Locale locale, String key, Object[] args) {
        ResourceBundle messages = MessageExtractor.getMessageBundle(locale);
        if (messages != null) {
            try {
                String message = messages.getString(key);
                return MessageExtractor.formatMessage(locale, message, args);
            }
            catch (MissingResourceException missingResourceException) {
                logger.log(Level.SEVERE, missingResourceException.getMessage(), missingResourceException);
                return "???" + key + "???";
            }
        }
        logger.log(Level.SEVERE, "missing resource: " + key);
        return "???" + key + "???";
    }

    private static String formatMessage(Locale locale, String message, Object[] args) {
        String fixedMessage = FixMessageFormat.fixPattern(message);
        return new MessageFormat(fixedMessage, locale).format(args);
    }

    public static String getMessage(Locale locale, String key, Object[] params) {
        return MessageExtractor.getString(locale, key, params);
    }

    public static String getMessage(Locale locale, String key) {
        return MessageExtractor.getMessage(locale, key, null);
    }

    public static String getMessage(String key) {
        return MessageExtractor.getMessage(key, null);
    }

    public static String getMessage(String key, Object[] params) {
        return MessageExtractor.getMessage(Locale.getDefault(), key, params);
    }
}

