/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime.converter.full;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileProjectRuntime;
import org.eclipse.lsp4mp.commons.runtime.converter.AbstractConverterRuntimeSupport;
import org.eclipse.lsp4mp.commons.runtime.converter.ConverterValidator;
import org.eclipse.lsp4mp.commons.runtime.converter.full.FullConverterValidator;

public class FullConverterRuntimeSupport
extends AbstractConverterRuntimeSupport<Object> {
    private static final Logger LOGGER = Logger.getLogger(FullConverterRuntimeSupport.class.getName());
    private static final String[] DEFAULT_RESOLVERS = new String[]{"io.smallrye.config.SmallRyeConfigProviderResolver"};

    public FullConverterRuntimeSupport(MicroProfileProjectRuntime project) {
        super(project, ExecutionMode.FULL);
    }

    @Override
    protected Object loadConfig() {
        Object resolver = this.loadConfigProviderResolverReflect();
        if (resolver != null) {
            try {
                Method getBuilder = resolver.getClass().getMethod("getBuilder", new Class[0]);
                Object builder = getBuilder.invoke(resolver, new Object[0]);
                builder.getClass().getMethod("forClassLoader", ClassLoader.class).invoke(builder, this.getProject().getRuntimeClassLoader());
                builder.getClass().getMethod("addDiscoveredConverters", new Class[0]).invoke(builder, new Object[0]);
                return builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (Throwable e) {
                LOGGER.log(Level.INFO, "Error creating MicroProfile Config via reflection from " + resolver.getClass().getName(), e);
            }
        }
        return null;
    }

    @Override
    protected ConverterValidator newConverter(Object config, Class<?> type) {
        return new FullConverterValidator(config, type);
    }

    private Object loadConfigProviderResolverReflect() {
        ClassLoader runtimeCL = this.getProject().getRuntimeClassLoader();
        if (runtimeCL == null) {
            return null;
        }
        ArrayList<Object> resolvers = new ArrayList<Object>();
        String[] stringArray = DEFAULT_RESOLVERS;
        int n = DEFAULT_RESOLVERS.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            try {
                Class<?> cls = Class.forName(className, false, runtimeCL);
                resolvers.add(cls.getConstructor(new Class[0]).newInstance(new Object[0]));
                LOGGER.info("Loaded ConfigProviderResolver: " + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "Cannot instantiate ConfigProviderResolver: " + className, t);
            }
            ++n2;
        }
        if (resolvers.isEmpty()) {
            try {
                Class<?> resolverClass = Class.forName("org.eclipse.microprofile.config.spi.ConfigProviderResolver", true, runtimeCL);
                ServiceLoader loader = ServiceLoader.load(resolverClass, runtimeCL);
                for (Object provider : loader) {
                    resolvers.add(provider);
                    LOGGER.info("Loaded ConfigProviderResolver via ServiceLoader: " + provider.getClass().getName());
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "ServiceLoader scan failed for ConfigProviderResolver", t);
            }
        }
        if (resolvers.isEmpty()) {
            LOGGER.warning("No ConfigProviderResolver found in project classpath");
            return null;
        }
        return resolvers.get(0);
    }
}

