/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ProjectClassLoader
extends ClassLoader {
    private final ClassLoader jarClassLoader;
    private final List<Path> classesDirectories;
    private final Map<String, Class<?>> projectClassCache = new ConcurrentHashMap();

    public ProjectClassLoader(Set<String> classpath, ClassLoader parent) {
        super(parent);
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        ArrayList<Path> dirPaths = new ArrayList<Path>();
        for (String entry : classpath) {
            try {
                Path path = Paths.get(entry, new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    dirPaths.add(path);
                    continue;
                }
                jarUrls.add(path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.jarClassLoader = new URLClassLoader(jarUrls.toArray(new URL[0]), null);
        this.classesDirectories = dirPaths;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cached = this.projectClassCache.get(name);
        if (cached != null) {
            if (resolve) {
                this.resolveClass(cached);
            }
            return cached;
        }
        try {
            Class<?> cls = this.findClass(name);
            if (resolve) {
                this.resolveClass(cls);
            }
            return cls;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> cls = this.jarClassLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(cls);
                }
                this.projectClassCache.put(name, cls);
                return cls;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return super.loadClass(name, resolve);
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cached = this.projectClassCache.get(name);
        if (cached != null) {
            return cached;
        }
        String relPath = name.replace('.', '/') + ".class";
        for (Path dir : this.classesDirectories) {
            Path classFile = dir.resolve(relPath);
            if (!Files.exists(classFile, new LinkOption[0])) continue;
            try {
                byte[] bytes = Files.readAllBytes(classFile);
                Class<?> cls = this.defineClass(name, bytes, 0, bytes.length);
                this.projectClassCache.put(name, cls);
                return cls;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read class file: " + String.valueOf(classFile), e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    public void clearProjectClassCache() {
        this.projectClassCache.clear();
    }

    public URL[] getJarURLs() {
        if (this.jarClassLoader instanceof URLClassLoader) {
            return ((URLClassLoader)this.jarClassLoader).getURLs();
        }
        return new URL[0];
    }
}

