/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.format;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class DocumentFormatOnTypeAutoEditStrategy
implements IAutoEditStrategy {
    public void customizeDocumentCommand(@Nullable IDocument document, @Nullable DocumentCommand command) {
        if (document == null || command == null || command.getCommandCount() > 1 || command.text.isEmpty()) {
            return;
        }
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(capabilities -> Either.forLeft((Object)(capabilities.getDocumentOnTypeFormattingProvider() != null && (documentCommand.text.equals(capabilities.getDocumentOnTypeFormattingProvider().getFirstTriggerCharacter()) || capabilities.getDocumentOnTypeFormattingProvider().getMoreTriggerCharacter() != null && capabilities.getDocumentOnTypeFormattingProvider().getMoreTriggerCharacter().contains(documentCommand.text)) ? 1 : 0)));
        if (!executor.anyMatching()) {
            return;
        }
        FormattingOptions formattingOptions = LSPFormatter.getFormatOptions();
        TextDocumentIdentifier textDocumentIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(document);
        if (textDocumentIdentifier == null) {
            return;
        }
        try {
            DocumentOnTypeFormattingParams params = new DocumentOnTypeFormattingParams(textDocumentIdentifier, formattingOptions, LSPEclipseUtils.toPosition(command.offset, document), command.text);
            executor.computeFirst(ls -> ls.getTextDocumentService().onTypeFormatting(params)).join().ifPresent(edits -> edits.forEach(edit -> {
                try {
                    int fromOffset = LSPEclipseUtils.toOffset(edit.getRange().getStart(), document);
                    int toOffset = LSPEclipseUtils.toOffset(edit.getRange().getEnd(), document);
                    if (fromOffset == documentCommand.offset) {
                        documentCommand.text = String.valueOf(documentCommand.text) + edit.getNewText();
                    } else {
                        command.addCommand(fromOffset, toOffset - fromOffset, edit.getNewText(), null);
                    }
                }
                catch (BadLocationException ex) {
                    LanguageServerPlugin.logError(ex);
                }
            }));
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }
}

