/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnection.raw.mqtt.cloud;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraDisconnectException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraNotConnectedException;
import org.eclipse.kura.cloud.CloudConnectionEstablishedEvent;
import org.eclipse.kura.cloud.CloudConnectionLostEvent;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.listener.CloudDeliveryListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.raw.mqtt.publisher.PublishOptions;
import org.eclipse.kura.cloudconnection.raw.mqtt.subscriber.SubscribeOptions;
import org.eclipse.kura.cloudconnection.subscriber.listener.CloudSubscriberListener;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.Utils;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.util.MqttTopicUtil;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.listener.DataServiceListener;
import org.eclipse.kura.message.KuraPayload;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMqttCloudEndpoint
implements CloudEndpoint,
CloudConnectionManager,
DataServiceListener,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(RawMqttCloudEndpoint.class);
    private DataService dataService;
    private EventAdmin eventAdmin;
    private ComponentContext componentContext;
    private final Set<CloudDeliveryListener> cloudDeliveryListeners = new CopyOnWriteArraySet<CloudDeliveryListener>();
    private final Set<CloudConnectionListener> cloudConnectionListeners = new CopyOnWriteArraySet<CloudConnectionListener>();
    private final Map<SubscribeOptions, Set<CloudSubscriberListener>> subscribers = new ConcurrentHashMap<SubscribeOptions, Set<CloudSubscriberListener>>();

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public void unsetDataService(DataService dataService) {
        this.dataService = null;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    public void activated(ComponentContext componentContext) {
        logger.info("activating...");
        this.componentContext = componentContext;
        this.dataService.addDataServiceListener((DataServiceListener)this);
        if (this.dataService.isConnected()) {
            this.onConnectionEstablished();
        }
        logger.info("activating...done");
    }

    public void updated() {
        logger.info("updating...");
        logger.info("updating...done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivated() {
        logger.info("deactivating...");
        this.dataService.removeDataServiceListener((DataServiceListener)this);
        RawMqttCloudEndpoint rawMqttCloudEndpoint = this;
        synchronized (rawMqttCloudEndpoint) {
            this.subscribers.keySet().forEach(this::unsubscribe);
        }
        logger.info("deactivating...done");
    }

    public void connect() throws KuraConnectException {
        this.dataService.connect();
    }

    public void disconnect() throws KuraDisconnectException {
        this.dataService.disconnect(10L);
    }

    public boolean isConnected() {
        return this.dataService.isConnected();
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.add(cloudConnectionListener);
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.remove(cloudConnectionListener);
    }

    public String publish(KuraMessage message) throws KuraException {
        return this.publish(new PublishOptions(message.getProperties()), message.getPayload());
    }

    public String publish(PublishOptions options, KuraPayload kuraPayload) throws KuraException {
        byte[] body = kuraPayload.getBody();
        if (body == null) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Missing message body in received payload."});
        }
        int qos = options.getQos().getValue();
        int id = this.dataService.publish(options.getTopic(), body, qos, options.getRetain(), options.getPriority());
        if (qos == 0) {
            return null;
        }
        return Integer.toString(id);
    }

    public synchronized void registerSubscriber(Map<String, Object> subscriptionProperties, CloudSubscriberListener cloudSubscriberListener) {
        SubscribeOptions subscribeOptions;
        try {
            subscribeOptions = new SubscribeOptions(subscriptionProperties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.registerSubscriber(subscribeOptions, cloudSubscriberListener);
    }

    public synchronized void registerSubscriber(SubscribeOptions subscribeOptions, CloudSubscriberListener cloudSubscriberListener) {
        Set listeners = this.subscribers.computeIfAbsent(subscribeOptions, e -> new CopyOnWriteArraySet());
        listeners.add(cloudSubscriberListener);
        this.subscribe(subscribeOptions);
    }

    public synchronized void unregisterSubscriber(CloudSubscriberListener cloudSubscriberListener) {
        HashSet toUnsubscribe = new HashSet();
        this.subscribers.entrySet().removeIf(e -> {
            Set listeners = (Set)e.getValue();
            listeners.remove(cloudSubscriberListener);
            if (listeners.isEmpty()) {
                toUnsubscribe.add((SubscribeOptions)e.getKey());
                return true;
            }
            return false;
        });
        toUnsubscribe.forEach(this::unsubscribe);
    }

    public void registerCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.add(cloudDeliveryListener);
    }

    public void unregisterCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.remove(cloudDeliveryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionEstablished() {
        this.cloudConnectionListeners.forEach(Utils.catchAll(CloudConnectionListener::onConnectionEstablished));
        RawMqttCloudEndpoint rawMqttCloudEndpoint = this;
        synchronized (rawMqttCloudEndpoint) {
            this.subscribers.keySet().forEach(this::subscribe);
        }
        this.postConnectionStateChangeEvent(true);
    }

    public void onDisconnecting() {
    }

    public void onDisconnected() {
        this.cloudConnectionListeners.forEach(Utils.catchAll(CloudConnectionListener::onDisconnected));
        this.postConnectionStateChangeEvent(false);
    }

    public void onConnectionLost(Throwable cause) {
        this.cloudConnectionListeners.forEach(Utils.catchAll(CloudConnectionListener::onConnectionLost));
        this.postConnectionStateChangeEvent(false);
    }

    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        logger.info("message arrived on topic {}", (Object)topic);
        KuraPayload kuraPayload = new KuraPayload();
        kuraPayload.setBody(payload);
        Map<String, String> messagePropertes = Collections.singletonMap("topic", topic);
        KuraMessage message = new KuraMessage(kuraPayload, messagePropertes);
        for (Map.Entry<SubscribeOptions, Set<CloudSubscriberListener>> e : this.subscribers.entrySet()) {
            if (!MqttTopicUtil.isMatched((String)e.getKey().getTopicFilter(), (String)topic)) continue;
            e.getValue().forEach(Utils.catchAll(l -> l.onMessageArrived(message)));
        }
    }

    public void onMessagePublished(int messageId, String topic) {
    }

    public void onMessageConfirmed(int messageId, String topic) {
        this.cloudDeliveryListeners.forEach(Utils.catchAll(l -> l.onMessageConfirmed(Integer.toString(messageId))));
    }

    private void postConnectionStateChangeEvent(boolean isConnected) {
        Map<String, String> eventProperties = Collections.singletonMap("cloud.service.pid", (String)this.componentContext.getProperties().get("kura.service.pid"));
        CloudConnectionEstablishedEvent event = isConnected ? new CloudConnectionEstablishedEvent(eventProperties) : new CloudConnectionLostEvent(eventProperties);
        this.eventAdmin.postEvent((Event)event);
    }

    private void subscribe(SubscribeOptions options) {
        try {
            String topicFilter = options.getTopicFilter();
            int qos = options.getQos().getValue();
            logger.info("subscribing to {} with qos {}", (Object)topicFilter, (Object)qos);
            this.dataService.subscribe(topicFilter, qos);
        }
        catch (KuraNotConnectedException kuraNotConnectedException) {
            logger.debug("failed to subscribe, DataService not connected");
        }
        catch (Exception e) {
            logger.warn("failed to subscribe", (Throwable)e);
        }
    }

    private void unsubscribe(SubscribeOptions options) {
        try {
            String topicFilter = options.getTopicFilter();
            logger.info("unsubscribing from {}", (Object)topicFilter);
            this.dataService.unsubscribe(topicFilter);
        }
        catch (KuraNotConnectedException kuraNotConnectedException) {
            logger.debug("failed to unsubscribe, DataService not connected");
        }
        catch (Exception e) {
            logger.warn("failed to unsubscribe", (Throwable)e);
        }
    }
}

