/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Base64;
import java.util.Objects;
import org.eclipse.kura.annotation.Nullable;
import org.eclipse.kura.type.BooleanValue;
import org.eclipse.kura.type.ByteArrayValue;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.DoubleValue;
import org.eclipse.kura.type.FloatValue;
import org.eclipse.kura.type.IntegerValue;
import org.eclipse.kura.type.LongValue;
import org.eclipse.kura.type.StringValue;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class TypedValues {
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    private TypedValues() {
    }

    public static BooleanValue newBooleanValue(boolean value) {
        return new BooleanValue(value);
    }

    public static ByteArrayValue newByteArrayValue(byte[] value) {
        return new ByteArrayValue(value);
    }

    public static FloatValue newFloatValue(float value) {
        return new FloatValue(value);
    }

    public static DoubleValue newDoubleValue(double value) {
        return new DoubleValue(value);
    }

    public static IntegerValue newIntegerValue(int value) {
        return new IntegerValue(value);
    }

    public static LongValue newLongValue(long value) {
        return new LongValue(value);
    }

    public static StringValue newStringValue(@Nullable String value) {
        return new StringValue(value);
    }

    public static TypedValue<?> newTypedValue(Object value) {
        if (value instanceof Boolean) {
            return TypedValues.newBooleanValue((Boolean)value);
        }
        if (value instanceof byte[]) {
            return TypedValues.newByteArrayValue((byte[])value);
        }
        if (value instanceof Float) {
            return TypedValues.newFloatValue(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return TypedValues.newDoubleValue((Double)value);
        }
        if (value instanceof Integer) {
            return TypedValues.newIntegerValue((Integer)value);
        }
        if (value instanceof Long) {
            return TypedValues.newLongValue((Long)value);
        }
        if (value instanceof String) {
            return TypedValues.newStringValue((String)value);
        }
        throw new IllegalArgumentException("Cannot convert to TypedValue");
    }

    public static TypedValue<?> parseTypedValue(DataType type, String value) {
        Objects.requireNonNull(value, "value cannot be null");
        try {
            switch (type) {
                case BOOLEAN: {
                    return TypedValues.newBooleanValue(Boolean.parseBoolean(value));
                }
                case BYTE_ARRAY: {
                    return TypedValues.newByteArrayValue(BASE64_DECODER.decode(value));
                }
                case DOUBLE: {
                    return TypedValues.newDoubleValue(Double.parseDouble(value));
                }
                case FLOAT: {
                    return TypedValues.newFloatValue(Float.parseFloat(value));
                }
                case INTEGER: {
                    return TypedValues.newIntegerValue(Integer.parseInt(value));
                }
                case LONG: {
                    return TypedValues.newLongValue(Long.parseLong(value));
                }
                case STRING: {
                    return TypedValues.newStringValue(value);
                }
            }
        }
        catch (Exception exception) {}
        throw new IllegalArgumentException(String.valueOf(value) + " cannot be converted into a TypedValue of type " + (Object)((Object)type));
    }
}

