/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.ServiceHelper;

public class DelegateAsyncProcessor
extends ServiceSupport
implements DelegateProcessor,
AsyncProcessor,
Navigate<Processor> {
    protected AsyncProcessor processor;

    public DelegateAsyncProcessor() {
    }

    public DelegateAsyncProcessor(AsyncProcessor processor) {
        if (processor == this) {
            throw new IllegalArgumentException("Recursive DelegateAsyncProcessor!");
        }
        this.processor = processor;
    }

    public DelegateAsyncProcessor(Processor processor) {
        this(AsyncProcessorConverterHelper.convert(processor));
    }

    public String toString() {
        return "DelegateAsync[" + this.processor + "]";
    }

    @Override
    public AsyncProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(AsyncProcessor processor) {
        this.processor = processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = AsyncProcessorConverterHelper.convert(processor);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.processor);
    }

    @Override
    public void process(final Exchange exchange) throws Exception {
        CountDownLatch latch;
        final AsyncProcessorAwaitManager awaitManager = exchange.getContext().getAsyncProcessorAwaitManager();
        boolean sync = this.process(exchange, new AsyncCallback(latch = new CountDownLatch(1)){
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$latch = countDownLatch;
            }

            @Override
            public void done(boolean doneSync) {
                if (!doneSync) {
                    awaitManager.countDown(exchange, this.val$latch);
                }
            }
        });
        if (!sync) {
            awaitManager.await(exchange, latch);
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    @Deprecated
    protected boolean processNext(Exchange exchange, AsyncCallback callback) {
        throw new UnsupportedOperationException("This method is deprecated, use process(Exchange, AsyncCallback) instead");
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }
}

