/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtSecurityTokenServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSecurityTokenService {
    private static final long serialVersionUID = 5333012054583792499L;
    private static ThreadLocal<HttpServletRequest> threadRequest = new ThreadLocal();
    private static Logger logger = LoggerFactory.getLogger(GwtSecurityTokenServiceImpl.class);
    static final String XSRF_TOKEN_KEY = "XSRF_TOKEN";

    public String processCall(String payload) throws SerializationException {
        try {
            threadRequest.set(this.getThreadLocalRequest());
            String string = super.processCall(payload);
            return string;
        }
        finally {
            threadRequest.set(null);
        }
    }

    public static HttpServletRequest getRequest() {
        return threadRequest.get();
    }

    public HttpSession getHttpSession() {
        HttpServletRequest request = GwtSecurityTokenServiceImpl.getRequest();
        return request.getSession();
    }

    @Override
    public GwtXSRFToken generateSecurityToken() {
        GwtXSRFToken token = null;
        HttpSession session = this.getHttpSession();
        if (session != null) {
            token = new GwtXSRFToken(UUID.randomUUID().toString());
            session.setAttribute(XSRF_TOKEN_KEY, (Object)token);
            logger.debug("Generated XSRF token: {} for HTTP session: {}", (Object)token.getToken(), (Object)session.getId());
        }
        return token;
    }
}

