/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gd extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nabhru";
        final String metaValue_TO = "Tonga";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tubhalu";
        final String metaValue_ar = "Arabais";
        final String metaValue_hy = "Airmeinis";
        final String metaValue_ae = "Avestanais";
        final String metaValue_zbl = "Comharran Bliss";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptais";
        final String metaValue_gez = "Ge’ez";
        final String metaValue_ka = "Cairtbheilis";
        final String metaValue_got = "Gotais";
        final String metaValue_el = "Greugais";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Eabhra";
        final String metaValue_jv = "Deàbhanais";
        final String metaValue_ja = "Seapanais";
        final String metaValue_km = "Cmèar";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Coirèanais";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_lo = "Làtho";
        final String metaValue_la = "Laideann";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolais";
        final String metaValue_MM = "Miànmar";
        final String metaValue_osa = "Osage";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_si = "Sinhala";
        final String metaValue_syr = "Suraidheac";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_bo = "Tibeitis";
        final String metaValue_vai = "Vai";
        final String metaValue_peo = "Seann-Pheirsis";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "An Saoghal" },
            { "002", "Afraga" },
            { "003", "Aimeireaga a Tuath" },
            { "005", "Aimeireaga a Deas" },
            { "009", "Roinn a’ Chuain Sèimh" },
            { "011", "Afraga an Iar" },
            { "013", "Meadhan Aimeireaga" },
            { "014", "Afraga an Ear" },
            { "015", "Afraga a Tuath" },
            { "017", "Meadhan Afraga" },
            { "018", "Ceann a Deas Afraga" },
            { "019", "An Dà Aimeireaga" },
            { "021", "Ceann a Tuath Aimeireaga" },
            { "029", "Am Muir Caraibeach" },
            { "030", "Àisia an Ear" },
            { "034", "Àisia a Deas" },
            { "035", "Àisia an Ear-dheas" },
            { "039", "An Roinn-Eòrpa a Deas" },
            { "053", "Astràilia is Sealainn Nuadh" },
            { "054", "Na h-Eileanan Dubha" },
            { "057", "Roinn nam Meanbh-Eileanan" },
            { "061", "Poilinèis" },
            { "142", "Àisia" },
            { "143", "Meadhan Àisia" },
            { "145", "Àisia an Iar" },
            { "150", "An Roinn-Eòrpa" },
            { "151", "An Roinn-Eòrpa an Ear" },
            { "154", "An Roinn-Eòrpa a Tuath" },
            { "155", "An Roinn-Eòrpa an Iar" },
            { "202", "Afraga Deas air an t-Sathara" },
            { "419", "Aimeireaga Laidinneach" },
            { "AC", "Eilean na Deasgabhalach" },
            { "AD", "Andorra" },
            { "AE", "Na h-Iomaratan Arabach Aonaichte" },
            { "AF", "Afghanastàn" },
            { "AG", "Aintìoga is Barbuda" },
            { "AI", "Anguillia" },
            { "AL", "Albàinia" },
            { "AM", "Airmeinea" },
            { "AO", "Angòla" },
            { "AQ", "An Antartaig" },
            { "AR", "An Argantain" },
            { "AS", "Samotha na h-Aimeireaga" },
            { "AT", "An Ostair" },
            { "AU", "Astràilia" },
            { "AW", "Arùba" },
            { "AX", "Na h-Eileanan Åland" },
            { "AZ", "Asarbaideàn" },
            { "BA", "Bosna is Hearsagobhana" },
            { "BB", "Barbados" },
            { "BD", "Bangladais" },
            { "BE", "A’ Bheilg" },
            { "BF", "Buirciona Faso" },
            { "BG", "A’ Bhulgair" },
            { "BH", "Bachrain" },
            { "BI", "Burundaidh" },
            { "BJ", "Beinin" },
            { "BL", "Saint Barthélemy" },
            { "BM", "Bearmùda" },
            { "BN", "Brùnaigh" },
            { "BO", "Boilibhia" },
            { "BQ", "Na Tìrean Ìsle Caraibeach" },
            { "BR", "Braisil" },
            { "BS", "Na h-Eileanan Bhathama" },
            { "BT", "Butàn" },
            { "BV", "Eilean Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "A’ Bhealaruis" },
            { "BZ", "A’ Bheilìs" },
            { "CA", "Canada" },
            { "CC", "Na h-Eileanan Chocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Poblachd Meadhan Afraga" },
            { "CG", "A’ Chongo - Brazzaville" },
            { "CH", "An Eilbheis" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Eileanan Cook" },
            { "CL", "An t-Sile" },
            { "CM", "Camarun" },
            { "CN", "An t-Sìn" },
            { "CO", "Coloimbia" },
            { "CP", "Eilean Clipperton" },
            { "CQ", "Sarc" },
            { "CR", "Costa Rìcea" },
            { "CU", "Cùba" },
            { "CV", "An Ceap Uaine" },
            { "CW", "Curaçao" },
            { "CX", "Eilean na Nollaig" },
            { "CY", "Cìopras" },
            { "CZ", "An t-Seic" },
            { "DE", "A’ Ghearmailt" },
            { "DG", "Diego Garcia" },
            { "DJ", "Diobùtaidh" },
            { "DK", "An Danmhairg" },
            { "DM", "Doiminicea" },
            { "DO", "A’ Phoblachd Dhoiminiceach" },
            { "DZ", "Aildiria" },
            { "EA", "Ceuta agus Melilla" },
            { "EC", "Eacuador" },
            { "EE", "An Eastoin" },
            { "EG", "An Èipheit" },
            { "EH", "Sathara an Iar" },
            { "ER", "Eartra" },
            { "ES", "An Spàinnt" },
            { "ET", "An Itiop" },
            { "EU", "An t-Aonadh Eòrpach" },
            { "EZ", "Raon an Eòro" },
            { "FI", "An Fhionnlann" },
            { "FJ", "Fìdi" },
            { "FK", "Na h-Eileanan Fàclannach" },
            { "FM", "Na Meanbh-eileanan" },
            { "FO", "Na h-Eileanan Fàro" },
            { "FR", "An Fhraing" },
            { "GA", "Gabon" },
            { "GB", "An Rìoghachd Aonaichte" },
            { "GD", "Greanàda" },
            { "GE", "A’ Chairtbheil" },
            { "GF", "Guidheàna na Frainge" },
            { "GG", "Geàrnsaidh" },
            { "GH", "Gàna" },
            { "GI", "Diobraltar" },
            { "GL", "A’ Ghraonlann" },
            { "GM", "A’ Ghaimbia" },
            { "GN", "Gini" },
            { "GP", "Guadalup" },
            { "GQ", "Gini Mheadhan-Chriosach" },
            { "GR", "A’ Ghreug" },
            { "GS", "Seòirsea a Deas is na h-Eileanan Sandwich a Deas" },
            { "GT", "Guatamala" },
            { "GU", "Guam" },
            { "GW", "Gini-Bioso" },
            { "GY", "Guidheàna" },
            { "HK", "Hong Kong SAR na Sìne" },
            { "HM", "Eilean Heard is Eileanan MhicDhòmhnaill" },
            { "HN", "Hondùras" },
            { "HR", "A’ Chròthais" },
            { "HT", "Haidhti" },
            { "HU", "An Ungair" },
            { "IC", "Na h-Eileanan Canàrach" },
            { "ID", "Na h-Innd-innse" },
            { "IE", "Èirinn" },
            { "IL", "Iosrael" },
            { "IM", "Eilean Mhanainn" },
            { "IN", "Na h-Innseachan" },
            { "IO", "Ranntair Breatannach Cuan nan Innseachan" },
            { "IQ", "Ioràc" },
            { "IR", "Ioràn" },
            { "IS", "Innis Tìle" },
            { "IT", "An Eadailt" },
            { "JE", "Deàrsaidh" },
            { "JM", "Diameuga" },
            { "JO", "Iòrdan" },
            { "JP", "An t-Seapan" },
            { "KE", "Ceinia" },
            { "KG", "Cìorgastan" },
            { "KH", "Cambuidea" },
            { "KI", "Ciribeas" },
            { "KM", "Comoros" },
            { "KN", "Naomh Crìstean is Nibheis" },
            { "KP", "Coirèa a Tuath" },
            { "KR", "Coirèa" },
            { "KW", "Cuibhèit" },
            { "KY", "Na h-Eileanan Caimean" },
            { "KZ", "Casachstàn" },
            { "LA", "Làthos" },
            { "LB", "Leabanon" },
            { "LC", "Naomh Lùisea" },
            { "LI", "Lichtenstein" },
            { "LK", "Sri Lanca" },
            { "LR", "Libèir" },
            { "LS", "Leasoto" },
            { "LT", "An Liotuain" },
            { "LU", "Lugsamburg" },
            { "LV", "An Laitbhe" },
            { "LY", "Libia" },
            { "MA", "Moroco" },
            { "MC", "Monaco" },
            { "MD", "A’ Mholdobha" },
            { "ME", "Am Monadh Neagrach" },
            { "MF", "Naomh Màrtainn" },
            { "MG", "Madagasgar" },
            { "MH", "Eileanan Mharshall" },
            { "MK", "A’ Mhasadon a Tuath" },
            { "ML", "Màili" },
            { "MM", metaValue_MM },
            { "MN", "Dùthaich nam Mongol" },
            { "MO", "Macàthu SAR na Sìne" },
            { "MP", "Na h-Eileanan Mairianach a Tuath" },
            { "MQ", "Mairtinic" },
            { "MR", "Moratàinea" },
            { "MS", "Montsarat" },
            { "MT", "Malta" },
            { "MU", "Na h-Eileanan Mhoiriseas" },
            { "MV", "Na h-Eileanan Mhaladaibh" },
            { "MW", "Malabhaidh" },
            { "MX", "Meagsago" },
            { "MY", "Malaidhsea" },
            { "MZ", "Mòsaimbic" },
            { "NA", "An Namaib" },
            { "NC", "Cailleann Nuadh" },
            { "NE", "Nìgeir" },
            { "NF", "Eilean Norfolk" },
            { "NG", "Nigèiria" },
            { "NI", "Niocaragua" },
            { "NL", "Na Tìrean Ìsle" },
            { "NO", "Nirribhidh" },
            { "NP", "Neapàl" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Sealainn Nuadh" },
            { "OM", "Omàn" },
            { "PA", "Panama" },
            { "PE", "Pearù" },
            { "PF", "Poilinèis na Frainge" },
            { "PG", "Gini Nuadh Phaputhach" },
            { "PH", "Na h-Eileanan Filipineach" },
            { "PK", "Pagastàn" },
            { "PL", "A’ Phòlainn" },
            { "PM", "Saint Pierre agus Miquelon" },
            { "PN", "Eileanan Pheit a’ Chàirn" },
            { "PR", "Porto Rìceo" },
            { "PS", "Ùghdarras nam Palastaineach" },
            { "PT", "A’ Phortagail" },
            { "PW", "Palabh" },
            { "PY", "Paraguaidh" },
            { "QA", "Catar" },
            { "QO", "Roinn Iomallach a’ Chuain Sèimh" },
            { "RE", "Réunion" },
            { "RO", "Romàinia" },
            { "RS", "An t-Sèirb" },
            { "RU", "An Ruis" },
            { "RW", "Rubhanda" },
            { "SA", "Aràibia nan Sabhd" },
            { "SB", "Eileanan Sholaimh" },
            { "SC", "Na h-Eileanan Sheiseall" },
            { "SD", "Sudàn" },
            { "SE", "An t-Suain" },
            { "SG", "Singeapòr" },
            { "SH", "Eilean Naomh Eilidh" },
            { "SI", "An t-Slòbhain" },
            { "SJ", "Svalbard is Jan Mayen" },
            { "SK", "An t-Slòbhac" },
            { "SL", "Siarra Leòmhann" },
            { "SM", "San Marino" },
            { "SN", "Seanagal" },
            { "SO", "Somàilia" },
            { "SR", "Suranam" },
            { "SS", "Sudàn a Deas" },
            { "ST", "São Tomé agus Príncipe" },
            { "SV", "An Salbhador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siridhea" },
            { "SZ", "eSwatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Na h-Eileanan Turcach is Caiceo" },
            { "TD", "An t-Seàd" },
            { "TF", "Ranntairean a Deas na Frainge" },
            { "TG", "Togo" },
            { "TH", "Dùthaich nan Tàidh" },
            { "TJ", "Taidigeastàn" },
            { "TK", metaValue_TK },
            { "TL", "Timor-Leste" },
            { "TM", "Turcmanastàn" },
            { "TN", "Tuinisea" },
            { "TO", metaValue_TO },
            { "TR", "An Tuirc" },
            { "TT", "Trianaid agus Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taidh-Bhàn" },
            { "TZ", "An Tansan" },
            { "UA", "An Ucràin" },
            { "UG", "Uganda" },
            { "UM", "Meanbh-Eileanan Iomallach nan SA" },
            { "UN", "Na Dùthchannan Aonaichte" },
            { "US", "Na Stàitean Aonaichte" },
            { "UY", "Uruguaidh" },
            { "UZ", "Usbagastàn" },
            { "VA", "Cathair na Bhatacain" },
            { "VC", "Naomh Bhionsant agus Eileanan Greanadach" },
            { "VE", "A’ Bheiniseala" },
            { "VG", "Eileanan Breatannach na Maighdinn" },
            { "VI", "Eileanan na Maighdinn aig na SA" },
            { "VN", "Bhiet-Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Uallas agus Futuna" },
            { "WS", "Samotha" },
            { "XA", "Sràcan fuadain" },
            { "XB", "Dà-chomhaireach fuadain" },
            { "XK", "A’ Chosobho" },
            { "YE", "An Eaman" },
            { "YT", "Mayotte" },
            { "ZA", "Afraga a Deas" },
            { "ZM", "Sàimbia" },
            { "ZW", "An t-Sìombab" },
            { "ZZ", "Roinn-dùthcha neo-aithnichte" },
            { "aa", "Afar" },
            { "ab", "Abchasais" },
            { "ae", metaValue_ae },
            { "af", "Afraganais" },
            { "ak", "Akan" },
            { "am", "Amtharais" },
            { "an", "Aragonais" },
            { "ar", metaValue_ar },
            { "as", "Asamais" },
            { "av", "Avarais" },
            { "ay", "Aymara" },
            { "az", "Asarbaideànais" },
            { "ba", "Bashkir" },
            { "be", "Bealaruisis" },
            { "bg", "Bulgarais" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bangla" },
            { "bo", metaValue_bo },
            { "br", "Breatnais" },
            { "bs", "Bosnais" },
            { "ca", "Catalanais" },
            { "ce", "Deideanais" },
            { "ch", "Chamorro" },
            { "co", "Corsais" },
            { "cr", "Cree" },
            { "cs", "Seicis" },
            { "cu", "Slàbhais na h-Eaglaise" },
            { "cv", "Chuvash" },
            { "cy", "Cuimris" },
            { "da", "Danmhairgis" },
            { "de", "Gearmailtis" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Beurla" },
            { "eo", "Esperanto" },
            { "es", "Spàinntis" },
            { "et", "Eastoinis" },
            { "eu", "Basgais" },
            { "fa", "Peirsis" },
            { "ff", "Fulah" },
            { "fi", "Fionnlannais" },
            { "fj", "Fìdis" },
            { "fo", "Fàrothais" },
            { "fr", "Fraingis" },
            { "fy", "Frìoslannais Shiarach" },
            { "ga", "Gaeilge" },
            { "gd", "Gàidhlig" },
            { "gl", "Gailìsis" },
            { "gn", "Guaraní" },
            { "gu", metaValue_gu },
            { "gv", "Gaelg" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindis" },
            { "ho", "Hiri Motu" },
            { "hr", "Cròthaisis" },
            { "ht", "Crìtheol Haidhti" },
            { "hu", "Ungairis" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Innd-Innsis" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Yi Sichuan" },
            { "ik", "Inupiaq" },
            { "io", "Ido" },
            { "is", "Innis Tìlis" },
            { "it", "Eadailtis" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Casachais" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Caismiris" },
            { "ku", "Kurmanji" },
            { "kv", "Komi" },
            { "kw", "Còrnais" },
            { "ky", "Cìorgasais" },
            { "la", metaValue_la },
            { "lb", "Lugsamburgais" },
            { "lg", "Ganda" },
            { "li", "Cànan Limburg" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Liotuainis" },
            { "lu", "Luba-Katanga" },
            { "lv", "Laitbheis" },
            { "mg", "Malagasais" },
            { "mh", "Marshallais" },
            { "mi", "Māori" },
            { "mk", "Masadonais" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaidhis" },
            { "mt", "Maltais" },
            { "my", "Burmais" },
            { "na", metaValue_NR },
            { "nb", "Bokmål na Nirribhidh" },
            { "nd", "Ndebele Thuathach" },
            { "ne", "Neapàlais" },
            { "ng", "Ndonga" },
            { "nl", "Duitsis" },
            { "nn", "Nynorsk na Nirribhidh" },
            { "no", "Nirribhis" },
            { "nr", "Ndebele Dheasach" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Ogsatanais" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Ossetic" },
            { "pa", "Panjabi" },
            { "pi", "Pali" },
            { "pl", "Pòlainnis" },
            { "ps", "Pashto" },
            { "pt", "Portagailis" },
            { "qu", "Quechua" },
            { "rm", "Rumains" },
            { "rn", "Kirundi" },
            { "ro", "Romàinis" },
            { "ru", "Ruisis" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sàrdais" },
            { "sd", "Sindhi" },
            { "se", "Sàmais Thuathach" },
            { "sg", "Sango" },
            { "sh", "Sèirb-Chròthaisis" },
            { "si", metaValue_si },
            { "sk", "Slòbhacais" },
            { "sl", "Slòbhainis" },
            { "sm", "Samothais" },
            { "sn", "Shona" },
            { "so", "Somàilis" },
            { "sq", "Albàinis" },
            { "sr", "Sèirbis" },
            { "ss", "Swati" },
            { "st", "Sesotho" },
            { "su", "Cànan Sunda" },
            { "sv", "Suainis" },
            { "sw", "Kiswahili" },
            { "ta", "Taimilis" },
            { "te", metaValue_te },
            { "tg", "Taidigis" },
            { "th", "Cànan nan Tàidh" },
            { "ti", "Tigrinya" },
            { "tk", "Turcmanais" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "tr", "Turcais" },
            { "ts", "Tsonga" },
            { "tt", "Tatarais" },
            { "tw", "Twi" },
            { "ty", "Cànan Tahiti" },
            { "ug", "Ùigiurais" },
            { "uk", "Ucràinis" },
            { "ur", "Ùrdu" },
            { "uz", "Usbagais" },
            { "ve", "Venda" },
            { "vi", "Bhiet-Namais" },
            { "vo", "Volapük" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Iùdhais" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Sìnis" },
            { "zu", "Zulu" },
            { "ace", "Basa Acèh" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "aeb", "Arabais Thuiniseach" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "akk", "Acadais" },
            { "akz", "Alabama" },
            { "ale", "Aleutais" },
            { "aln", "Albàinis Ghegeach" },
            { "alt", "Altais Dheasach" },
            { "ang", "Seann-Bheurla" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "apc", "Arabais Levantach" },
            { "arc", "Aramais" },
            { "arn", "Mapudungun" },
            { "aro", "Araona" },
            { "arp", "Arapaho" },
            { "arq", "Arabais Aildireach" },
            { "ars", "Arabais Najdi" },
            { "arw", "Arawak" },
            { "ary", "Arabais Mhorocach" },
            { "arz", "Arabais Èipheiteach" },
            { "asa", "Asu" },
            { "ase", "Cainnt-shanais na h-Aimeireaga" },
            { "ast", "Astùrais" },
            { "atj", "Atikamekw" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Baluchì" },
            { "ban", "Cànan Bali" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bgc", "Haryanvi" },
            { "bgn", "Balochi Shiarach" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Edo" },
            { "bjn", "Banjar" },
            { "bkm", "Kom" },
            { "bla", "Siksika" },
            { "blo", "Anii" },
            { "blt", "Tai Dam" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bakhtiari" },
            { "bra", "Braj" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buriat" },
            { "bug", "Cànan nam Bugis" },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Caddo" },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Cànan Chuuk" },
            { "chm", "Mari" },
            { "chn", "Chinuk Wawa" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "cic", "Chickasaw" },
            { "ckb", "Cùrdais Mheadhanach" },
            { "clc", "Chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "Capiznon" },
            { "crg", "Michif" },
            { "crh", "Turcais Chriomach" },
            { "crj", "Cree Ear-dheasach" },
            { "crk", "Cree nam Machair" },
            { "crl", "Cree Ear-thuathach" },
            { "crm", "Moose Cree" },
            { "crr", "Algonquianais Charolina" },
            { "crs", "Seiseallais" },
            { "csb", "Caisiubais" },
            { "csw", "Omushkego" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slavey" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Sòrbais Ìochdarach" },
            { "dtp", "Dusun Mheadhanach" },
            { "dua", "Duala" },
            { "dum", "Meadhan-Dhuitsis" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "Èipheitis Àrsaidh" },
            { "eka", "Ekajuk" },
            { "elx", "Elamais" },
            { "enm", "Meadhan-Bheurla" },
            { "esu", "Yupik Mheadhanach" },
            { "ewo", "Ewondo" },
            { "ext", "Cànan na h-Extremadura" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipinis" },
            { "fit", "Meänkieli" },
            { "fon", "Fon" },
            { "frc", "Fraingis nan Cajun" },
            { "frm", "Meadhan-Fhraingis" },
            { "fro", "Seann-Fhraingis" },
            { "frp", "Arpitan" },
            { "frr", "Frìoslannais Thuathach" },
            { "frs", "Frìoslannais Earach" },
            { "fur", "Friùilis" },
            { "gaa", "Ga" },
            { "gag", "Gagauz" },
            { "gan", "Gan" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gbz", "Dari Zoroastrach" },
            { "gez", metaValue_gez },
            { "gil", "Ciribeasais" },
            { "glk", "Gilaki" },
            { "gmh", "Meadhan-Àrd-Gearmailtis" },
            { "goh", "Seann-Àrd-Gearmailtis" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Greugais Àrsaidh" },
            { "gsw", "Gearmailtis Eilbheiseach" },
            { "guc", "Wayuu" },
            { "gur", "Frafra" },
            { "guz", "Gusii" },
            { "gwi", "Gwichʼin" },
            { "hai", "Haida" },
            { "hak", "Hakka" },
            { "haw", "Cànan Hawai’i" },
            { "hax", "Haida Dheasach" },
            { "hif", "Hindis Fhìditheach" },
            { "hil", "Hiligaynon" },
            { "hit", "Cànan Het" },
            { "hmn", "Hmong" },
            { "hnj", "Hmong Njua" },
            { "hsb", "Sòrbais Uachdarach" },
            { "hsn", "Xiang" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Inuktitut Shiarach Chanada" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jam", "Beurla Crìtheolach Diameuga" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Peirsis Iùdhach" },
            { "jrb", "Arabais Iùdhach" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Cabardais" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "kek", "Qʼeqchiʼ" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "kho", "Cànan Khotan" },
            { "khq", "Koyra Chiini" },
            { "khw", "Khowar" },
            { "kiu", "Kirmanjki" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "kpe", metaValue_kpe },
            { "krc", "Karachay-Balkar" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Cairealais" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Gearmailtis Chologne" },
            { "kum", "Kumyk" },
            { "kut", "Kutenai" },
            { "kwk", "Kwakʼwala" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Leasgais" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Liogùrais" },
            { "lil", "Lillooet" },
            { "lkt", "Lakhóta" },
            { "lld", "Ladainis" },
            { "lmo", "Lombardais" },
            { "lol", "Mongo" },
            { "lou", "Crìtheol Louisiana" },
            { "loz", "Lozi" },
            { "lrc", "Luri Thuathach" },
            { "lsm", "Saamia" },
            { "ltg", "Latgailis" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseño" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "lzh", "Sìnis an Litreachais" },
            { "lzz", "Laz" },
            { "mad", "Cànan Madhura" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", metaValue_mak },
            { "man", "Mandingo" },
            { "mas", "Maasai" },
            { "mde", "Maba" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Meadhan-Ghaeilge" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta’" },
            { "mhn", "Mócheno" },
            { "mic", "Mi’kmaq" },
            { "min", "Minangkabau" },
            { "mnc", "Manchu" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mrj", "Mari Shiarach" },
            { "mua", "Mundang" },
            { "mul", "Iomadh cànan" },
            { "mus", "Creek" },
            { "mwl", "Miorandais" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nan", "Min Nan" },
            { "nap", "Eadailtis Napoli" },
            { "naq", "Nama" },
            { "nds", "Gearmailtis Ìochdarach" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Cànan Niue" },
            { "njo", "Ao Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Seann-Lochlannais" },
            { "nov", "Novial" },
            { "nqo", "N’Ko" },
            { "nso", "Sesotho sa Leboa" },
            { "nus", "Nuer" },
            { "nwc", "Newari Chlasaigeach" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "ojb", "Ojibwa Iar-thuathach" },
            { "ojc", "Ojibwa Mheadhanach" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Ojibwa Shiarach" },
            { "oka", "Okanagan" },
            { "osa", metaValue_osa },
            { "ota", "Turcais Otomanach" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiamentu" },
            { "pau", "Palabhais" },
            { "pcd", "Picard" },
            { "pcm", "Beurla Nigèiriach" },
            { "pdc", "Gearmailtis Phennsylvania" },
            { "pdt", "Plautdietsch" },
            { "peo", metaValue_peo },
            { "phn", "Phenicis" },
            { "pis", "Pijin" },
            { "pms", "Piedmontese" },
            { "pon", "Cànan Pohnpei" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Pruisis" },
            { "pro", "Seann-Phrovençal" },
            { "quc", "K’iche’" },
            { "qug", "Quichua Àrd-tìr Chimborazo" },
            { "raj", "Rajasthani" },
            { "rap", "Rapa Nui" },
            { "rar", "Cànan Rarotonga" },
            { "rgn", "Romagnol" },
            { "rhg", "Rohingya" },
            { "rif", "Tamaisich an Rif" },
            { "rof", "Rombo" },
            { "rom", "Romanais" },
            { "rue", "Rusyn" },
            { "rug", "Roviana" },
            { "rup", "Aromanais" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "sam", "Aramais Shamaritanach" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sisilis" },
            { "sco", "Albais" },
            { "sdc", "Sassarese" },
            { "sdh", "Cùrdais Dheasach" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkup" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Seann-Ghaeilge" },
            { "sgs", "Samogitis" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "shu", "Arabais Seàdach" },
            { "sid", "Sidamo" },
            { "skr", "Saraiki" },
            { "slh", "Lushootseed Dheasach" },
            { "sly", "Selayar" },
            { "sma", "Sàmais Dheasach" },
            { "smj", "Sàmais Lule" },
            { "smn", "Sàmais Inari" },
            { "sms", "Sàmais Skolt" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer" },
            { "ssy", metaValue_ssy },
            { "str", "Salish a’ Chaolais" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "Cànan Sumer" },
            { "suz", "Sunwar" },
            { "swb", "Comorais" },
            { "syc", "Suraidheac Chlasaigeach" },
            { "syr", metaValue_syr },
            { "szl", "Sileisis" },
            { "tce", "Tutchone Dheasach" },
            { "tcy", "Tulu" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Terêna" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", metaValue_TK },
            { "tkr", "Tsakhur" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tly", "Talysh" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "trw", "Torwali" },
            { "tsi", "Tsimshian" },
            { "ttm", "Tutchone Thuathach" },
            { "ttt", "Tati" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Cànan Tuva" },
            { "tzm", "Tamaisich an Atlais Mheadhanaich" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Cànan neo-aithnichte" },
            { "vai", metaValue_vai },
            { "vec", "Bheinisis" },
            { "vep", "Veps" },
            { "vls", "Flànrais Shiarach" },
            { "vmw", "Makhuwa" },
            { "vro", "Võro" },
            { "vun", "Vunjo" },
            { "wae", "Gearmailtis Wallis" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu" },
            { "xal", "Kalmyk" },
            { "xnr", "Kangri" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Cànan Yap" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Cantonais" },
            { "zap", "Zapotec" },
            { "zbl", metaValue_zbl },
            { "zea", "Cànan Zeeland" },
            { "zen", "Zenaga" },
            { "zgh", "Tamaisich Stannardach Moroco" },
            { "zun", "Zuñi" },
            { "zxx", "Susbaint nach eil ’na chànan" },
            { "zza", "Zazaki" },
            { "Adlm", "Adlam" },
            { "Afak", "Afaka" },
            { "Aghb", "Albàinis Chabhcasach" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armi", "Aramais impireil" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Beangailis" },
            { "Berf", "Beria Erfe" },
            { "Bhks", "Bhaiksuki" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", "Lontara" },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Sgrìobhadh Lideach Aonaichte nan Tùsanach Canadach" },
            { "Cari", "Carian" },
            { "Cher", metaValue_chr },
            { "Chrs", "Khwarazm" },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cpmn", "Mìneothais Chìopras" },
            { "Cprt", "Cìoprasais" },
            { "Cyrl", "Cirilis" },
            { "Cyrs", "Cirilis Seann-Slàbhais na h-Eaglaise" },
            { "Deva", "Devanagari" },
            { "Diak", "Dives Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Gearr-sgrìobhadh Duployé" },
            { "Egyp", "Sealbh-sgrìobhadh Èipheiteach" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaidheach" },
            { "Ethi", metaValue_gez },
            { "Gara", "Garay" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagoliticeach" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", metaValue_got },
            { "Gran", "Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Gukh", "Gurung Khema" },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han le Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Simplichte" },
            { "Hant", "Tradaiseanta" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Dealbh-sgrìobhadh Anatolach" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "Katakana no Hiragana" },
            { "Hung", "Seann-Ungarais" },
            { "Ital", "Seann-Eadailtis" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Kawi", "KAWI" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Kits", "Litrichean beaga na Khitan" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Krai", "Kirat Rai" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Laideann fraktur" },
            { "Latg", "Laideann Ghàidhealach" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Lycian" },
            { "Lydi", "Lydian" },
            { "Mahj", "Mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "Mandaean" },
            { "Mani", "Manichaean" },
            { "Marc", "Marchen" },
            { "Maya", "Dealbh-sgrìobhadh Mayach" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Meroiticeach ceangailte" },
            { "Mero", "Meroiticeach" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", metaValue_MM },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Seann-Arabach Thuathach" },
            { "Nbat", "Nabataean" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", "N’ko" },
            { "Nshu", "Nüshu" },
            { "Ogam", "Ogham-chraobh" },
            { "Olck", "Ol Chiki" },
            { "Onao", "Ol Onal" },
            { "Orkh", "Orkhon" },
            { "Orya", "Oriya" },
            { "Osge", metaValue_osa },
            { "Osma", "Osmanya" },
            { "Ougr", "Seann-Ùigiurais" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Seann-Phermic" },
            { "Phag", "Phags-pa" },
            { "Phli", "Pahlavi nan snaidh-sgrìobhaidhean" },
            { "Phlp", "Pahlavi nan saltair" },
            { "Phnx", "Pheniceach" },
            { "Plrd", "Miao Phollard" },
            { "Prti", "Partais snaidh-sgrìobhte" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi Rohingya" },
            { "Roro", "Rongorongo" },
            { "Runr", "Rùn-sgrìobhadh" },
            { "Samr", "Samaritanais" },
            { "Sara", "Sarati" },
            { "Sarb", "Seann-Arabais Dheasach" },
            { "Saur", metaValue_saz },
            { "Sgnw", "Sgrìobhadh cainnte-sanais" },
            { "Shaw", "Sgrìobhadh an t-Seathaich" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sidt", "Sideatach" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "Sogdianais" },
            { "Sogo", "Seann-Sogdianais" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", "Sunda" },
            { "Sunu", "Sunuwar" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Suraidheac Estrangela" },
            { "Syrj", "Suraidheac Siarach" },
            { "Syrn", "Suraidheac Earach" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue Ùr" },
            { "Taml", "Taimil" },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Tayo", "Tai Yo" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", "Tàidh" },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Tnsa", "Tangsa" },
            { "Todr", "Todhri" },
            { "Tols", "Tolong Siki" },
            { "Tutg", "Tulu-Tigalari" },
            { "Ugar", "Ugariticeach" },
            { "Vaii", metaValue_vai },
            { "Vith", "Vithkuqi" },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Wole", "Woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Gèinn-sgrìobhadh Sumer is Akkad" },
            { "Yezi", "Yezidis" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar ceàrnagach" },
            { "Zinh", "Dìleab" },
            { "Zmth", "Gnìomhairean matamataig" },
            { "Zsye", "Emoji" },
            { "Zsym", "Samhlaidhean" },
            { "Zxxx", "Gun sgrìobhadh" },
            { "Zyyy", "Coitcheann" },
            { "Zzzz", "Litreadh neo-aithnichte" },
            { "de_AT", "Gearmailtis na h-Ostaire" },
            { "de_CH", "Àrd-Ghearmailtis na h-Eilbheise" },
            { "en_AU", "Beurla Astràilia" },
            { "en_CA", "Beurla Chanada" },
            { "en_GB", "Beurla Bhreatainn" },
            { "en_US", "Beurla na h-Aimeireaga" },
            { "es_ES", "Spàinntis Eòrpach" },
            { "es_MX", "Spàinntis Mheagsagach" },
            { "fa_AF", "Dari" },
            { "fr_CA", "Fraingis Chanada" },
            { "fr_CH", "Fraingis Eilbheiseach" },
            { "nl_BE", "Flànrais" },
            { "pt_BR", "Portagailis Bhraisileach" },
            { "pt_PT", "Portagailis Eòrpach" },
            { "ro_MD", "Moldobhais" },
            { "sw_CD", "Kiswahili na Congo" },
            { "%%1901", "Litreachadh tradaiseanta na Gearmailtise" },
            { "%%1994", "Litreachadh stannardach dual-chainnt Resia" },
            { "%%1996", "Litreachadh na Gearmailtise 1996" },
            { "ar_001", "Nuadh-Arabais Stannardach" },
            { "es_419", "Spàinntis na h-Aimeireaga Laidinneach" },
            { "key.ca", "Mìosachan" },
            { "key.cf", "Fòrmat an airgeadra" },
            { "key.co", "Òrdugh an t-seòrsachaidh" },
            { "key.cu", "Airgeadra" },
            { "key.em", "Riochdachadh nan Emoji" },
            { "key.hc", "Cearcall an ama (12 no 24 uair)" },
            { "key.lb", "Stoidhle nam brisidhean-loidhe" },
            { "key.lw", "Brisidhean loidhne am broinn fhaclan" },
            { "key.ms", "Siostam tomhais" },
            { "key.nu", "Àireamhan" },
            { "key.ss", "Briseadh rosgrainn às dèidh giorr." },
            { "nds_NL", "Sagsannais Ìochdarach" },
            { "%%ALUKU", "Dual-chainnt Aluku" },
            { "%%BARLA", "Dual-chainntean Barlavento de Kabuverdianu" },
            { "%%BISKE", "Dual-chainnt San Giorgio/Bila" },
            { "%%BOONT", "Boontling" },
            { "%%CORNU", "Beurla na Còirne" },
            { "%%GALLO", "Gallo" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Litreachadh coitcheann" },
            { "%%KSCOR", "Litreachadh stannardach" },
            { "%%LIPAW", "Dual-chainnt Lipovaz Resia" },
            { "%%NEDIS", "Dual-chainnt Natisone" },
            { "%%NJIVA", "Dual-chainnt Gniva/Njiva" },
            { "%%NULIK", "Nua-Volapük" },
            { "%%OSOJS", "Dual-chainnt Oseacco/Osojane" },
            { "%%PEANO", "Peano" },
            { "%%POSIX", "Coimpiutair" },
            { "%%PUTER", "Puter" },
            { "%%RIGIK", "Volapük chlasaigeach" },
            { "%%ROZAJ", "Dual-chainnt Resia" },
            { "%%RUMGR", "Rumantsch Grischun" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Dual-chainnt Stolvizza/Solbica" },
            { "%%SOTAV", "Dual-chainntean Sotavento de Kabuverdianu" },
            { "%%UCCOR", "Litreachadh aonaichte" },
            { "zh_Hans", "Sìnis Shimplichte" },
            { "zh_Hant", "Sìnis Thradaiseanta" },
            { "%%AO1990", "Aonta litreachadh na Portagailise 1990" },
            { "%%ARANES", "Aranais" },
            { "%%ASANTE", "Asante" },
            { "%%AUVERN", "Auvernhat" },
            { "%%CISAUP", "Ogsatanais cios-Ailpeach" },
            { "%%CREISS", "Ogsatanais Chroissant" },
            { "%%DAJNKO", "Aibidil Dajnko" },
            { "%%EKAVSK", "Sèirbhis le fuaimneachadh iarach" },
            { "%%FONIPA", "Comharran fuaim-eòlais an IPA" },
            { "%%FONUPA", "Comharran fuaim-eòlais an UPA" },
            { "%%GASCON", "Ogsatanais Ghascogne" },
            { "%%GRITAL", "Nòs-sgrìobhaidh Eadailteach na h-Ogsatanaise" },
            { "%%NDYUKA", "Dual-chainnt Ndyuka" },
            { "%%NICARD", "Ogsatanais Nice" },
            { "%%PAMAKA", "Dual-chainnt Pamaka" },
            { "%%PINYIN", "Ròmanachadh Pinyin" },
            { "%%SCOUSE", "Scouse" },
            { "%%SIMPLE", "Samhlaidhean sìmplichte" },
            { "%%TARASK", "Litreachadh Taraškievica" },
            { "%%UCRCOR", "Litreachadh aonaichte ’s lèirmheasaichte" },
            { "%%ULSTER", "Albais Uladh" },
            { "%%UNIFON", "Aibidil fuaim-eòlais Unifon" },
            { "%%ABL1943", "Gnàthas-litreachaidh 1943" },
            { "%%AKUAPEM", "Akuapem" },
            { "%%ALALC97", "Ròmanachadh ALA-LC 1997" },
            { "%%AREVELA", "Airmeinis an Ear" },
            { "%%AREVMDA", "Airmeinis an Iar" },
            { "%%ARKAIKA", "Arkaika" },
            { "%%BALANKA", "Dual-chainnt Balanka de Anii" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "Aibidil Bohorič" },
            { "%%EMODENG", "Nua-Bheurla thràth" },
            { "%%FONNAPA", "Aibidil Fhuaim-eòlach Aimeireaga a Tuath" },
            { "%%GRCLASS", "Nòs-sgrìobhaidh clasaigeach na h-Ogsatanaise" },
            { "%%GRMISTR", "Nòs-sgrìobhaidh Mhistral na h-Ogsatanaise" },
            { "%%HEPBURN", "Ròmanachadh Hepburn" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%LEMOSIN", "Ogsatanais Lemosin" },
            { "%%LTG1929", "Litreachadh na Latgailise 1929" },
            { "%%LTG2007", "Litreachadh na Latgailise 2007" },
            { "%%METELKO", "Aibidil Metelko" },
            { "%%MONOTON", "Greugais mhonotonach" },
            { "%%PAHAWH2", "Pahawh Hmong na 2na ìre" },
            { "%%PAHAWH3", "Pahawh Hmong na 3s ìre" },
            { "%%PAHAWH4", "Pahawh Hmong na 4mh ìre" },
            { "%%POLYTON", "Greugais phoiliotonach" },
            { "%%PROVENC", "Ogsatanais Phrovence" },
            { "%%REVISED", "Litreachadh lèirmheasaichte" },
            { "%%SURSILV", "Sursilvan" },
            { "%%SUTSILV", "Sutsilvan" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "Meadhan-Fhraingis anmoch gu 1606" },
            { "%%1694ACAD", "Nua-Fhraingis thràth" },
            { "%%1959ACAD", "Bealaruisis Acadamaigeach" },
            { "%%BAKU1926", "Abidil Laideann aonaichte na Turcaise" },
            { "%%BASICENG", "Beurla bhunasach" },
            { "%%BISCAYAN", "Dual-chainnt Bizkaia" },
            { "%%BORNHOLM", "Bornholmsk" },
            { "%%COLB1945", "Aonta litreachaidh eadar a’ Phortagail is Braisil 1945" },
            { "%%FONKIRSH", "Còdachadh Kirshenbaum na h-Aibidil Fuaim-eòlaiche" },
            { "%%FONXSAMP", "Tar-sgrìobhadh X-SAMPA" },
            { "%%HOGNORSK", "Høgnorsk" },
            { "%%HSISTEMO", "Roghainn-èiginn stannardach litreachadh na h-Esperanto le h" },
            { "%%IJEKAVSK", "Sèirbis le fuaimneachadh Ijekavia" },
            { "%%IVANCHOV", "Bulgarian in 1899 orthography = Bulgairis le litreachadh na bliadhna 1899" },
            { "%%JYUTPING", "Jyutping" },
            { "%%KOCIEWIE", "Kociewie" },
            { "%%LENGADOC", "Ogsatanais Lengadoc" },
            { "%%LUNA1918", "Litreachadh na Ruisise às dèidh 1917" },
            { "%%NEWFOUND", "Beurla Talamh an Èisg" },
            { "%%OXENDICT", "Litreachadh faclair Oxford na Beurla" },
            { "%%PETR1708", "Litreachadh Pheadair 1708" },
            { "%%SCOTLAND", "Beurla Stannardach na h-Alba" },
            { "%%SPANGLIS", "Spanglish" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%SYNNEJYL", "Diutlannais Dheasach" },
            { "%%TONGYONG", "Tongyong" },
            { "%%TUNUMIIT", "Tunumiit" },
            { "%%VALENCIA", "Valencià" },
            { "%%VALLADER", "Vallader" },
            { "%%VECDRUKA", "Vecā Druka" },
            { "%%VIVARAUP", "Ogsatanais Vivaro-Ailpeach" },
            { "%%WADEGILE", "Ròmanachadh Wade-Giles" },
            { "%%XSISTEMO", "Roghainn-èiginn stannardach litreachadh na h-Esperanto le x" },
            { "type.ca.roc", "Mìosachan Poblachd na Sìne" },
            { "type.co.eor", "Òrdugh seòrsachaidh Eòrpach" },
            { "type.hc.h11", "Cleoc 12 uair a thìde (0–11)" },
            { "type.hc.h12", "Cleoc 12 uair a thìde (1–12)" },
            { "type.hc.h23", "Cleoc 24 uair a thìde (0–23)" },
            { "type.hc.h24", "Cleoc 24 uair a thìde (1–24)" },
            { "type.m0.bgn", "Tar-litreachadh BGN nan Stàitean Aonaichte" },
            { "type.nu.ahom", "Àireamhan Ahom" },
            { "type.nu.arab", "Àireamhan Arabach-Innseanach" },
            { "type.nu.armn", "Àireamhan na h-Airmeinise" },
            { "type.nu.bali", "Àireamhan Bali" },
            { "type.nu.beng", "Àireamhan na Beangailise" },
            { "type.nu.brah", "Àireamhan Brahmi" },
            { "type.nu.cakm", "Àireamhan Chakma" },
            { "type.nu.cham", "Àireamhan Cham" },
            { "type.nu.cyrl", "Àireamhan na Cirilise" },
            { "type.nu.deva", "Àireamhan Devanagari" },
            { "type.nu.diak", "Àireamhan Dives Akuru" },
            { "type.nu.ethi", "Àireamhan Itiopach" },
            { "type.nu.gara", "Àireamhan Garay" },
            { "type.nu.geor", "Àireamhan na Cairtbheilise" },
            { "type.nu.gong", "Àireamhan Gunjala Gondi" },
            { "type.nu.gonm", "Àireamhan Masaram Gondi" },
            { "type.nu.grek", "Àireamhan na Greugaise" },
            { "type.nu.gujr", "Àireamhan Gujarati" },
            { "type.nu.gukh", "Àireamhan Gurung Khema" },
            { "type.nu.guru", "Àireamhan Gurmukhi" },
            { "type.nu.hans", "Àireamhan na Sìnise Shimplichte" },
            { "type.nu.hant", "Àireamhan na Sìnise Thradaiseanta" },
            { "type.nu.hebr", "Àireamhan na h-Eabhra" },
            { "type.nu.hmng", "Àireamhan Pahawh Hmong" },
            { "type.nu.hmnp", "Àireamhan Nyiakeng Puachue" },
            { "type.nu.java", "Àireamhan na Deàbhanaise" },
            { "type.nu.jpan", "Àireamhan na Seapanaise" },
            { "type.nu.kali", "Àireamhan Kayah Li" },
            { "type.nu.kawi", "Àireamhan Kawi" },
            { "type.nu.khmr", "Àireamhan Cmèar" },
            { "type.nu.knda", "Àireamhan Kannada" },
            { "type.nu.krai", "Àireamhan Kirat Rai" },
            { "type.nu.lana", "Àireamhan Tai Tham Hora" },
            { "type.nu.laoo", "Àireamhan Làtho" },
            { "type.nu.latn", "Àireamhan Siarach" },
            { "type.nu.lepc", "Àireamhan Lepcha" },
            { "type.nu.limb", "Àireamhan Limbu" },
            { "type.nu.mlym", "Àireamhan Malayalam" },
            { "type.nu.modi", "Àireamhan Modi" },
            { "type.nu.mong", "Àireamhan na Mongolaise" },
            { "type.nu.mroo", "Àireamhan Mro" },
            { "type.nu.mtei", "Àireamhan Meetei Mayek" },
            { "type.nu.mymr", "Àireamhan Miànmar" },
            { "type.nu.nagm", "Àireamhan Nag Mundari" },
            { "type.nu.nkoo", "Àireamhan N’Ko" },
            { "type.nu.olck", "Àireamhan Ol Chiki" },
            { "type.nu.onao", "Àireamhan Ol Onal" },
            { "type.nu.orya", "Àireamhan Odia" },
            { "type.nu.osma", "Àireamhan Osmanya" },
            { "type.nu.rohg", "Àireamhan Hanifi Rohingya" },
            { "type.nu.saur", "Àireamhan Saurashtra" },
            { "type.nu.shrd", "Àireamhan Sharada" },
            { "type.nu.sind", "Àireamhan Khudawadi" },
            { "type.nu.sinh", "Àireamhan Lith na Sinhala" },
            { "type.nu.sora", "Àireamhan Sora Sompeng" },
            { "type.nu.sund", "Àireamhan Sunda" },
            { "type.nu.sunu", "Àireamhan Sunuwar" },
            { "type.nu.takr", "Àireamhan Takri" },
            { "type.nu.talu", "Àireamhan Tai Lue Ùr" },
            { "type.nu.taml", "Àireamhan na Taimilise Tradaiseanta" },
            { "type.nu.telu", "Àireamhan Telugu" },
            { "type.nu.thai", "Àireamhan Tàidh" },
            { "type.nu.tibt", "Àireamhan na Tibeitise" },
            { "type.nu.tirh", "Àireamhan Tirhuta" },
            { "type.nu.tnsa", "Àireamhan Tangsa" },
            { "type.nu.tols", "Àireamhan Tolong Siki" },
            { "type.nu.vaii", "Àireamhan Vai" },
            { "type.nu.wara", "Àireamhan Warang Citi" },
            { "type.nu.wcho", "Àireamhan Wancho" },
            { "type.ca.dangi", "Mìosachan Dangi" },
            { "type.co.ducet", "Òrdugh seòrsachaidh Unicode bunaiteach" },
            { "type.co.emoji", "Òrdugh seòrsachaidh Emoji" },
            { "type.lb.loose", "Brisidhean-loidhe fuasgailte" },
            { "type.nu.roman", "Àireamhan Ròmanach" },
            { "type.ca.coptic", "Am Mìosachan Coptach" },
            { "type.ca.hebrew", "Am Mìosachan Eabhrach" },
            { "type.ca.indian", "Mìosachan Nàiseanta nan Innseachan" },
            { "type.co.compat", "Òrdugh seòrsachaidh roimhe a chum co-chòrdalachd" },
            { "type.co.pinyin", "Òrdugh seòrsachaidh Pinyin" },
            { "type.co.search", "Lorg coitcheann" },
            { "type.co.stroke", "Òrdugh nan stràcan" },
            { "type.co.unihan", "Òrdugh an fhreumha ’s nan stràcan" },
            { "type.co.zhuyin", "Òrdugh seòrsachaidh Zhuyin" },
            { "type.d0.fwidth", "Làn-Leud" },
            { "type.d0.hwidth", "Leth-Leud" },
            { "type.lb.normal", "Brisidhean-loidhe àbhaisteach" },
            { "type.lb.strict", "Brisidhean-loidhe teanna" },
            { "type.m0.ungegn", "Tar-litreachadh GEGN nan Dùthchannan Aonaichte" },
            { "type.ms.metric", "Tomhas meatrach" },
            { "type.ca.chinese", "Am Mìosachan Sìneach" },
            { "type.ca.islamic", "Am Mìosachan Hijri" },
            { "type.ca.iso8601", "Mìosachan ISO-8601" },
            { "type.ca.persian", "Am Mìosachan Pearsach" },
            { "type.cf.account", "Fòrmat airgeadra na cunntasachd" },
            { "type.d0.npinyin", "Àireamhach" },
            { "type.nu.arabext", "Àireamhan Arabach-Innseanach leudaichte" },
            { "type.nu.armnlow", "Àireamhan beaga na h-Airmeinise" },
            { "type.nu.greklow", "Àireamhan beaga na Greugaise" },
            { "type.nu.hanidec", "Àireamhan deicheach na Sìnise" },
            { "type.nu.hansfin", "Àireamhan ionmhasail na Sìnise Shimplichte" },
            { "type.nu.hantfin", "Àireamhan ionmhasail na Sìnise Thradaiseanta" },
            { "type.nu.jpanfin", "Àireamhan ionmhasail na Seapanaise" },
            { "type.nu.mathdbl", "Àireamhan matamataig le loidhne dhùbailte" },
            { "type.nu.mymrpao", "Àireamhan Pao Miànmar" },
            { "type.nu.tamldec", "Àireamhan na Taimilise" },
            { "type.ca.buddhist", "Am Mìosachan Bùdach" },
            { "type.ca.ethiopic", "Mìosachan na h-Itioipe" },
            { "type.ca.japanese", "Am Mìosachan Seapanach" },
            { "type.cf.standard", "Fòrmat stannardach an airgeadra" },
            { "type.co.searchjl", "Lorg leis a’ chiad chonnrag Hangul" },
            { "type.co.standard", "Òrdugh seòrsachaidh stannardach" },
            { "type.ms.uksystem", "Tomhas impireil" },
            { "type.ms.ussystem", "Tomhas nan Stàitean Aonaichte" },
            { "type.nu.fullwide", "Àireamhan làn-leud" },
            { "type.nu.lanatham", "Àireamhan Tai Tham Tham" },
            { "type.nu.mathbold", "Àireamhan matamataig troma" },
            { "type.nu.mathmono", "Àireamhan matamataig aon-leud" },
            { "type.nu.mathsanb", "Àireamhan matamataig sans-serif troma" },
            { "type.nu.mathsans", "Àireamhan matamataig sans-serif" },
            { "type.nu.mymrepka", "Àireamhan Pwo Karen Miànmar an Ear" },
            { "type.nu.mymrshan", "Àireamhan Shan Miànmar" },
            { "type.nu.mymrtlng", "Àireamhan Tai Laing Miànmar" },
            { "type.nu.outlined", "Àireamhan oir-loidhnichte" },
            { "type.nu.romanlow", "Àireamhan beaga Ròmanach" },
            { "type.ca.gregorian", "Am Mìosachan Griogarach" },
            { "type.co.phonebook", "Òrdugh seòrsachaidh nan leabhraichean-fòn" },
            { "type.co.dictionary", "Òrdugh seòrsachaidh an fhaclair" },
            { "type.co.traditional", "Òrdugh seòrsachaidh tradaiseanta" },
            { "type.ca.islamic-rgsa", "Am Mìosachan Hijri (Aràibia nan Sabhd, sealladh)" },
            { "type.ca.islamic-tbla", "Am Mìosachan Hijri (clàrach, linn reul-eòlach)" },
            { "type.ca.islamic-civil", "Am Mìosachan Hijri (clàrach, linn sìobhalta)" },
            { "type.ca.islamic-umalqura", "Am Mìosachan Hijri (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Mìosachan Itiopach Amete Alem" },
        };
        return data;
    }
}
