/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_yo_BJ extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Apia = new String[] {
               "Àkókò Àfɛnukò Apia",
               "",
               "Àkókò Ojúmɔmɔ Apia",
               "",
               "Àkókò Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Àkókò Àfɛnukò Àwɔn Erekusu Kuuku",
               "",
               "Àkókò Ilaji Sɔma Àwɔn Erekusu Kuuku",
               "",
               "Àkókò Àwɔn Erekusu Kuuku",
               "",
            };
        final String[] Cuba = new String[] {
               "Àkókò Àfɛnukò Kúbà",
               "CST",
               "Àkókò Ojúmɔmɔ Kúbà",
               "CDT",
               "Àkókò Kúbà",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Àkókò Àfɛnukò Fiji",
               "",
               "Àkókò Sɔma Fiji",
               "",
               "Àkókò Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Àkókò Àfɛnukò Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Àkókò Ìfɛnukòsí Hofidi",
               "",
               "Àkókò Sɔmà Hofidi",
               "",
               "Àkókò Hofidi",
               "",
            };
        final String[] Iran = new String[] {
               "Àkókò Àfɛnukò Irani",
               "",
               "Àkókò Ojúmɔmɔ Irani",
               "",
               "Àkókò Irani",
               "",
            };
        final String[] Omsk = new String[] {
               "Àkókò Àfɛnukò Omisiki",
               "",
               "Àkókò Sɔmà Omisiki",
               "",
               "Àkókò Omisiki",
               "",
            };
        final String[] Peru = new String[] {
               "Àkókò Àfɛnukò Pérù",
               "",
               "Àkókò Ooru Pérù",
               "",
               "Àkókò Pérù",
               "",
            };
        final String[] Chile = new String[] {
               "Àkókò Àfɛnukò Shílè",
               "",
               "Àkókò Oru Shílè",
               "",
               "Àkókò Shílè",
               "",
            };
        final String[] China = new String[] {
               "Àkókò Ìfɛnukòsí Sháínà",
               "CST",
               "Àkókò Ojúmɔmɔ Sháínà",
               "CDT",
               "Àkókò Sháínà",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Àkókò Àwɔn Erékùsù Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Àkókò Àfɛnukò India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Àkókò Ìfɛnukòsí Japan",
               "JST",
               "Àkókò Sɔmà Japan",
               "JDT",
               "Àkókò Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Àkókò Ìfɛnukòsí Koria",
               "KST",
               "Àkókò Ojúmɔmɔ Koria",
               "KST",
               "Àkókò Koria",
               "KST",
            };
        final String[] Samoa = new String[] {
               "Àkókò Àfɛnukò Samoa",
               "SST",
               "Àkókò Ojúmɔmɔ Samoa",
               "SST",
               "Àkókò Samoa",
               "SST",
            };
        final String[] Tonga = new String[] {
               "Àkókò Àfɛnukò Tonga",
               "",
               "Àkókò Sɔmà Tonga",
               "",
               "Àkókò Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Àkókò Yúkɔ́nì",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Àkókò Àfɛnukò Alásíkà",
               "AKST",
               "Àkókò Ojúmɔ́ Alásíkà",
               "AKDT",
               "Àkókò Alásíkà",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Àkókò Afɛnukò Amásɔ́nì",
               "",
               "Àkókò Oru Amásɔ́nì",
               "",
               "Àkókò Amásɔ́nì",
               "",
            };
        final String[] Azores = new String[] {
               "Àkókò Àfɛnukò Ásɔ́sì",
               "",
               "Àkókò Ooru Ásɔ́sì",
               "",
               "Àkókò Ásɔ́sì",
               "",
            };
        final String[] Israel = new String[] {
               "Àkókò Àfɛnukò Israel",
               "IST",
               "Àkókò Ojúmɔmɔ Israel",
               "IDT",
               "Àkókò Israel",
               "IT",
            };
        final String[] Moscow = new String[] {
               "Àkókò Àfɛnukò Mosiko",
               "MSK",
               "Àkókò Sɔmà Mosiko",
               "MSK",
               "Àkókò Mosiko",
               "MSK",
            };
        final String[] Taipei = new String[] {
               "Àkókò Ìfɛnukòsí Taipei",
               "CST",
               "Àkókò Ojúmɔmɔ Taipei",
               "CDT",
               "Àkókò Taipei",
               "CT",
            };
        final String[] Arabian = new String[] {
               "Àkókò Àfɛnukò Arabia",
               "",
               "Àkókò Ojúmɔmɔ Arabia",
               "",
               "Àkókò Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Àkókò Àfɛnukò Armenia",
               "",
               "Àkókò Sɔmà Arabia",
               "",
               "Àkókò Armenia",
               "",
            };
        final String[] Chatham = new String[] {
               "Àkókò Àfɛnukò Chatam",
               "",
               "Àkókò Ojúmɔmɔ Chatam",
               "",
               "Àkókò Chatam",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Àpapɔ̀ Àkókò Àgbáyé",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Àkókò Àfɛnukò Georgia",
               "",
               "Àkókò Sɔmà Georgia",
               "",
               "Àkókò Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Àkókò Àfɛnukò Íkósíkì",
               "",
               "Àkókò Sɔmà Íkúsíkì",
               "",
               "Àkókò Íkósíkì",
               "",
            };
        final String[] Magadan = new String[] {
               "Àkókò Àfɛnukò Magadani",
               "",
               "Àkókò Sɔmà Magadani",
               "",
               "Àkókò Magadani",
               "",
            };
        final String[] Norfolk = new String[] {
               "Àkókò Àfɛnukò Erékùsù Norfolk",
               "",
               "Àkókò Ojúmɔmɔ Erékùsù Norfolk",
               "",
               "Àkókò Erékùsù Norfolk",
               "",
            };
        final String[] Reunion = new String[] {
               "Àkókò Rɛ́yúníɔ́nì",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Àkókò Àwɔn Erekusu Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Àkókò Àfɛnukò Úrúgúwè",
               "",
               "Aago Soma Uruguay",
               "",
               "Aago Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Àkókò Àfɛnukò Fanuatu",
               "",
               "Àkókò Sɔmà Fanuatu",
               "",
               "Àkókò Fanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Àkókò Àfɛnukò Yatutsk",
               "",
               "Àkókò Sɔmà Yatutsk",
               "",
               "Àkókò Yatutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Àkókò àsikò Àtìláńtíìkì",
               "AST",
               "Àkókò Ìyálɛta Àtìláńtíìkì",
               "AST",
               "Àkókò Àtìláńtíìkì",
               "AST",
            };
        final String[] Chamorro = new String[] {
               "Àkókò Àfɛnukò Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Falkland = new String[] {
               "Àkókò Àfɛnukò Etíkun Fókílándì",
               "",
               "Àkókò Ooru Etíkun Fókílándì",
               "",
               "Àkókò Fókílándì",
               "",
            };
        final String[] Mongolia = new String[] {
               "Àkókò Ìfɛnukòsí Ulaanbaatar",
               "",
               "Àkókò Sɔmà Ulaanbaatar",
               "",
               "Àkókò Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Àkókò Àfɛnukò Pakistani",
               "PKT",
               "Àkókò Sɔmà Pakistani",
               "PKST",
               "Àkókò Pakistani",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Àkókò Àfɛnukò Párágúwè",
               "",
               "Àkókò Ooru Párágúwè",
               "",
               "Àkókò Párágúwè",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Àkókò Àfɛnukò Sakhalin",
               "",
               "Àkókò Sɔmà Sakhalin",
               "",
               "Àkókò Sakhalin",
               "",
            };
        final String[] Argentina = new String[] {
               "Aago àsìkò Argentina",
               "",
               "Aago Soma Argentina",
               "",
               "Aago Ajɛntìnà",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Àkókò Ìfɛnukòsí Hong Kong",
               "HKT",
               "Àkókò Sɔmà Hong Kong",
               "HKST",
               "Àkókò Hong Kong",
               "HKT",
            };
        final String[] Lord_Howe = new String[] {
               "Àkókò Àfɛnukò Lord Howe",
               "",
               "Àkókò Ojúmɔmɔ Lord Howe",
               "",
               "Àkókò Lord Howe",
               "",
            };
        final String[] Mauritius = new String[] {
               "Àkókò Àfɛnukò Máríshúshì",
               "",
               "Àkókò Ooru Máríshúshì",
               "",
               "Àkókò Máríshúshì",
               "",
            };
        final String[] Singapore = new String[] {
               "Àkókò Àfɛnukò Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Àkókò Àfɛnukò Foligogiradi",
               "MSK",
               "Àkókò Sɔmà Foligogiradi",
               "MSK",
               "Àkókò Foligogiradi",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Àkókò Àfɛnukò Azerbaijan",
               "",
               "Àkókò Sɔmà Azerbaijan",
               "",
               "Àkókò Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Àkókò Àfɛnukò Bangladesh",
               "",
               "Àkókò Sɔmà Bangladesh",
               "",
               "Àkókò Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Àkókò Àfɛnukò Képú Fáàdì",
               "",
               "Àkókò Ɛ̀rún Képú Fáàdì",
               "",
               "Àkókò Képú Fáàdì",
               "",
            };
        final String[] Seychelles = new String[] {
               "Àkókò Sèshɛ́ɛ̀lì",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Àkókò Àfɛnukò Usibekistani",
               "",
               "Àkókò Sɔmà Usibekistani",
               "",
               "Àkókò Usibekistani",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Àkókò Àfɛnukò Krasinoyasiki",
               "",
               "Àkókò Sɔmà Krasinoyasiki",
               "",
               "Àkókò Krasinoyasiki",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Àkókò Àfɛnukò New zealand",
               "NZST",
               "Àkókò Ojúmɔmɔ New Zealand",
               "NZDT",
               "Àkókò New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Àkókò Àfɛnukò Nofosibiriki",
               "",
               "Àkókò Sɔmà Noforibisiki",
               "",
               "Àkókò Nofosibiriski",
               "",
            };
        final String[] Philippines = new String[] {
               "Àkókò Àfɛnukò Filipininni",
               "PST",
               "Àkókò Sɔmà Filipininni",
               "PDT",
               "Àkókò Filipininni",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Àkókò Àfɛnukò Filadifositoki",
               "",
               "Àkókò Sɔmà Filadifositoki",
               "",
               "Àkókò Filadifositoki",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Àkókò Àwɔn Erekusu Laini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Àkókò Àfɛnukò Newfoundland",
               "NST",
               "Àkókò Ojúmɔmɔ Newfoundland",
               "NDT",
               "Àkókò Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Àkókò Àfɛnukò Turkimenistani",
               "",
               "Àkókò Sɔmà Turkmenistani",
               "",
               "Àkókò Turkimenistani",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Àkókò Àfɛnukò Kalidonia Tuntun",
               "",
               "Àkókò Sɔma Kalidonia Tuntun",
               "",
               "Àkókò Kalidonia Tuntun",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Àkókò Gúsù Jɔ́jíà",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Àkókò Àfɛnukò Yekaterinburg",
               "",
               "Àkókò Sɔmà Yekaterinburg",
               "",
               "Àkókò Yekaterinburg",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Àkókò Ìwɔ̀-Oòrùn Àfɛnukò Afírikà",
               "WAT",
               "Àkókò Ìwɔ̀-Oòrùn Ooru Afírikà",
               "WAT",
               "Àkókò Ìwɔ̀-Oòrùn Afírikà",
               "WAT",
            };
        final String[] Europe_Central = new String[] {
               "Àkókò Àárin àsikò Europe",
               "CET",
               "Àkókò Àárin Sɔmà Europe",
               "CEST",
               "Àkókò Àárin Europe",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Àkókò àsikò Ìhà Ìlà Oòrùn Europe",
               "EET",
               "Àkókò Sɔmà Ìha Ìlà Oòrùn Europe",
               "EEST",
               "Àkókò Ìhà Ìlà Oòrùn Europe",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Àkókò àsikò Ìwɔ Oòrùn Europe",
               "WET",
               "Àkókò Sɔmà Ìhà Ìwɔ Oòrùn Europe",
               "WEST",
               "Àkókò Ìwɔ Oòrùn Europe",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Àkókò Àfɛnukò Pásífíìkì Mɛ́síkò",
               "MST",
               "Àkókò Ojúmɔmɔ Pásífíìkì Mɛ́síkò",
               "MDT",
               "Àkókò Pásífíìkì Mɛ́shíkò",
               "MT",
            };
        final String[] America_Central = new String[] {
               "àkókò asiko àárín gbùngbùn",
               "CST",
               "Akókò àárín gbùngbùn ojúmɔmɔ",
               "CDT",
               "àkókò àárín gbùngbùn",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Akókò Àsikò Ìha Ìla Oòrùn",
               "EST",
               "Àkókò ojúmɔmɔ Ìhà Ìlà Oòrun",
               "EST",
               "Àkókò ìhà ìlà oòrùn",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Àkókò àsikò Pàsífíìkì",
               "PST",
               "Àkókò Ìyálɛta Pàsífíìkì",
               "PDT",
               "Àkókò Pàsífíìkì",
               "PT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Àkókò Àwɔn Erekusu Gilibati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Àkókò Àfɛnukò Hawaii-Aleutian",
               "HST",
               "Àkókò Ojúmɔmɔ Hawaii-Aleutian",
               "HST",
               "Àkókò Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Àkókò Àwɔn Erékùsù Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Àkókò Àfɛnukò Pierre & Miquelon",
               "",
               "Àkókò Ojúmɔmɔ Pierre & Miquelon",
               "",
               "Àkókò Pierre & Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Àkókò asiko òkè",
               "MST",
               "Àkókò ojúmɔmɔ Ori-òkè",
               "MST",
               "Àkókò òkè",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Àkókò Àwɔn Erekusu Masaali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Àkókò Àfɛnukò Ààrin Gùngùn Australia",
               "ACST",
               "Àkókò Ojúmɔmɔ Ààrin Gùngùn Australia",
               "ACDT",
               "Àkókò Ààrin Gùngùn Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Àkókò Àfɛnukò Ìlà-Oòrùn Australia",
               "AEST",
               "Àkókò Ojúmɔmɔ Ìlà-Oòrùn Australia",
               "AEDT",
               "Àkókò Ìlà-Oòrùn Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Àkókò Àfɛnukò Ìwɔ̀-Oòrùn Australia",
               "AWST",
               "Àkókò Ojúmɔmɔ Ìwɔ̀-Oòrùn Australia",
               "AWDT",
               "Àkókò Ìwɔ̀-Oòrùn Australia",
               "AWT",
            };
        final String[] Indonesia_Western = new String[] {
               "Àkókò Ìwɔ̀ oorùn Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Àkókò Àfɛnukò Ààrin Gùngùn Ìwɔ̀-Oòrùn Australia",
               "",
               "Àkókò Ojúmɔmɔ Ààrin Gùngùn Ìwɔ̀-Oòrùn Australia",
               "",
               "Àkókò Ààrin Gùngùn Ìwɔ̀-Oòrùn Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Sɔmà Gɛɛsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BST", Bangladesh },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Àpapɔ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Àfɛnukò Airiisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Àpapɔ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/UCT",
                new String[] {
                    "Àpapɔ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Sɔmà Gɛɛsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/Zulu",
                new String[] {
                    "Àpapɔ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Àpapɔ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Yangon", Cocos },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Douala", Africa_Western },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Universal",
                new String[] {
                    "Àpapɔ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Àfɛnukò Airiisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Sɔmà Gɛɛsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Sɔmà Gɛɛsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Sɔmà Gɛɛsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Antigua", Atlantic },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Sɔmà Gɛɛsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Europe/Isle_of_Man",
                new String[] {
                    "",
                    "GMT",
                    "Àkókò Sɔmà Gɛɛsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Pacific/Guadalcanal", Solomon },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Ìlú Àìmɔ̀" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.America/Boise", "ìlú Bɔ́isè" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Belize", "ìlú Bɛ̀líìsì" },
            { "timezone.excity.America/Creston", "ìlú Kírɛstɔ́ɔ̀nù" },
            { "timezone.excity.America/Curacao", "ìlú Kurashao" },
            { "timezone.excity.America/Marigot", "ìlú Marigɔ́ɔ̀tì" },
            { "timezone.excity.America/Barbados", "ìlú Bábádɔ́ɔ̀sì" },
            { "timezone.excity.America/Miquelon", "ìlú Mikulɔ́nì" },
            { "timezone.excity.America/St_Johns", "ìlú St Jɔ́ɔ̀nù" },
            { "timezone.excity.Atlantic/Bermuda", "ìlú Bɛ̀múdà" },
            { "timezone.excity.America/Anchorage", "ìlú Ankɔ́réèjì" },
            { "timezone.excity.America/Chihuahua", "ìlú Shihuahua" },
            { "timezone.excity.America/St_Thomas", "ìlú St Tɔ́màsì" },
            { "timezone.excity.America/Kralendijk", "ìlú Kíralɛ́ndáikì" },
            { "timezone.excity.America/Mexico_City", "ìlú Mɛ́síkò" },
            { "timezone.excity.America/Blanc-Sablon", "ìlú Blank Sabulɔ́ɔ̀nì" },
            { "timezone.excity.America/Indiana/Knox", "ìlú nɔ́sì" },
            { "timezone.excity.America/Coral_Harbour", "ìlú àtikɔkàn" },
            { "timezone.excity.America/Swift_Current", "ìlú Súfítù Kɔ̀rentì" },
            { "timezone.excity.America/Bahia_Banderas", "ìlú Báhì Bándɛ́rásì" },
            { "timezone.excity.America/Indiana/Marengo", "ìlú Marɛ́ngo" },
            { "timezone.excity.America/Kentucky/Monticello", "ìlú Montisɛ́lò" },
        };
        return data;
    }
}
