/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.Maintainer;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;

public class HelmServiceUtil {
    private static final String PROPERTY_ICON = "jkube.helm.icon";
    private static final String PROPERTY_TYPE = "jkube.helm.type";
    private static final String PROPERTY_CHART = "jkube.helm.chart";
    private static final String PROPERTY_CHART_EXTENSION = "jkube.helm.chartExtension";
    private static final String DEFAULT_CHART_EXTENSION = "tar.gz";
    private static final String PROPERTY_VERSION = "jkube.helm.version";
    private static final String PROPERTY_DESCRIPTION = "jkube.helm.description";
    private static final String PROPERTY_SOURCE_DIR = "jkube.helm.sourceDir";
    private static final String PROPERTY_OUTPUT_DIR = "jkube.helm.outputDir";
    private static final String PROPERTY_TARBALL_OUTPUT_DIR = "jkube.helm.tarballOutputDir";
    private static final String PROPERTY_TARBALL_CLASSIFIER = "jkube.helm.tarFileClassifier";
    private static final String PROPERTY_HOME = "jkube.helm.home";
    protected static final String PROPERTY_UPLOAD_REPO_NAME = "jkube.helm.%s.name";
    protected static final String PROPERTY_UPLOAD_REPO_URL = "jkube.helm.%s.url";
    protected static final String PROPERTY_UPLOAD_REPO_USERNAME = "jkube.helm.%s.username";
    protected static final String PROPERTY_UPLOAD_REPO_PASSWORD = "jkube.helm.%s.password";
    protected static final String PROPERTY_UPLOAD_REPO_TYPE = "jkube.helm.%s.type";
    protected static final String STABLE_REPOSITORY = "stableRepository";
    protected static final String SNAPSHOT_REPOSITORY = "snapshotRepository";
    protected static final String PROPERTY_SECURITY = "jkube.helm.security";
    protected static final String DEFAULT_SECURITY = "~/.m2/settings-security.xml";

    private HelmServiceUtil() {
    }

    public static HelmConfig.HelmConfigBuilder initHelmConfig(HelmConfig.HelmType defaultHelmType, JavaProject project, File manifest, File template, HelmConfig original) throws IOException {
        if (original == null) {
            original = new HelmConfig();
        }
        original.setChart(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_CHART, project, original::getChart, project.getArtifactId()));
        original.setChartExtension(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_CHART_EXTENSION, project, original::getChartExtension, DEFAULT_CHART_EXTENSION));
        original.setVersion(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_VERSION, project, original::getVersion, project.getVersion()));
        original.setDescription(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_DESCRIPTION, project, original::getDescription, project.getDescription()));
        original.setHome(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_HOME, project, original::getHome, project.getUrl()));
        if (original.getSources() == null) {
            original.setSources(project.getScmUrl() != null ? Collections.singletonList(project.getScmUrl()) : Collections.emptyList());
        }
        if (original.getMaintainers() == null && project.getMaintainers() != null) {
            original.setMaintainers(project.getMaintainers().stream().filter(m -> StringUtils.isNotBlank((CharSequence)m.getName()) || StringUtils.isNotBlank((CharSequence)m.getEmail())).map(m -> new Maintainer(m.getName(), m.getEmail())).collect(Collectors.toList()));
        }
        original.setIcon(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_ICON, project, original::getIcon, HelmServiceUtil.findIconURL(manifest)));
        original.setAdditionalFiles(HelmServiceUtil.getAdditionalFiles(original, project));
        if (original.getParameterTemplates() == null) {
            original.setParameterTemplates(HelmServiceUtil.findTemplates(template));
        }
        original.setTypes(HelmServiceUtil.resolveHelmTypes(defaultHelmType, project));
        original.setSourceDir(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_SOURCE_DIR, project, original::getSourceDir, String.format("%s/META-INF/jkube/", project.getOutputDirectory())));
        original.setOutputDir(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_OUTPUT_DIR, project, original::getOutputDir, String.format("%s/jkube/helm/%s", project.getBuildDirectory(), original.getChart())));
        original.setTarFileClassifier(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_TARBALL_CLASSIFIER, project, original::getTarFileClassifier, ""));
        original.setTarballOutputDir(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_TARBALL_OUTPUT_DIR, project, original::getTarballOutputDir, original.getOutputDir()));
        return original.toBuilder();
    }

    public static HelmConfig initHelmPushConfig(HelmConfig helmConfig, JavaProject project) {
        if (helmConfig == null) {
            helmConfig = new HelmConfig();
        }
        helmConfig.setStableRepository(HelmServiceUtil.initHelmRepository(helmConfig.getStableRepository(), project, STABLE_REPOSITORY));
        helmConfig.setSnapshotRepository(HelmServiceUtil.initHelmRepository(helmConfig.getSnapshotRepository(), project, SNAPSHOT_REPOSITORY));
        helmConfig.setSecurity(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_SECURITY, project, helmConfig::getSecurity, DEFAULT_SECURITY));
        return helmConfig;
    }

    static HelmRepository initHelmRepository(HelmRepository helmRepository, JavaProject project, String repositoryType) {
        HelmRepository resolvedHelmRepository = helmRepository;
        if (helmRepository == null) {
            resolvedHelmRepository = new HelmRepository();
        }
        resolvedHelmRepository.setType(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_TYPE, repositoryType), project, resolvedHelmRepository::getTypeAsString, null));
        resolvedHelmRepository.setName(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_NAME, repositoryType), project, resolvedHelmRepository::getName, null));
        resolvedHelmRepository.setUrl(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_URL, repositoryType), project, resolvedHelmRepository::getUrl, null));
        resolvedHelmRepository.setUsername(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_USERNAME, repositoryType), project, resolvedHelmRepository::getUsername, null));
        resolvedHelmRepository.setPassword(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_PASSWORD, repositoryType), project, resolvedHelmRepository::getPassword, null));
        return resolvedHelmRepository;
    }

    static List<HelmConfig.HelmType> resolveHelmTypes(HelmConfig.HelmType defaultHelmType, JavaProject project) {
        List helmTypes = Optional.ofNullable(JKubeProjectUtil.getProperty((String)PROPERTY_TYPE, (JavaProject)project)).filter(StringUtils::isNotBlank).map(types -> StringUtils.split((String)types, (String)",")).map(Stream::of).map(s -> s.map(prop -> HelmConfig.HelmType.valueOf(prop.trim().toUpperCase())).collect(Collectors.toList())).orElse(null);
        if (helmTypes == null || helmTypes.isEmpty()) {
            return Collections.singletonList(defaultHelmType);
        }
        return helmTypes;
    }

    static String resolveFromPropertyOrDefault(String property, JavaProject project, Supplier<String> getter, String defaultValue) {
        return Optional.ofNullable(JKubeProjectUtil.getProperty((String)property, (JavaProject)project)).filter(StringUtils::isNotBlank).orElse(Optional.ofNullable(getter.get()).filter(StringUtils::isNotBlank).orElse(defaultValue));
    }

    static List<File> getAdditionalFiles(HelmConfig helm, JavaProject project) {
        ArrayList<File> additionalFiles = new ArrayList<File>();
        if (helm.getAdditionalFiles() != null) {
            additionalFiles.addAll(helm.getAdditionalFiles());
        }
        HelmServiceUtil.firstProjectFile("README", project).ifPresent(additionalFiles::add);
        HelmServiceUtil.firstProjectFile("LICENSE", project).ifPresent(additionalFiles::add);
        return additionalFiles;
    }

    static Optional<File> firstProjectFile(String fileName, JavaProject project) {
        FilenameFilter filter = (dir, name) -> {
            String lower = name.toLowerCase(Locale.ENGLISH);
            return lower.equalsIgnoreCase(fileName) || lower.startsWith(fileName.toLowerCase() + ".");
        };
        return Optional.ofNullable(project.getBaseDirectory().listFiles(filter)).filter(files -> ((File[])files).length > 0).map(files -> files[0]);
    }

    static String findIconURL(File manifest) {
        String answer = null;
        if (manifest != null && manifest.isFile()) {
            KubernetesResource dto;
            try {
                dto = ResourceUtil.load((File)manifest, KubernetesResource.class);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load kubernetes YAML " + manifest + ". " + e, e);
            }
            if (dto instanceof HasMetadata) {
                Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)((HasMetadata)dto));
                answer = HelmServiceUtil.getJKubeIconUrlFromAnnotations(annotations);
            }
            answer = HelmServiceUtil.extractIconUrlAnnotationFromKubernetesList(answer, dto);
        }
        return answer;
    }

    static List<Template> findTemplates(File templateDir) throws IOException {
        ArrayList<Template> ret = new ArrayList<Template>();
        File[] sourceFiles = templateDir != null && templateDir.isDirectory() ? templateDir.listFiles((dir, filename) -> filename.endsWith("-template.yml")) : (templateDir != null ? new File[]{templateDir} : new File[]{});
        for (File sourceFile : Objects.requireNonNull(sourceFiles, "No template files found in the provided directory")) {
            KubernetesResource dto = ResourceUtil.load((File)sourceFile, KubernetesResource.class);
            if (dto instanceof Template) {
                ret.add((Template)dto);
                continue;
            }
            if (!(dto instanceof KubernetesList)) continue;
            Optional.ofNullable(((KubernetesList)dto).getItems()).map(Collection::stream).map(items -> items.filter(Template.class::isInstance).map(Template.class::cast).collect(Collectors.toList())).ifPresent(ret::addAll);
        }
        return ret;
    }

    static HelmRepository selectHelmRepository(HelmConfig helmConfig) {
        if (helmConfig.getVersion() != null && helmConfig.getVersion().endsWith("-SNAPSHOT")) {
            return helmConfig.getSnapshotRepository();
        }
        return helmConfig.getStableRepository();
    }

    static boolean isRepositoryValid(HelmRepository repository) {
        return repository != null && repository.getType() != null && StringUtils.isNotBlank((CharSequence)repository.getName()) && StringUtils.isNotBlank((CharSequence)repository.getUrl());
    }

    static void setAuthentication(HelmRepository repository, KitLogger logger, List<RegistryServerConfiguration> registryServerConfigurations, UnaryOperator<String> passwordDecrypter) {
        String id = repository.getName();
        String REPO = "Repo ";
        if (repository.getUsername() != null) {
            if (repository.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " has a username but no password defined.");
            }
            logger.debug("Repo " + id + " has credentials defined, skip searching in server list.", new Object[0]);
        } else {
            RegistryServerConfiguration server = registryServerConfigurations.stream().filter(r -> r.getId().equals(id)).findAny().orElse(null);
            if (server == null) {
                throw new IllegalArgumentException("No credentials found for " + id + " in configuration or settings.xml server list.");
            }
            logger.debug("Use credentials from server list for " + id + ".", new Object[0]);
            if (server.getUsername() == null || server.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " was found in server list but has no username/password.");
            }
            repository.setUsername(server.getUsername());
            repository.setPassword((String)passwordDecrypter.apply(server.getPassword()));
        }
    }

    private static String extractIconUrlAnnotationFromKubernetesList(String answer, KubernetesResource dto) {
        block1: {
            HasMetadata item;
            Map annotations;
            KubernetesList list;
            List items;
            if (!StringUtils.isBlank((CharSequence)answer) || !(dto instanceof KubernetesList) || (items = (list = (KubernetesList)dto).getItems()) == null) break block1;
            Iterator iterator = items.iterator();
            while (iterator.hasNext() && !StringUtils.isNotBlank((CharSequence)(answer = HelmServiceUtil.getJKubeIconUrlFromAnnotations(annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)(item = (HasMetadata)iterator.next())))))) {
            }
        }
        return answer;
    }

    private static String getJKubeIconUrlFromAnnotations(Map<String, String> annotations) {
        if (annotations.containsKey(JKubeAnnotations.ICON_URL.value(true))) {
            return annotations.get(JKubeAnnotations.ICON_URL.value(true));
        }
        if (annotations.containsKey(JKubeAnnotations.ICON_URL.value())) {
            return annotations.get(JKubeAnnotations.ICON_URL.value());
        }
        return null;
    }
}

