/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactory;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Map;
import java.util.Properties;

public class Client2
extends PMClientBase {
    Properties props = null;

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void autoCloseableTest() throws Exception {
        EntityManagerFactory emf = null;
        try (EntityManagerFactory emfLocal = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.getPersistenceUnitProperties());){
            emf = emfLocal;
            if (emf == null) {
                throw new Exception("autoCloseableTest failed: createEntityManagerFactory(String) returned null");
            }
            if (!emf.isOpen()) {
                throw new Exception("autoCloseableTest failed: EntityManagerFactory isOpen() returned false in try block");
            }
        }
        catch (Exception f) {
            throw f;
        }
        catch (Throwable t) {
            throw new Exception("autoCloseableTest failed with Exception", t);
        }
        finally {
            if (emf != null && emf.isOpen()) {
                throw new Exception("autoCloseableTest failed: EntityManagerFactory isOpen() returned true outside try block");
            }
        }
    }

    public void getMetamodelTest() throws Exception {
        boolean pass = false;
        try {
            Metamodel mm = this.getEntityManager().getEntityManagerFactory().getMetamodel();
            if (mm == null) {
                this.logErr("getMetamodel() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getMetamodelTest failed");
        }
    }

    public void getPersistenceUnitUtil() throws Exception {
        boolean pass = false;
        try {
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            if (puu == null) {
                this.logErr("getPersistenceUnitUtil() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getPersistenceUnitUtil failed");
        }
    }

    public void getCriteriaBuilderTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
            if (cbuilder != null) {
                this.getEntityTransaction().begin();
                CriteriaQuery cquery = cbuilder.createQuery();
                if (cquery != null) {
                    this.logTrace("Obtained Non-null Criteria Query");
                    pass = true;
                } else {
                    this.logErr("Failed to get Non-null Criteria Query");
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("getCriteriaBuilder() returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getCriteriaBuilderTest failed");
        }
    }
}

