/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.net.URI;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.handly.junit.NoJobsWorkspaceTestCase;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.jface.text.IDocumentExtension4;

public class FileStoreTextFileBufferSnapshotTest
extends NoJobsWorkspaceTestCase {
    private IFileStore fileStore;
    private ITextFileBuffer buffer;
    private ITextFileBufferManager bufferManager = ITextFileBufferManager.DEFAULT;
    private TextFileBufferSnapshot snapshot;

    protected void setUp() throws Exception {
        super.setUp();
        IProject p = this.setUpProject("Test002");
        this.fileStore = EFS.getStore((URI)p.getFile("x.txt").getLocationURI());
        this.bufferManager.connectFileStore(this.fileStore, null);
        this.buffer = this.bufferManager.getFileStoreTextFileBuffer(this.fileStore);
        this.snapshot = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
    }

    protected void tearDown() throws Exception {
        this.bufferManager.disconnectFileStore(this.fileStore, null);
        super.tearDown();
    }

    public void test1() throws Exception {
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        IDocumentExtension4 document = (IDocumentExtension4)this.buffer.getDocument();
        long modificationStamp = document.getModificationStamp();
        document.replace(0, 0, "", modificationStamp + 1L);
        document.replace(0, 0, "", modificationStamp);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
        modificationStamp = document.getModificationStamp();
        document.replace(0, 0, "", modificationStamp + 1L);
        document.replace(0, 0, "", modificationStamp);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
    }

    public void test2() throws Exception {
        this.bufferManager.disconnectFileStore(this.fileStore, null);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
    }

    public void test3() throws Exception {
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
        this.bufferManager.disconnectFileStore(this.fileStore, null);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        this.bufferManager.connectFileStore(this.fileStore, null);
        ITextFileBuffer newBuffer = this.bufferManager.getFileStoreTextFileBuffer(this.fileStore);
        newBuffer.getDocument().replace(0, "hello".length(), "good bye");
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        FileStoreTextFileBufferSnapshotTest.assertFalse((boolean)"good bye".equals(snapshot2.getContents()));
    }

    public void test4() throws Exception {
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        this.buffer.commit(null, true);
        this.bufferManager.disconnectFileStore(this.fileStore, null);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
    }

    public void test5() throws Exception {
        this.buffer.getDocument().replace("hello".length(), 0, ", world!");
        this.buffer.commit(null, true);
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.buffer, this.bufferManager);
        this.bufferManager.disconnectFileStore(this.fileStore, null);
        FileStoreTextFileBufferSnapshotTest.assertEquals((String)"hello, world!", (String)snapshot2.getContents());
    }
}

