/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.support.Body;
import org.eclipse.handly.model.impl.support.IElementDeltaBuilder;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;

public class SourceElementBody
extends Body
implements ISourceElementInfo {
    private static final InternalProperty[] NO_PROPERTIES = new InternalProperty[0];
    private ISnapshot snapshot;
    private InternalProperty[] properties = NO_PROPERTIES;
    private TextRange fullRange;
    private TextRange identifyingRange;

    @Override
    public ISourceConstruct[] getChildren() {
        IElement[] children = super.getChildren();
        if (children instanceof ISourceConstruct[]) {
            return (ISourceConstruct[])children;
        }
        int length = children.length;
        ISourceConstruct[] result = new ISourceConstruct[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public <T> T get(Property<T> p) {
        return (T)this.getPropertyValue(p.getName());
    }

    @Override
    public ISnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public TextRange getFullRange() {
        return this.fullRange;
    }

    @Override
    public TextRange getIdentifyingRange() {
        return this.identifyingRange;
    }

    public <T> void set(Property<T> p, T value) {
        String name = p.getName();
        int length = this.properties.length;
        if (length == 0) {
            this.properties = new InternalProperty[]{new InternalProperty(name, value)};
        } else {
            int i = 0;
            while (i < length) {
                if (this.properties[i].name.equals(name)) {
                    this.properties[i].value = value;
                    return;
                }
                ++i;
            }
            InternalProperty[] newProperties = new InternalProperty[length + 1];
            System.arraycopy(this.properties, 0, newProperties, 0, length);
            newProperties[length] = new InternalProperty(name, value);
            this.properties = newProperties;
        }
    }

    public void setSnapshot(ISnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public void setFullRange(TextRange fullRange) {
        this.fullRange = fullRange;
    }

    public void setIdentifyingRange(TextRange identifyingRange) {
        this.identifyingRange = identifyingRange;
    }

    @Override
    public void findContentChange(Body oldBody, IElement element, IElementDeltaBuilder builder) {
        if (element instanceof ISourceFile) {
            ISnapshot oldSnapshot;
            if (!Objects.equals(this.getFullRange(), ((SourceElementBody)oldBody).getFullRange())) {
                builder.changed(element, 33L);
                return;
            }
            ISnapshot snapshot = this.getSnapshot();
            if (!(snapshot == (oldSnapshot = ((SourceElementBody)oldBody).getSnapshot()) || snapshot != null && snapshot.isEqualTo(oldSnapshot))) {
                builder.changed(element, 33L);
                return;
            }
        }
        Set<String> newPropertyNames = this.getPropertyNames();
        Set<String> oldPropertyNames = ((SourceElementBody)oldBody).getPropertyNames();
        HashSet<String> combinedPropertyNames = new HashSet<String>(newPropertyNames.size() + oldPropertyNames.size());
        combinedPropertyNames.addAll(newPropertyNames);
        combinedPropertyNames.addAll(oldPropertyNames);
        for (String propertyName : combinedPropertyNames) {
            Object oldValue;
            Object newValue;
            if (!this.isPropertyChanged(propertyName, newValue = this.getPropertyValue(propertyName), oldValue = ((SourceElementBody)oldBody).getPropertyValue(propertyName))) continue;
            builder.changed(element, 33L);
            return;
        }
    }

    protected boolean isPropertyChanged(String propertyName, Object newValue, Object oldValue) {
        boolean eq;
        return newValue == null ? oldValue != null : !(eq = newValue instanceof Object[] && oldValue instanceof Object[] ? Arrays.equals((Object[])newValue, (Object[])oldValue) : (newValue instanceof byte[] && oldValue instanceof byte[] ? Arrays.equals((byte[])newValue, (byte[])oldValue) : (newValue instanceof short[] && oldValue instanceof short[] ? Arrays.equals((short[])newValue, (short[])oldValue) : (newValue instanceof int[] && oldValue instanceof int[] ? Arrays.equals((int[])newValue, (int[])oldValue) : (newValue instanceof long[] && oldValue instanceof long[] ? Arrays.equals((long[])newValue, (long[])oldValue) : (newValue instanceof char[] && oldValue instanceof char[] ? Arrays.equals((char[])newValue, (char[])oldValue) : (newValue instanceof float[] && oldValue instanceof float[] ? Arrays.equals((float[])newValue, (float[])oldValue) : (newValue instanceof double[] && oldValue instanceof double[] ? Arrays.equals((double[])newValue, (double[])oldValue) : (newValue instanceof boolean[] && oldValue instanceof boolean[] ? Arrays.equals((boolean[])newValue, (boolean[])oldValue) : newValue.equals(oldValue))))))))));
    }

    protected final Object getPropertyValue(String propertyName) {
        int length = this.properties.length;
        int i = 0;
        while (i < length) {
            InternalProperty property = this.properties[i];
            if (property.name.equals(propertyName)) {
                return property.value;
            }
            ++i;
        }
        return null;
    }

    protected final Set<String> getPropertyNames() {
        int length = this.properties.length;
        HashSet<String> names = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            names.add(this.properties[i].name);
            ++i;
        }
        return names;
    }

    void setSnapshot(ISnapshot snapshot, Map<IElement, Object> newElements) {
        this.setSnapshot(snapshot);
        ISourceConstruct[] iSourceConstructArray = this.getChildren();
        int n = iSourceConstructArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceConstruct child = iSourceConstructArray[n2];
            Object childBody = newElements.get(child);
            if (childBody instanceof SourceElementBody) {
                ((SourceElementBody)childBody).setSnapshot(snapshot, newElements);
            }
            ++n2;
        }
    }

    private static class InternalProperty {
        public final String name;
        public Object value;

        public InternalProperty(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

