/******************************************************************************
 * Copyright (c) 2024, 2025 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the terms
 * of the MIT License which is available at https://opensource.org/licenses/MIT
 *
 *  SPDX-License-Identifier: MIT
 *****************************************************************************/

/* ToolDef language for highlight.js 11.9.0. */
(() => {
    var e = (() => {
        "use strict";
        return e => {
            return {
                name: "ToolDef",
                keywords: {
                    keyword: [
                        "as",
                        "bool", "break",
                        "continue",
                        "double",
                        "elif", "else", "end", "exit",
                        "false", "for", "from",
                        "if", "import", "in", "int",
                        "list", "long",
                        "map",
                        "null",
                        "object",
                        "return",
                        "set", "string",
                        "tool", "true", "tuple", "type",
                        "while",
                    ],
                    built_in: [
                        // I/O tools.
                        "err", "errln", "out", "outln",

                        // Generic tools.
                        "app", "exec", "tooldef",

                        // Path tools.
                        "abspath", "basename", "chdir", "chfileext", "curdir", "dirname",
                        "fileext", "hasfileext", "pathjoin", "scriptpath",

                        // File tools.
                        "cpdir", "cpfile", "diff", "exists", "filenewer", "filesize",
                        "find", "isdir", "isfile", "mkdir", "mvdir", "mvfile", "readlines",
                        "rmdir", "rmfile", "writefile",

                        // Data tools.
                        "abs",
                        "ceil", "contains",
                        "del", "delidx",
                        "empty", "endswith", "entries", "enumerate",
                        "floor", "fmt",
                        "indexof",
                        "join",
                        "keys",
                        "lastindexof", "ln", "log", "lower", "ltrim",
                        "max", "min",
                        "pow",
                        "range", "replace", "reverse", "round", "rtrim",
                        "size", "sorted", "split", "sqrt", "startswith", "str", "strdup", "subset",
                        "trim",
                        "upper",
                        "values",
                    ],
                    operator: [
                        "and", "div", "mod", "not", "or",
                    ]
                },
                contains: [
                    // Numbers.
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)(([.][0-9]+)?[eE][-+]?[0-9]+)\b/,
                    },
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)([.][0-9]+)\b/,
                    },
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)\b/,
                    },

                    // Comments.
                    {
                        scope: "comment",
                        begin: '//',
                        end: '$',
                    },
                    {
                        scope: "comment",
                        begin: '/\\*',
                        end: '\\*/',
                    },

                    // Strings, with escapes and format patterns.
                    {
                        scope: "string",
                        begin: '"',
                        end: '"',
                        contains: [
                            {
                                scope: "char.escape",
                                match: /\\[nt\\"]/,
                            },
                            {
                                scope: "regex",
                                match: /%([0-9]+[$])?[-+ 0,]*[0-9]*([.][0-9]+)?[bBdxXeEfgGsS]/,
                            },
                            {
                                scope: "char.escape",
                                match: '%%',
                            }
                        ]
                    },

                    // Escaped keywords should be identifiers.
                    {
                        scope: "escaped-keyword",
                        match: /[$]\b[A-Za-z_][A-Za-z0-9_]*\b/,
                    }
                ]
            }
        }
    })();
    hljs.registerLanguage("tooldef", e)
})();
