/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.filer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.apt.pluggable.core.Apt6Plugin;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class IdeClassOutputStream
extends ByteArrayOutputStream {
    private final IdeProcessingEnvImpl _env;
    private final IFile _file;

    public IdeClassOutputStream(IdeProcessingEnvImpl env, IFile file) {
        this._env = env;
        this._file = file;
    }

    @Override
    public void close() throws IOException {
        super.close();
        byte[] byteArray = this.toByteArray();
        Compiler compiler = this._env.getCompiler();
        ClassFileReader binaryType = null;
        try {
            FileSystemUtil.saveToDisk((IFile)this._file, (byte[])byteArray);
            binaryType = ClassFileReader.read((String)this._file.getLocation().toString());
            char[][] splitOn = CharOperation.splitOn((char)'/', (char[])binaryType.getName());
            ReferenceBinding type = compiler.lookupEnvironment.getType(splitOn);
            if (type != null && type.isValidBinding()) {
                if (type.isBinaryBinding()) {
                    this._env.addNewClassFile(type);
                } else {
                    BinaryTypeBinding binaryBinding = new BinaryTypeBinding(type.getPackage(), (IBinaryType)binaryType, compiler.lookupEnvironment, true);
                    if (binaryBinding != null) {
                        this._env.addNewClassFile((ReferenceBinding)binaryBinding);
                    }
                }
            }
        }
        catch (Exception ex) {
            Apt6Plugin.log(ex, "Could not create generated class file " + this._file.getName());
        }
    }
}

